<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcknowledgementReactionInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AcknowledgementReactionInfo
 * @subpackage Structs
 */
class AcknowledgementReactionInfo extends AbstractStructBase
{
    /**
     * The AcknowlegementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AcknowlegementId;
    /**
     * The UserReactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserReactionId;
    /**
     * Constructor method for AcknowledgementReactionInfo
     * @uses AcknowledgementReactionInfo::setAcknowlegementId()
     * @uses AcknowledgementReactionInfo::setUserReactionId()
     * @param string $acknowlegementId
     * @param string $userReactionId
     */
    public function __construct($acknowlegementId = null, $userReactionId = null)
    {
        $this
            ->setAcknowlegementId($acknowlegementId)
            ->setUserReactionId($userReactionId);
    }
    /**
     * Get AcknowlegementId value
     * @return string|null
     */
    public function getAcknowlegementId()
    {
        return $this->AcknowlegementId;
    }
    /**
     * Set AcknowlegementId value
     * @param string $acknowlegementId
     * @return \patest\StructType\AcknowledgementReactionInfo
     */
    public function setAcknowlegementId($acknowlegementId = null)
    {
        // validation for constraint: string
        if (!is_null($acknowlegementId) && !is_string($acknowlegementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acknowlegementId, true), gettype($acknowlegementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($acknowlegementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $acknowlegementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($acknowlegementId, true)), __LINE__);
        }
        $this->AcknowlegementId = $acknowlegementId;
        return $this;
    }
    /**
     * Get UserReactionId value
     * @return string|null
     */
    public function getUserReactionId()
    {
        return $this->UserReactionId;
    }
    /**
     * Set UserReactionId value
     * @param string $userReactionId
     * @return \patest\StructType\AcknowledgementReactionInfo
     */
    public function setUserReactionId($userReactionId = null)
    {
        // validation for constraint: string
        if (!is_null($userReactionId) && !is_string($userReactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userReactionId, true), gettype($userReactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userReactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userReactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userReactionId, true)), __LINE__);
        }
        $this->UserReactionId = $userReactionId;
        return $this;
    }
}
