<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.SoldSubscriptionInfo StructType
 * @subpackage Structs
 */
class AccessControl_SoldSubscriptionInfo extends AccessControl_SoldItemInfo
{
    /**
     * The ExtensionOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtensionOfInstanceId;
    /**
     * The RenewOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewOfInstanceId;
    /**
     * Constructor method for AccessControl.SoldSubscriptionInfo
     * @uses AccessControl_SoldSubscriptionInfo::setExtensionOfInstanceId()
     * @uses AccessControl_SoldSubscriptionInfo::setRenewOfInstanceId()
     * @param string $extensionOfInstanceId
     * @param string $renewOfInstanceId
     */
    public function __construct($extensionOfInstanceId = null, $renewOfInstanceId = null)
    {
        $this
            ->setExtensionOfInstanceId($extensionOfInstanceId)
            ->setRenewOfInstanceId($renewOfInstanceId);
    }
    /**
     * Get ExtensionOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtensionOfInstanceId()
    {
        return isset($this->ExtensionOfInstanceId) ? $this->ExtensionOfInstanceId : null;
    }
    /**
     * Set ExtensionOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extensionOfInstanceId
     * @return \patest\StructType\AccessControl_SoldSubscriptionInfo
     */
    public function setExtensionOfInstanceId($extensionOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($extensionOfInstanceId) && !is_string($extensionOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extensionOfInstanceId, true), gettype($extensionOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extensionOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extensionOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extensionOfInstanceId, true)), __LINE__);
        }
        if (is_null($extensionOfInstanceId) || (is_array($extensionOfInstanceId) && empty($extensionOfInstanceId))) {
            unset($this->ExtensionOfInstanceId);
        } else {
            $this->ExtensionOfInstanceId = $extensionOfInstanceId;
        }
        return $this;
    }
    /**
     * Get RenewOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewOfInstanceId()
    {
        return isset($this->RenewOfInstanceId) ? $this->RenewOfInstanceId : null;
    }
    /**
     * Set RenewOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewOfInstanceId
     * @return \patest\StructType\AccessControl_SoldSubscriptionInfo
     */
    public function setRenewOfInstanceId($renewOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewOfInstanceId) && !is_string($renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewOfInstanceId, true), gettype($renewOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewOfInstanceId, true)), __LINE__);
        }
        if (is_null($renewOfInstanceId) || (is_array($renewOfInstanceId) && empty($renewOfInstanceId))) {
            unset($this->RenewOfInstanceId);
        } else {
            $this->RenewOfInstanceId = $renewOfInstanceId;
        }
        return $this;
    }
}
