<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.SoldItemsJob.WorkItem StructType
 * @subpackage Structs
 */
class AccessControl_SoldItemsJob_WorkItem extends Foundation_QueuedWorkItem
{
    /**
     * The ConnectionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionAuditId;
    /**
     * The RetryAttempt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetryAttempt;
    /**
     * The SoldItemsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoldItemsInfo;
    /**
     * The TransactionApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionApplicationChannel;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for AccessControl.SoldItemsJob.WorkItem
     * @uses AccessControl_SoldItemsJob_WorkItem::setConnectionAuditId()
     * @uses AccessControl_SoldItemsJob_WorkItem::setRetryAttempt()
     * @uses AccessControl_SoldItemsJob_WorkItem::setSoldItemsInfo()
     * @uses AccessControl_SoldItemsJob_WorkItem::setTransactionApplicationChannel()
     * @uses AccessControl_SoldItemsJob_WorkItem::setTransactionId()
     * @uses AccessControl_SoldItemsJob_WorkItem::setUserId()
     * @param int $connectionAuditId
     * @param int $retryAttempt
     * @param string $soldItemsInfo
     * @param string $transactionApplicationChannel
     * @param string $transactionId
     * @param string $userId
     */
    public function __construct($connectionAuditId = null, $retryAttempt = null, $soldItemsInfo = null, $transactionApplicationChannel = null, $transactionId = null, $userId = null)
    {
        $this
            ->setConnectionAuditId($connectionAuditId)
            ->setRetryAttempt($retryAttempt)
            ->setSoldItemsInfo($soldItemsInfo)
            ->setTransactionApplicationChannel($transactionApplicationChannel)
            ->setTransactionId($transactionId)
            ->setUserId($userId);
    }
    /**
     * Get ConnectionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionAuditId()
    {
        return isset($this->ConnectionAuditId) ? $this->ConnectionAuditId : null;
    }
    /**
     * Set ConnectionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionAuditId
     * @return \patest\StructType\AccessControl_SoldItemsJob_WorkItem
     */
    public function setConnectionAuditId($connectionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($connectionAuditId) && !(is_int($connectionAuditId) || ctype_digit($connectionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionAuditId, true), gettype($connectionAuditId)), __LINE__);
        }
        if (is_null($connectionAuditId) || (is_array($connectionAuditId) && empty($connectionAuditId))) {
            unset($this->ConnectionAuditId);
        } else {
            $this->ConnectionAuditId = $connectionAuditId;
        }
        return $this;
    }
    /**
     * Get RetryAttempt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetryAttempt()
    {
        return isset($this->RetryAttempt) ? $this->RetryAttempt : null;
    }
    /**
     * Set RetryAttempt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retryAttempt
     * @return \patest\StructType\AccessControl_SoldItemsJob_WorkItem
     */
    public function setRetryAttempt($retryAttempt = null)
    {
        // validation for constraint: int
        if (!is_null($retryAttempt) && !(is_int($retryAttempt) || ctype_digit($retryAttempt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryAttempt, true), gettype($retryAttempt)), __LINE__);
        }
        if (is_null($retryAttempt) || (is_array($retryAttempt) && empty($retryAttempt))) {
            unset($this->RetryAttempt);
        } else {
            $this->RetryAttempt = $retryAttempt;
        }
        return $this;
    }
    /**
     * Get SoldItemsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoldItemsInfo()
    {
        return isset($this->SoldItemsInfo) ? $this->SoldItemsInfo : null;
    }
    /**
     * Set SoldItemsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soldItemsInfo
     * @return \patest\StructType\AccessControl_SoldItemsJob_WorkItem
     */
    public function setSoldItemsInfo($soldItemsInfo = null)
    {
        // validation for constraint: string
        if (!is_null($soldItemsInfo) && !is_string($soldItemsInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soldItemsInfo, true), gettype($soldItemsInfo)), __LINE__);
        }
        if (is_null($soldItemsInfo) || (is_array($soldItemsInfo) && empty($soldItemsInfo))) {
            unset($this->SoldItemsInfo);
        } else {
            $this->SoldItemsInfo = $soldItemsInfo;
        }
        return $this;
    }
    /**
     * Get TransactionApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionApplicationChannel()
    {
        return isset($this->TransactionApplicationChannel) ? $this->TransactionApplicationChannel : null;
    }
    /**
     * Set TransactionApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionApplicationChannel
     * @return \patest\StructType\AccessControl_SoldItemsJob_WorkItem
     */
    public function setTransactionApplicationChannel($transactionApplicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($transactionApplicationChannel) && !is_string($transactionApplicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionApplicationChannel, true), gettype($transactionApplicationChannel)), __LINE__);
        }
        if (is_null($transactionApplicationChannel) || (is_array($transactionApplicationChannel) && empty($transactionApplicationChannel))) {
            unset($this->TransactionApplicationChannel);
        } else {
            $this->TransactionApplicationChannel = $transactionApplicationChannel;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\AccessControl_SoldItemsJob_WorkItem
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\AccessControl_SoldItemsJob_WorkItem
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
