<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ShowTimeSubscriptionCardData StructType
 * @subpackage Structs
 */
class AccessControl_ShowTimeSubscriptionCardData extends AccessControl_ShowTimeBarcodeData
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The LoadedOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_ShowTimeTicketData
     */
    public $LoadedOnCard;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for AccessControl.ShowTimeSubscriptionCardData
     * @uses AccessControl_ShowTimeSubscriptionCardData::setCardNumber()
     * @uses AccessControl_ShowTimeSubscriptionCardData::setLoadedOnCard()
     * @uses AccessControl_ShowTimeSubscriptionCardData::setSeriesId()
     * @param string $cardNumber
     * @param \patest\StructType\RecordSetOfAccessControl_ShowTimeTicketData $loadedOnCard
     * @param string $seriesId
     */
    public function __construct($cardNumber = null, \patest\StructType\RecordSetOfAccessControl_ShowTimeTicketData $loadedOnCard = null, $seriesId = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setLoadedOnCard($loadedOnCard)
            ->setSeriesId($seriesId);
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\AccessControl_ShowTimeSubscriptionCardData
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get LoadedOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_ShowTimeTicketData|null
     */
    public function getLoadedOnCard()
    {
        return isset($this->LoadedOnCard) ? $this->LoadedOnCard : null;
    }
    /**
     * Set LoadedOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_ShowTimeTicketData $loadedOnCard
     * @return \patest\StructType\AccessControl_ShowTimeSubscriptionCardData
     */
    public function setLoadedOnCard(\patest\StructType\RecordSetOfAccessControl_ShowTimeTicketData $loadedOnCard = null)
    {
        if (is_null($loadedOnCard) || (is_array($loadedOnCard) && empty($loadedOnCard))) {
            unset($this->LoadedOnCard);
        } else {
            $this->LoadedOnCard = $loadedOnCard;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\AccessControl_ShowTimeSubscriptionCardData
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
}
