<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ShowTimeHallData StructType
 * @subpackage Structs
 */
class AccessControl_ShowTimeHallData extends AccessControl_ShowTimeEntityData
{
    /**
     * The PrintName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintName;
    /**
     * Constructor method for AccessControl.ShowTimeHallData
     * @uses AccessControl_ShowTimeHallData::setPrintName()
     * @param string $printName
     */
    public function __construct($printName = null)
    {
        $this
            ->setPrintName($printName);
    }
    /**
     * Get PrintName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintName()
    {
        return isset($this->PrintName) ? $this->PrintName : null;
    }
    /**
     * Set PrintName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printName
     * @return \patest\StructType\AccessControl_ShowTimeHallData
     */
    public function setPrintName($printName = null)
    {
        // validation for constraint: string
        if (!is_null($printName) && !is_string($printName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printName, true), gettype($printName)), __LINE__);
        }
        if (is_null($printName) || (is_array($printName) && empty($printName))) {
            unset($this->PrintName);
        } else {
            $this->PrintName = $printName;
        }
        return $this;
    }
}
