<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ScanningSession StructType
 * @subpackage Structs
 */
class AccessControl_ScanningSession extends PersistableEntity
{
    /**
     * The AccessibleOrgUnitIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessibleOrgUnitIds;
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ScanningPointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScanningPointId;
    /**
     * The ScanningPointType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScanningPointType;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for AccessControl.ScanningSession
     * @uses AccessControl_ScanningSession::setAccessibleOrgUnitIds()
     * @uses AccessControl_ScanningSession::setAuditId()
     * @uses AccessControl_ScanningSession::setCreationDate()
     * @uses AccessControl_ScanningSession::setOrganizationUnitId()
     * @uses AccessControl_ScanningSession::setScanningPointId()
     * @uses AccessControl_ScanningSession::setScanningPointType()
     * @uses AccessControl_ScanningSession::setUserId()
     * @param string $accessibleOrgUnitIds
     * @param int $auditId
     * @param string $creationDate
     * @param string $organizationUnitId
     * @param string $scanningPointId
     * @param string $scanningPointType
     * @param string $userId
     */
    public function __construct($accessibleOrgUnitIds = null, $auditId = null, $creationDate = null, $organizationUnitId = null, $scanningPointId = null, $scanningPointType = null, $userId = null)
    {
        $this
            ->setAccessibleOrgUnitIds($accessibleOrgUnitIds)
            ->setAuditId($auditId)
            ->setCreationDate($creationDate)
            ->setOrganizationUnitId($organizationUnitId)
            ->setScanningPointId($scanningPointId)
            ->setScanningPointType($scanningPointType)
            ->setUserId($userId);
    }
    /**
     * Get AccessibleOrgUnitIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessibleOrgUnitIds()
    {
        return isset($this->AccessibleOrgUnitIds) ? $this->AccessibleOrgUnitIds : null;
    }
    /**
     * Set AccessibleOrgUnitIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessibleOrgUnitIds
     * @return \patest\StructType\AccessControl_ScanningSession
     */
    public function setAccessibleOrgUnitIds($accessibleOrgUnitIds = null)
    {
        // validation for constraint: string
        if (!is_null($accessibleOrgUnitIds) && !is_string($accessibleOrgUnitIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessibleOrgUnitIds, true), gettype($accessibleOrgUnitIds)), __LINE__);
        }
        if (is_null($accessibleOrgUnitIds) || (is_array($accessibleOrgUnitIds) && empty($accessibleOrgUnitIds))) {
            unset($this->AccessibleOrgUnitIds);
        } else {
            $this->AccessibleOrgUnitIds = $accessibleOrgUnitIds;
        }
        return $this;
    }
    /**
     * Get AuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditId()
    {
        return isset($this->AuditId) ? $this->AuditId : null;
    }
    /**
     * Set AuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditId
     * @return \patest\StructType\AccessControl_ScanningSession
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        if (is_null($auditId) || (is_array($auditId) && empty($auditId))) {
            unset($this->AuditId);
        } else {
            $this->AuditId = $auditId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\AccessControl_ScanningSession
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_ScanningSession
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ScanningPointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanningPointId()
    {
        return isset($this->ScanningPointId) ? $this->ScanningPointId : null;
    }
    /**
     * Set ScanningPointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanningPointId
     * @return \patest\StructType\AccessControl_ScanningSession
     */
    public function setScanningPointId($scanningPointId = null)
    {
        // validation for constraint: string
        if (!is_null($scanningPointId) && !is_string($scanningPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanningPointId, true), gettype($scanningPointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scanningPointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scanningPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scanningPointId, true)), __LINE__);
        }
        if (is_null($scanningPointId) || (is_array($scanningPointId) && empty($scanningPointId))) {
            unset($this->ScanningPointId);
        } else {
            $this->ScanningPointId = $scanningPointId;
        }
        return $this;
    }
    /**
     * Get ScanningPointType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanningPointType()
    {
        return isset($this->ScanningPointType) ? $this->ScanningPointType : null;
    }
    /**
     * Set ScanningPointType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScanningPointType::valueIsValid()
     * @uses \patest\EnumType\ScanningPointType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scanningPointType
     * @return \patest\StructType\AccessControl_ScanningSession
     */
    public function setScanningPointType($scanningPointType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScanningPointType::valueIsValid($scanningPointType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScanningPointType', is_array($scanningPointType) ? implode(', ', $scanningPointType) : var_export($scanningPointType, true), implode(', ', \patest\EnumType\ScanningPointType::getValidValues())), __LINE__);
        }
        if (is_null($scanningPointType) || (is_array($scanningPointType) && empty($scanningPointType))) {
            unset($this->ScanningPointType);
        } else {
            $this->ScanningPointType = $scanningPointType;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\AccessControl_ScanningSession
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
