<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ResetEventScanDataItem StructType
 * @subpackage Structs
 */
class AccessControl_ResetEventScanDataItem extends PersistableEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DoNotReportToAuthoritativeSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotReportToAuthoritativeSystem;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FailureReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureReasonCode;
    /**
     * The FailureReasonDescr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureReasonDescr;
    /**
     * The IsFirstScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFirstScan;
    /**
     * The IsOfflineScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOfflineScan;
    /**
     * The IsReportedToAuthoritativeSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReportedToAuthoritativeSystem;
    /**
     * The IsVirtualScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVirtualScan;
    /**
     * The ReferencedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedEntityId;
    /**
     * The ReferencedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferencedEntityName;
    /**
     * The ResetEventScanDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResetEventScanDataId;
    /**
     * The SameShowOriginalEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SameShowOriginalEventId;
    /**
     * The ScanDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScanDate;
    /**
     * The ScannerControlledEntranceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ControlledEntrance
     * @var string
     */
    public $ScannerControlledEntranceType;
    /**
     * The ScannerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScannerId;
    /**
     * The ScanningSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScanningSessionId;
    /**
     * The ScanSucceeded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ScanSucceeded;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * The TurnstileId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TurnstileId;
    /**
     * Constructor method for AccessControl.ResetEventScanDataItem
     * @uses AccessControl_ResetEventScanDataItem::setAction()
     * @uses AccessControl_ResetEventScanDataItem::setAreaId()
     * @uses AccessControl_ResetEventScanDataItem::setBarcode()
     * @uses AccessControl_ResetEventScanDataItem::setBarcodeId()
     * @uses AccessControl_ResetEventScanDataItem::setClientId()
     * @uses AccessControl_ResetEventScanDataItem::setDoNotReportToAuthoritativeSystem()
     * @uses AccessControl_ResetEventScanDataItem::setEventId()
     * @uses AccessControl_ResetEventScanDataItem::setFailureReasonCode()
     * @uses AccessControl_ResetEventScanDataItem::setFailureReasonDescr()
     * @uses AccessControl_ResetEventScanDataItem::setIsFirstScan()
     * @uses AccessControl_ResetEventScanDataItem::setIsOfflineScan()
     * @uses AccessControl_ResetEventScanDataItem::setIsReportedToAuthoritativeSystem()
     * @uses AccessControl_ResetEventScanDataItem::setIsVirtualScan()
     * @uses AccessControl_ResetEventScanDataItem::setReferencedEntityId()
     * @uses AccessControl_ResetEventScanDataItem::setReferencedEntityName()
     * @uses AccessControl_ResetEventScanDataItem::setResetEventScanDataId()
     * @uses AccessControl_ResetEventScanDataItem::setSameShowOriginalEventId()
     * @uses AccessControl_ResetEventScanDataItem::setScanDate()
     * @uses AccessControl_ResetEventScanDataItem::setScannerControlledEntranceType()
     * @uses AccessControl_ResetEventScanDataItem::setScannerId()
     * @uses AccessControl_ResetEventScanDataItem::setScanningSessionId()
     * @uses AccessControl_ResetEventScanDataItem::setScanSucceeded()
     * @uses AccessControl_ResetEventScanDataItem::setSeat()
     * @uses AccessControl_ResetEventScanDataItem::setShowId()
     * @uses AccessControl_ResetEventScanDataItem::setTicketId()
     * @uses AccessControl_ResetEventScanDataItem::setTurnstileId()
     * @param string $action
     * @param string $areaId
     * @param string $barcode
     * @param string $barcodeId
     * @param string $clientId
     * @param bool $doNotReportToAuthoritativeSystem
     * @param string $eventId
     * @param string $failureReasonCode
     * @param string $failureReasonDescr
     * @param bool $isFirstScan
     * @param bool $isOfflineScan
     * @param bool $isReportedToAuthoritativeSystem
     * @param bool $isVirtualScan
     * @param string $referencedEntityId
     * @param string $referencedEntityName
     * @param string $resetEventScanDataId
     * @param string $sameShowOriginalEventId
     * @param string $scanDate
     * @param string $scannerControlledEntranceType
     * @param string $scannerId
     * @param string $scanningSessionId
     * @param bool $scanSucceeded
     * @param string $seat
     * @param string $showId
     * @param string $ticketId
     * @param string $turnstileId
     */
    public function __construct($action = null, $areaId = null, $barcode = null, $barcodeId = null, $clientId = null, $doNotReportToAuthoritativeSystem = null, $eventId = null, $failureReasonCode = null, $failureReasonDescr = null, $isFirstScan = null, $isOfflineScan = null, $isReportedToAuthoritativeSystem = null, $isVirtualScan = null, $referencedEntityId = null, $referencedEntityName = null, $resetEventScanDataId = null, $sameShowOriginalEventId = null, $scanDate = null, $scannerControlledEntranceType = null, $scannerId = null, $scanningSessionId = null, $scanSucceeded = null, $seat = null, $showId = null, $ticketId = null, $turnstileId = null)
    {
        $this
            ->setAction($action)
            ->setAreaId($areaId)
            ->setBarcode($barcode)
            ->setBarcodeId($barcodeId)
            ->setClientId($clientId)
            ->setDoNotReportToAuthoritativeSystem($doNotReportToAuthoritativeSystem)
            ->setEventId($eventId)
            ->setFailureReasonCode($failureReasonCode)
            ->setFailureReasonDescr($failureReasonDescr)
            ->setIsFirstScan($isFirstScan)
            ->setIsOfflineScan($isOfflineScan)
            ->setIsReportedToAuthoritativeSystem($isReportedToAuthoritativeSystem)
            ->setIsVirtualScan($isVirtualScan)
            ->setReferencedEntityId($referencedEntityId)
            ->setReferencedEntityName($referencedEntityName)
            ->setResetEventScanDataId($resetEventScanDataId)
            ->setSameShowOriginalEventId($sameShowOriginalEventId)
            ->setScanDate($scanDate)
            ->setScannerControlledEntranceType($scannerControlledEntranceType)
            ->setScannerId($scannerId)
            ->setScanningSessionId($scanningSessionId)
            ->setScanSucceeded($scanSucceeded)
            ->setSeat($seat)
            ->setShowId($showId)
            ->setTicketId($ticketId)
            ->setTurnstileId($turnstileId);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BarcodeScanAction::valueIsValid()
     * @uses \patest\EnumType\BarcodeScanAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeScanAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeScanAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\BarcodeScanAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeId()
    {
        return isset($this->BarcodeId) ? $this->BarcodeId : null;
    }
    /**
     * Set BarcodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setBarcodeId($barcodeId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeId) && !is_string($barcodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeId, true), gettype($barcodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeId, true)), __LINE__);
        }
        if (is_null($barcodeId) || (is_array($barcodeId) && empty($barcodeId))) {
            unset($this->BarcodeId);
        } else {
            $this->BarcodeId = $barcodeId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DoNotReportToAuthoritativeSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotReportToAuthoritativeSystem()
    {
        return isset($this->DoNotReportToAuthoritativeSystem) ? $this->DoNotReportToAuthoritativeSystem : null;
    }
    /**
     * Set DoNotReportToAuthoritativeSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotReportToAuthoritativeSystem
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setDoNotReportToAuthoritativeSystem($doNotReportToAuthoritativeSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotReportToAuthoritativeSystem) && !is_bool($doNotReportToAuthoritativeSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotReportToAuthoritativeSystem, true), gettype($doNotReportToAuthoritativeSystem)), __LINE__);
        }
        if (is_null($doNotReportToAuthoritativeSystem) || (is_array($doNotReportToAuthoritativeSystem) && empty($doNotReportToAuthoritativeSystem))) {
            unset($this->DoNotReportToAuthoritativeSystem);
        } else {
            $this->DoNotReportToAuthoritativeSystem = $doNotReportToAuthoritativeSystem;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FailureReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureReasonCode()
    {
        return isset($this->FailureReasonCode) ? $this->FailureReasonCode : null;
    }
    /**
     * Set FailureReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureReasonCode
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setFailureReasonCode($failureReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($failureReasonCode) && !is_string($failureReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureReasonCode, true), gettype($failureReasonCode)), __LINE__);
        }
        if (is_null($failureReasonCode) || (is_array($failureReasonCode) && empty($failureReasonCode))) {
            unset($this->FailureReasonCode);
        } else {
            $this->FailureReasonCode = $failureReasonCode;
        }
        return $this;
    }
    /**
     * Get FailureReasonDescr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureReasonDescr()
    {
        return isset($this->FailureReasonDescr) ? $this->FailureReasonDescr : null;
    }
    /**
     * Set FailureReasonDescr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureReasonDescr
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setFailureReasonDescr($failureReasonDescr = null)
    {
        // validation for constraint: string
        if (!is_null($failureReasonDescr) && !is_string($failureReasonDescr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureReasonDescr, true), gettype($failureReasonDescr)), __LINE__);
        }
        if (is_null($failureReasonDescr) || (is_array($failureReasonDescr) && empty($failureReasonDescr))) {
            unset($this->FailureReasonDescr);
        } else {
            $this->FailureReasonDescr = $failureReasonDescr;
        }
        return $this;
    }
    /**
     * Get IsFirstScan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFirstScan()
    {
        return isset($this->IsFirstScan) ? $this->IsFirstScan : null;
    }
    /**
     * Set IsFirstScan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFirstScan
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setIsFirstScan($isFirstScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstScan) && !is_bool($isFirstScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstScan, true), gettype($isFirstScan)), __LINE__);
        }
        if (is_null($isFirstScan) || (is_array($isFirstScan) && empty($isFirstScan))) {
            unset($this->IsFirstScan);
        } else {
            $this->IsFirstScan = $isFirstScan;
        }
        return $this;
    }
    /**
     * Get IsOfflineScan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOfflineScan()
    {
        return isset($this->IsOfflineScan) ? $this->IsOfflineScan : null;
    }
    /**
     * Set IsOfflineScan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOfflineScan
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setIsOfflineScan($isOfflineScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOfflineScan) && !is_bool($isOfflineScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOfflineScan, true), gettype($isOfflineScan)), __LINE__);
        }
        if (is_null($isOfflineScan) || (is_array($isOfflineScan) && empty($isOfflineScan))) {
            unset($this->IsOfflineScan);
        } else {
            $this->IsOfflineScan = $isOfflineScan;
        }
        return $this;
    }
    /**
     * Get IsReportedToAuthoritativeSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReportedToAuthoritativeSystem()
    {
        return isset($this->IsReportedToAuthoritativeSystem) ? $this->IsReportedToAuthoritativeSystem : null;
    }
    /**
     * Set IsReportedToAuthoritativeSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReportedToAuthoritativeSystem
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setIsReportedToAuthoritativeSystem($isReportedToAuthoritativeSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReportedToAuthoritativeSystem) && !is_bool($isReportedToAuthoritativeSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReportedToAuthoritativeSystem, true), gettype($isReportedToAuthoritativeSystem)), __LINE__);
        }
        if (is_null($isReportedToAuthoritativeSystem) || (is_array($isReportedToAuthoritativeSystem) && empty($isReportedToAuthoritativeSystem))) {
            unset($this->IsReportedToAuthoritativeSystem);
        } else {
            $this->IsReportedToAuthoritativeSystem = $isReportedToAuthoritativeSystem;
        }
        return $this;
    }
    /**
     * Get IsVirtualScan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVirtualScan()
    {
        return isset($this->IsVirtualScan) ? $this->IsVirtualScan : null;
    }
    /**
     * Set IsVirtualScan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVirtualScan
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setIsVirtualScan($isVirtualScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVirtualScan) && !is_bool($isVirtualScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVirtualScan, true), gettype($isVirtualScan)), __LINE__);
        }
        if (is_null($isVirtualScan) || (is_array($isVirtualScan) && empty($isVirtualScan))) {
            unset($this->IsVirtualScan);
        } else {
            $this->IsVirtualScan = $isVirtualScan;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityId()
    {
        return isset($this->ReferencedEntityId) ? $this->ReferencedEntityId : null;
    }
    /**
     * Set ReferencedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setReferencedEntityId($referencedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityId) && !is_string($referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityId, true), gettype($referencedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referencedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referencedEntityId, true)), __LINE__);
        }
        if (is_null($referencedEntityId) || (is_array($referencedEntityId) && empty($referencedEntityId))) {
            unset($this->ReferencedEntityId);
        } else {
            $this->ReferencedEntityId = $referencedEntityId;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityName()
    {
        return isset($this->ReferencedEntityName) ? $this->ReferencedEntityName : null;
    }
    /**
     * Set ReferencedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityName
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setReferencedEntityName($referencedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityName) && !is_string($referencedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityName, true), gettype($referencedEntityName)), __LINE__);
        }
        if (is_null($referencedEntityName) || (is_array($referencedEntityName) && empty($referencedEntityName))) {
            unset($this->ReferencedEntityName);
        } else {
            $this->ReferencedEntityName = $referencedEntityName;
        }
        return $this;
    }
    /**
     * Get ResetEventScanDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResetEventScanDataId()
    {
        return isset($this->ResetEventScanDataId) ? $this->ResetEventScanDataId : null;
    }
    /**
     * Set ResetEventScanDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resetEventScanDataId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setResetEventScanDataId($resetEventScanDataId = null)
    {
        // validation for constraint: string
        if (!is_null($resetEventScanDataId) && !is_string($resetEventScanDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resetEventScanDataId, true), gettype($resetEventScanDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resetEventScanDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resetEventScanDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resetEventScanDataId, true)), __LINE__);
        }
        if (is_null($resetEventScanDataId) || (is_array($resetEventScanDataId) && empty($resetEventScanDataId))) {
            unset($this->ResetEventScanDataId);
        } else {
            $this->ResetEventScanDataId = $resetEventScanDataId;
        }
        return $this;
    }
    /**
     * Get SameShowOriginalEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSameShowOriginalEventId()
    {
        return isset($this->SameShowOriginalEventId) ? $this->SameShowOriginalEventId : null;
    }
    /**
     * Set SameShowOriginalEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sameShowOriginalEventId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setSameShowOriginalEventId($sameShowOriginalEventId = null)
    {
        // validation for constraint: string
        if (!is_null($sameShowOriginalEventId) && !is_string($sameShowOriginalEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sameShowOriginalEventId, true), gettype($sameShowOriginalEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sameShowOriginalEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sameShowOriginalEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sameShowOriginalEventId, true)), __LINE__);
        }
        if (is_null($sameShowOriginalEventId) || (is_array($sameShowOriginalEventId) && empty($sameShowOriginalEventId))) {
            unset($this->SameShowOriginalEventId);
        } else {
            $this->SameShowOriginalEventId = $sameShowOriginalEventId;
        }
        return $this;
    }
    /**
     * Get ScanDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanDate()
    {
        return isset($this->ScanDate) ? $this->ScanDate : null;
    }
    /**
     * Set ScanDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanDate
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setScanDate($scanDate = null)
    {
        // validation for constraint: string
        if (!is_null($scanDate) && !is_string($scanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanDate, true), gettype($scanDate)), __LINE__);
        }
        if (is_null($scanDate) || (is_array($scanDate) && empty($scanDate))) {
            unset($this->ScanDate);
        } else {
            $this->ScanDate = $scanDate;
        }
        return $this;
    }
    /**
     * Get ScannerControlledEntranceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannerControlledEntranceType()
    {
        return isset($this->ScannerControlledEntranceType) ? $this->ScannerControlledEntranceType : null;
    }
    /**
     * Set ScannerControlledEntranceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannerControlledEntranceType
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setScannerControlledEntranceType($scannerControlledEntranceType = null)
    {
        // validation for constraint: string
        if (!is_null($scannerControlledEntranceType) && !is_string($scannerControlledEntranceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannerControlledEntranceType, true), gettype($scannerControlledEntranceType)), __LINE__);
        }
        if (is_null($scannerControlledEntranceType) || (is_array($scannerControlledEntranceType) && empty($scannerControlledEntranceType))) {
            unset($this->ScannerControlledEntranceType);
        } else {
            $this->ScannerControlledEntranceType = $scannerControlledEntranceType;
        }
        return $this;
    }
    /**
     * Get ScannerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannerId()
    {
        return isset($this->ScannerId) ? $this->ScannerId : null;
    }
    /**
     * Set ScannerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannerId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setScannerId($scannerId = null)
    {
        // validation for constraint: string
        if (!is_null($scannerId) && !is_string($scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannerId, true), gettype($scannerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scannerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scannerId, true)), __LINE__);
        }
        if (is_null($scannerId) || (is_array($scannerId) && empty($scannerId))) {
            unset($this->ScannerId);
        } else {
            $this->ScannerId = $scannerId;
        }
        return $this;
    }
    /**
     * Get ScanningSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanningSessionId()
    {
        return isset($this->ScanningSessionId) ? $this->ScanningSessionId : null;
    }
    /**
     * Set ScanningSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanningSessionId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setScanningSessionId($scanningSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($scanningSessionId) && !is_string($scanningSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanningSessionId, true), gettype($scanningSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scanningSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scanningSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scanningSessionId, true)), __LINE__);
        }
        if (is_null($scanningSessionId) || (is_array($scanningSessionId) && empty($scanningSessionId))) {
            unset($this->ScanningSessionId);
        } else {
            $this->ScanningSessionId = $scanningSessionId;
        }
        return $this;
    }
    /**
     * Get ScanSucceeded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getScanSucceeded()
    {
        return isset($this->ScanSucceeded) ? $this->ScanSucceeded : null;
    }
    /**
     * Set ScanSucceeded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $scanSucceeded
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setScanSucceeded($scanSucceeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($scanSucceeded) && !is_bool($scanSucceeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scanSucceeded, true), gettype($scanSucceeded)), __LINE__);
        }
        if (is_null($scanSucceeded) || (is_array($scanSucceeded) && empty($scanSucceeded))) {
            unset($this->ScanSucceeded);
        } else {
            $this->ScanSucceeded = $scanSucceeded;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
    /**
     * Get TurnstileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstileId()
    {
        return isset($this->TurnstileId) ? $this->TurnstileId : null;
    }
    /**
     * Set TurnstileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstileId
     * @return \patest\StructType\AccessControl_ResetEventScanDataItem
     */
    public function setTurnstileId($turnstileId = null)
    {
        // validation for constraint: string
        if (!is_null($turnstileId) && !is_string($turnstileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstileId, true), gettype($turnstileId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($turnstileId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $turnstileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($turnstileId, true)), __LINE__);
        }
        if (is_null($turnstileId) || (is_array($turnstileId) && empty($turnstileId))) {
            unset($this->TurnstileId);
        } else {
            $this->TurnstileId = $turnstileId;
        }
        return $this;
    }
}
