<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.Printing.AccessControlData StructType
 * @subpackage Structs
 */
class AccessControl_Printing_AccessControlData extends Printing_Item_ComplexProperty_Base
{
    /**
     * The AccessControlSystemReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlSystemReferenceId;
    /**
     * Constructor method for AccessControl.Printing.AccessControlData
     * @uses AccessControl_Printing_AccessControlData::setAccessControlSystemReferenceId()
     * @param string $accessControlSystemReferenceId
     */
    public function __construct($accessControlSystemReferenceId = null)
    {
        $this
            ->setAccessControlSystemReferenceId($accessControlSystemReferenceId);
    }
    /**
     * Get AccessControlSystemReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemReferenceId()
    {
        return isset($this->AccessControlSystemReferenceId) ? $this->AccessControlSystemReferenceId : null;
    }
    /**
     * Set AccessControlSystemReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemReferenceId
     * @return \patest\StructType\AccessControl_Printing_AccessControlData
     */
    public function setAccessControlSystemReferenceId($accessControlSystemReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemReferenceId) && !is_string($accessControlSystemReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemReferenceId, true), gettype($accessControlSystemReferenceId)), __LINE__);
        }
        if (is_null($accessControlSystemReferenceId) || (is_array($accessControlSystemReferenceId) && empty($accessControlSystemReferenceId))) {
            unset($this->AccessControlSystemReferenceId);
        } else {
            $this->AccessControlSystemReferenceId = $accessControlSystemReferenceId;
        }
        return $this;
    }
}
