<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.MobileAppJob.WorkItem StructType
 * @subpackage Structs
 */
class AccessControl_MobileAppJob_WorkItem extends Foundation_QueuedWorkItem
{
    /**
     * The MobileAppEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppEvents;
    /**
     * The MobileApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MobileApplicationId;
    /**
     * Constructor method for AccessControl.MobileAppJob.WorkItem
     * @uses AccessControl_MobileAppJob_WorkItem::setMobileAppEvents()
     * @uses AccessControl_MobileAppJob_WorkItem::setMobileApplicationId()
     * @param string $mobileAppEvents
     * @param string $mobileApplicationId
     */
    public function __construct($mobileAppEvents = null, $mobileApplicationId = null)
    {
        $this
            ->setMobileAppEvents($mobileAppEvents)
            ->setMobileApplicationId($mobileApplicationId);
    }
    /**
     * Get MobileAppEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppEvents()
    {
        return isset($this->MobileAppEvents) ? $this->MobileAppEvents : null;
    }
    /**
     * Set MobileAppEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppEvents
     * @return \patest\StructType\AccessControl_MobileAppJob_WorkItem
     */
    public function setMobileAppEvents($mobileAppEvents = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppEvents) && !is_string($mobileAppEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppEvents, true), gettype($mobileAppEvents)), __LINE__);
        }
        if (is_null($mobileAppEvents) || (is_array($mobileAppEvents) && empty($mobileAppEvents))) {
            unset($this->MobileAppEvents);
        } else {
            $this->MobileAppEvents = $mobileAppEvents;
        }
        return $this;
    }
    /**
     * Get MobileApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileApplicationId()
    {
        return isset($this->MobileApplicationId) ? $this->MobileApplicationId : null;
    }
    /**
     * Set MobileApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileApplicationId
     * @return \patest\StructType\AccessControl_MobileAppJob_WorkItem
     */
    public function setMobileApplicationId($mobileApplicationId = null)
    {
        // validation for constraint: string
        if (!is_null($mobileApplicationId) && !is_string($mobileApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileApplicationId, true), gettype($mobileApplicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mobileApplicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mobileApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mobileApplicationId, true)), __LINE__);
        }
        if (is_null($mobileApplicationId) || (is_array($mobileApplicationId) && empty($mobileApplicationId))) {
            unset($this->MobileApplicationId);
        } else {
            $this->MobileApplicationId = $mobileApplicationId;
        }
        return $this;
    }
}
