<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * AccessControl.ExternalBarcodesProviderTypeConfig.BaseEntity StructType
 * @subpackage Structs
 */
class AccessControl_ExternalBarcodesProviderTypeConfig_BaseEntity extends AnyEntity
{
    /**
     * The ExternalBarcodeProviderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExternalBarcodeProviderId;
    /**
     * The ExternalBarcodeProviderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalBarcodeProviderType;
    /**
     * Constructor method for
     * AccessControl.ExternalBarcodesProviderTypeConfig.BaseEntity
     * @uses AccessControl_ExternalBarcodesProviderTypeConfig_BaseEntity::setExternalBarcodeProviderId()
     * @uses AccessControl_ExternalBarcodesProviderTypeConfig_BaseEntity::setExternalBarcodeProviderType()
     * @param string $externalBarcodeProviderId
     * @param string $externalBarcodeProviderType
     */
    public function __construct($externalBarcodeProviderId = null, $externalBarcodeProviderType = null)
    {
        $this
            ->setExternalBarcodeProviderId($externalBarcodeProviderId)
            ->setExternalBarcodeProviderType($externalBarcodeProviderType);
    }
    /**
     * Get ExternalBarcodeProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalBarcodeProviderId()
    {
        return isset($this->ExternalBarcodeProviderId) ? $this->ExternalBarcodeProviderId : null;
    }
    /**
     * Set ExternalBarcodeProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalBarcodeProviderId
     * @return \patest\StructType\AccessControl_ExternalBarcodesProviderTypeConfig_BaseEntity
     */
    public function setExternalBarcodeProviderId($externalBarcodeProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($externalBarcodeProviderId) && !is_string($externalBarcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBarcodeProviderId, true), gettype($externalBarcodeProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($externalBarcodeProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $externalBarcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($externalBarcodeProviderId, true)), __LINE__);
        }
        if (is_null($externalBarcodeProviderId) || (is_array($externalBarcodeProviderId) && empty($externalBarcodeProviderId))) {
            unset($this->ExternalBarcodeProviderId);
        } else {
            $this->ExternalBarcodeProviderId = $externalBarcodeProviderId;
        }
        return $this;
    }
    /**
     * Get ExternalBarcodeProviderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalBarcodeProviderType()
    {
        return isset($this->ExternalBarcodeProviderType) ? $this->ExternalBarcodeProviderType : null;
    }
    /**
     * Set ExternalBarcodeProviderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalBarcodeProviderType
     * @return \patest\StructType\AccessControl_ExternalBarcodesProviderTypeConfig_BaseEntity
     */
    public function setExternalBarcodeProviderType($externalBarcodeProviderType = null)
    {
        // validation for constraint: string
        if (!is_null($externalBarcodeProviderType) && !is_string($externalBarcodeProviderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBarcodeProviderType, true), gettype($externalBarcodeProviderType)), __LINE__);
        }
        if (is_null($externalBarcodeProviderType) || (is_array($externalBarcodeProviderType) && empty($externalBarcodeProviderType))) {
            unset($this->ExternalBarcodeProviderType);
        } else {
            $this->ExternalBarcodeProviderType = $externalBarcodeProviderType;
        }
        return $this;
    }
}
