<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.EntityAccessControlDataXref StructType
 * @subpackage Structs
 */
class AccessControl_EntityAccessControlDataXref extends PersistableEntity
{
    /**
     * The AccessControlData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_EntityAccessControlData
     */
    public $AccessControlData;
    /**
     * The AccessControlData_AccessControlSyncStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlData_AccessControlSyncStatus;
    /**
     * The AccessControlData_AccessControlSystemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlData_AccessControlSystemId;
    /**
     * The AccessControlData_AccessControlSystemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AccessControlData_AccessControlSystemName;
    /**
     * The AccessControlData_AccessControlSystemReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlData_AccessControlSystemReferenceId;
    /**
     * The AccessControlData_EntityId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlData_EntityId;
    /**
     * The AccessControlData_EntityName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlData_EntityName;
    /**
     * The AccessControlData_UsesAccessControl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AccessControlData_UsesAccessControl;
    /**
     * The EntityAccessControlDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityAccessControlDataId;
    /**
     * The ReferencedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedEntityId;
    /**
     * The ReferencedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferencedEntityName;
    /**
     * Constructor method for AccessControl.EntityAccessControlDataXref
     * @uses AccessControl_EntityAccessControlDataXref::setAccessControlData()
     * @uses AccessControl_EntityAccessControlDataXref::setAccessControlData_AccessControlSyncStatus()
     * @uses AccessControl_EntityAccessControlDataXref::setAccessControlData_AccessControlSystemId()
     * @uses AccessControl_EntityAccessControlDataXref::setAccessControlData_AccessControlSystemName()
     * @uses AccessControl_EntityAccessControlDataXref::setAccessControlData_AccessControlSystemReferenceId()
     * @uses AccessControl_EntityAccessControlDataXref::setAccessControlData_EntityId()
     * @uses AccessControl_EntityAccessControlDataXref::setAccessControlData_EntityName()
     * @uses AccessControl_EntityAccessControlDataXref::setAccessControlData_UsesAccessControl()
     * @uses AccessControl_EntityAccessControlDataXref::setEntityAccessControlDataId()
     * @uses AccessControl_EntityAccessControlDataXref::setReferencedEntityId()
     * @uses AccessControl_EntityAccessControlDataXref::setReferencedEntityName()
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @param string $accessControlData_AccessControlSyncStatus
     * @param string $accessControlData_AccessControlSystemId
     * @param \patest\StructType\GlobalString $accessControlData_AccessControlSystemName
     * @param string $accessControlData_AccessControlSystemReferenceId
     * @param string $accessControlData_EntityId
     * @param string $accessControlData_EntityName
     * @param bool $accessControlData_UsesAccessControl
     * @param string $entityAccessControlDataId
     * @param string $referencedEntityId
     * @param string $referencedEntityName
     */
    public function __construct(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null, $accessControlData_AccessControlSyncStatus = null, $accessControlData_AccessControlSystemId = null, \patest\StructType\GlobalString $accessControlData_AccessControlSystemName = null, $accessControlData_AccessControlSystemReferenceId = null, $accessControlData_EntityId = null, $accessControlData_EntityName = null, $accessControlData_UsesAccessControl = null, $entityAccessControlDataId = null, $referencedEntityId = null, $referencedEntityName = null)
    {
        $this
            ->setAccessControlData($accessControlData)
            ->setAccessControlData_AccessControlSyncStatus($accessControlData_AccessControlSyncStatus)
            ->setAccessControlData_AccessControlSystemId($accessControlData_AccessControlSystemId)
            ->setAccessControlData_AccessControlSystemName($accessControlData_AccessControlSystemName)
            ->setAccessControlData_AccessControlSystemReferenceId($accessControlData_AccessControlSystemReferenceId)
            ->setAccessControlData_EntityId($accessControlData_EntityId)
            ->setAccessControlData_EntityName($accessControlData_EntityName)
            ->setAccessControlData_UsesAccessControl($accessControlData_UsesAccessControl)
            ->setEntityAccessControlDataId($entityAccessControlDataId)
            ->setReferencedEntityId($referencedEntityId)
            ->setReferencedEntityName($referencedEntityName);
    }
    /**
     * Get AccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_EntityAccessControlData|null
     */
    public function getAccessControlData()
    {
        return isset($this->AccessControlData) ? $this->AccessControlData : null;
    }
    /**
     * Set AccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setAccessControlData(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null)
    {
        if (is_null($accessControlData) || (is_array($accessControlData) && empty($accessControlData))) {
            unset($this->AccessControlData);
        } else {
            $this->AccessControlData = $accessControlData;
        }
        return $this;
    }
    /**
     * Get AccessControlData_AccessControlSyncStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlData_AccessControlSyncStatus()
    {
        return isset($this->AccessControlData_AccessControlSyncStatus) ? $this->AccessControlData_AccessControlSyncStatus : null;
    }
    /**
     * Set AccessControlData_AccessControlSyncStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessControlSynchronizationStatus::valueIsValid()
     * @uses \patest\EnumType\AccessControlSynchronizationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessControlData_AccessControlSyncStatus
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setAccessControlData_AccessControlSyncStatus($accessControlData_AccessControlSyncStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessControlSynchronizationStatus::valueIsValid($accessControlData_AccessControlSyncStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessControlSynchronizationStatus', is_array($accessControlData_AccessControlSyncStatus) ? implode(', ', $accessControlData_AccessControlSyncStatus) : var_export($accessControlData_AccessControlSyncStatus, true), implode(', ', \patest\EnumType\AccessControlSynchronizationStatus::getValidValues())), __LINE__);
        }
        if (is_null($accessControlData_AccessControlSyncStatus) || (is_array($accessControlData_AccessControlSyncStatus) && empty($accessControlData_AccessControlSyncStatus))) {
            unset($this->AccessControlData_AccessControlSyncStatus);
        } else {
            $this->AccessControlData_AccessControlSyncStatus = $accessControlData_AccessControlSyncStatus;
        }
        return $this;
    }
    /**
     * Get AccessControlData_AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlData_AccessControlSystemId()
    {
        return isset($this->AccessControlData_AccessControlSystemId) ? $this->AccessControlData_AccessControlSystemId : null;
    }
    /**
     * Set AccessControlData_AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlData_AccessControlSystemId
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setAccessControlData_AccessControlSystemId($accessControlData_AccessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlData_AccessControlSystemId) && !is_string($accessControlData_AccessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlData_AccessControlSystemId, true), gettype($accessControlData_AccessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlData_AccessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlData_AccessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlData_AccessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlData_AccessControlSystemId) || (is_array($accessControlData_AccessControlSystemId) && empty($accessControlData_AccessControlSystemId))) {
            unset($this->AccessControlData_AccessControlSystemId);
        } else {
            $this->AccessControlData_AccessControlSystemId = $accessControlData_AccessControlSystemId;
        }
        return $this;
    }
    /**
     * Get AccessControlData_AccessControlSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAccessControlData_AccessControlSystemName()
    {
        return isset($this->AccessControlData_AccessControlSystemName) ? $this->AccessControlData_AccessControlSystemName : null;
    }
    /**
     * Set AccessControlData_AccessControlSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $accessControlData_AccessControlSystemName
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setAccessControlData_AccessControlSystemName(\patest\StructType\GlobalString $accessControlData_AccessControlSystemName = null)
    {
        if (is_null($accessControlData_AccessControlSystemName) || (is_array($accessControlData_AccessControlSystemName) && empty($accessControlData_AccessControlSystemName))) {
            unset($this->AccessControlData_AccessControlSystemName);
        } else {
            $this->AccessControlData_AccessControlSystemName = $accessControlData_AccessControlSystemName;
        }
        return $this;
    }
    /**
     * Get AccessControlData_AccessControlSystemReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlData_AccessControlSystemReferenceId()
    {
        return isset($this->AccessControlData_AccessControlSystemReferenceId) ? $this->AccessControlData_AccessControlSystemReferenceId : null;
    }
    /**
     * Set AccessControlData_AccessControlSystemReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlData_AccessControlSystemReferenceId
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setAccessControlData_AccessControlSystemReferenceId($accessControlData_AccessControlSystemReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlData_AccessControlSystemReferenceId) && !is_string($accessControlData_AccessControlSystemReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlData_AccessControlSystemReferenceId, true), gettype($accessControlData_AccessControlSystemReferenceId)), __LINE__);
        }
        if (is_null($accessControlData_AccessControlSystemReferenceId) || (is_array($accessControlData_AccessControlSystemReferenceId) && empty($accessControlData_AccessControlSystemReferenceId))) {
            unset($this->AccessControlData_AccessControlSystemReferenceId);
        } else {
            $this->AccessControlData_AccessControlSystemReferenceId = $accessControlData_AccessControlSystemReferenceId;
        }
        return $this;
    }
    /**
     * Get AccessControlData_EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlData_EntityId()
    {
        return isset($this->AccessControlData_EntityId) ? $this->AccessControlData_EntityId : null;
    }
    /**
     * Set AccessControlData_EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlData_EntityId
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setAccessControlData_EntityId($accessControlData_EntityId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlData_EntityId) && !is_string($accessControlData_EntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlData_EntityId, true), gettype($accessControlData_EntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlData_EntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlData_EntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlData_EntityId, true)), __LINE__);
        }
        if (is_null($accessControlData_EntityId) || (is_array($accessControlData_EntityId) && empty($accessControlData_EntityId))) {
            unset($this->AccessControlData_EntityId);
        } else {
            $this->AccessControlData_EntityId = $accessControlData_EntityId;
        }
        return $this;
    }
    /**
     * Get AccessControlData_EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlData_EntityName()
    {
        return isset($this->AccessControlData_EntityName) ? $this->AccessControlData_EntityName : null;
    }
    /**
     * Set AccessControlData_EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlData_EntityName
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setAccessControlData_EntityName($accessControlData_EntityName = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlData_EntityName) && !is_string($accessControlData_EntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlData_EntityName, true), gettype($accessControlData_EntityName)), __LINE__);
        }
        if (is_null($accessControlData_EntityName) || (is_array($accessControlData_EntityName) && empty($accessControlData_EntityName))) {
            unset($this->AccessControlData_EntityName);
        } else {
            $this->AccessControlData_EntityName = $accessControlData_EntityName;
        }
        return $this;
    }
    /**
     * Get AccessControlData_UsesAccessControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAccessControlData_UsesAccessControl()
    {
        return isset($this->AccessControlData_UsesAccessControl) ? $this->AccessControlData_UsesAccessControl : null;
    }
    /**
     * Set AccessControlData_UsesAccessControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $accessControlData_UsesAccessControl
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setAccessControlData_UsesAccessControl($accessControlData_UsesAccessControl = null)
    {
        // validation for constraint: boolean
        if (!is_null($accessControlData_UsesAccessControl) && !is_bool($accessControlData_UsesAccessControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accessControlData_UsesAccessControl, true), gettype($accessControlData_UsesAccessControl)), __LINE__);
        }
        if (is_null($accessControlData_UsesAccessControl) || (is_array($accessControlData_UsesAccessControl) && empty($accessControlData_UsesAccessControl))) {
            unset($this->AccessControlData_UsesAccessControl);
        } else {
            $this->AccessControlData_UsesAccessControl = $accessControlData_UsesAccessControl;
        }
        return $this;
    }
    /**
     * Get EntityAccessControlDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityAccessControlDataId()
    {
        return isset($this->EntityAccessControlDataId) ? $this->EntityAccessControlDataId : null;
    }
    /**
     * Set EntityAccessControlDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityAccessControlDataId
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setEntityAccessControlDataId($entityAccessControlDataId = null)
    {
        // validation for constraint: string
        if (!is_null($entityAccessControlDataId) && !is_string($entityAccessControlDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityAccessControlDataId, true), gettype($entityAccessControlDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityAccessControlDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityAccessControlDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityAccessControlDataId, true)), __LINE__);
        }
        if (is_null($entityAccessControlDataId) || (is_array($entityAccessControlDataId) && empty($entityAccessControlDataId))) {
            unset($this->EntityAccessControlDataId);
        } else {
            $this->EntityAccessControlDataId = $entityAccessControlDataId;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityId()
    {
        return isset($this->ReferencedEntityId) ? $this->ReferencedEntityId : null;
    }
    /**
     * Set ReferencedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityId
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setReferencedEntityId($referencedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityId) && !is_string($referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityId, true), gettype($referencedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referencedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referencedEntityId, true)), __LINE__);
        }
        if (is_null($referencedEntityId) || (is_array($referencedEntityId) && empty($referencedEntityId))) {
            unset($this->ReferencedEntityId);
        } else {
            $this->ReferencedEntityId = $referencedEntityId;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityName()
    {
        return isset($this->ReferencedEntityName) ? $this->ReferencedEntityName : null;
    }
    /**
     * Set ReferencedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityName
     * @return \patest\StructType\AccessControl_EntityAccessControlDataXref
     */
    public function setReferencedEntityName($referencedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityName) && !is_string($referencedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityName, true), gettype($referencedEntityName)), __LINE__);
        }
        if (is_null($referencedEntityName) || (is_array($referencedEntityName) && empty($referencedEntityName))) {
            unset($this->ReferencedEntityName);
        } else {
            $this->ReferencedEntityName = $referencedEntityName;
        }
        return $this;
    }
}
