<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.EntityAccessControlData StructType
 * @subpackage Structs
 */
class AccessControl_EntityAccessControlData extends PersistableEntity
{
    /**
     * The AccessControlProviderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlProviderId;
    /**
     * The AccessControlSwitchedOn
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AccessControlSwitchedOn;
    /**
     * The AccessControlSyncStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlSyncStatus;
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The AccessControlSystemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AccessControlSystemName;
    /**
     * The AccessControlSystemReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlSystemReferenceId;
    /**
     * The AttendanceDataSyncDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttendanceDataSyncDate;
    /**
     * The CanBeScannedRemotely
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanBeScannedRemotely;
    /**
     * The DetachReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetachReferenceId;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The HasExternalBarcodeProviders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasExternalBarcodeProviders;
    /**
     * The IsInternal
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInternal;
    /**
     * The LastSyncDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSyncDate;
    /**
     * The LastSyncError
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSyncError;
    /**
     * The ModifiedProperties
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifiedProperties;
    /**
     * The ParentEntityAccessControlDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentEntityAccessControlDataId;
    /**
     * The ScheduledForDelete
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ScheduledForDelete;
    /**
     * The ShowtimeBarcodesSyncMessage
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeBarcodesSyncMessage;
    /**
     * The ShowtimeBarcodesSyncStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowtimeBarcodesSyncStatus;
    /**
     * The ShowtimeSyncRequestId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowtimeSyncRequestId;
    /**
     * The SyncAttendanceData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SyncAttendanceData;
    /**
     * The UsesAccessControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsesAccessControl;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for AccessControl.EntityAccessControlData
     * @uses AccessControl_EntityAccessControlData::setAccessControlProviderId()
     * @uses AccessControl_EntityAccessControlData::setAccessControlSwitchedOn()
     * @uses AccessControl_EntityAccessControlData::setAccessControlSyncStatus()
     * @uses AccessControl_EntityAccessControlData::setAccessControlSystemId()
     * @uses AccessControl_EntityAccessControlData::setAccessControlSystemName()
     * @uses AccessControl_EntityAccessControlData::setAccessControlSystemReferenceId()
     * @uses AccessControl_EntityAccessControlData::setAttendanceDataSyncDate()
     * @uses AccessControl_EntityAccessControlData::setCanBeScannedRemotely()
     * @uses AccessControl_EntityAccessControlData::setDetachReferenceId()
     * @uses AccessControl_EntityAccessControlData::setEntityId()
     * @uses AccessControl_EntityAccessControlData::setEntityName()
     * @uses AccessControl_EntityAccessControlData::setHasExternalBarcodeProviders()
     * @uses AccessControl_EntityAccessControlData::setIsInternal()
     * @uses AccessControl_EntityAccessControlData::setLastSyncDate()
     * @uses AccessControl_EntityAccessControlData::setLastSyncError()
     * @uses AccessControl_EntityAccessControlData::setModifiedProperties()
     * @uses AccessControl_EntityAccessControlData::setParentEntityAccessControlDataId()
     * @uses AccessControl_EntityAccessControlData::setScheduledForDelete()
     * @uses AccessControl_EntityAccessControlData::setShowtimeBarcodesSyncMessage()
     * @uses AccessControl_EntityAccessControlData::setShowtimeBarcodesSyncStatus()
     * @uses AccessControl_EntityAccessControlData::setShowtimeSyncRequestId()
     * @uses AccessControl_EntityAccessControlData::setSyncAttendanceData()
     * @uses AccessControl_EntityAccessControlData::setUsesAccessControl()
     * @uses AccessControl_EntityAccessControlData::setXmlContainer()
     * @param string $accessControlProviderId
     * @param bool $accessControlSwitchedOn
     * @param string $accessControlSyncStatus
     * @param string $accessControlSystemId
     * @param \patest\StructType\GlobalString $accessControlSystemName
     * @param string $accessControlSystemReferenceId
     * @param string $attendanceDataSyncDate
     * @param bool $canBeScannedRemotely
     * @param string $detachReferenceId
     * @param string $entityId
     * @param string $entityName
     * @param bool $hasExternalBarcodeProviders
     * @param bool $isInternal
     * @param string $lastSyncDate
     * @param string $lastSyncError
     * @param string $modifiedProperties
     * @param string $parentEntityAccessControlDataId
     * @param bool $scheduledForDelete
     * @param string $showtimeBarcodesSyncMessage
     * @param int $showtimeBarcodesSyncStatus
     * @param int $showtimeSyncRequestId
     * @param bool $syncAttendanceData
     * @param bool $usesAccessControl
     * @param string $xmlContainer
     */
    public function __construct($accessControlProviderId = null, $accessControlSwitchedOn = null, $accessControlSyncStatus = null, $accessControlSystemId = null, \patest\StructType\GlobalString $accessControlSystemName = null, $accessControlSystemReferenceId = null, $attendanceDataSyncDate = null, $canBeScannedRemotely = null, $detachReferenceId = null, $entityId = null, $entityName = null, $hasExternalBarcodeProviders = null, $isInternal = null, $lastSyncDate = null, $lastSyncError = null, $modifiedProperties = null, $parentEntityAccessControlDataId = null, $scheduledForDelete = null, $showtimeBarcodesSyncMessage = null, $showtimeBarcodesSyncStatus = null, $showtimeSyncRequestId = null, $syncAttendanceData = null, $usesAccessControl = null, $xmlContainer = null)
    {
        $this
            ->setAccessControlProviderId($accessControlProviderId)
            ->setAccessControlSwitchedOn($accessControlSwitchedOn)
            ->setAccessControlSyncStatus($accessControlSyncStatus)
            ->setAccessControlSystemId($accessControlSystemId)
            ->setAccessControlSystemName($accessControlSystemName)
            ->setAccessControlSystemReferenceId($accessControlSystemReferenceId)
            ->setAttendanceDataSyncDate($attendanceDataSyncDate)
            ->setCanBeScannedRemotely($canBeScannedRemotely)
            ->setDetachReferenceId($detachReferenceId)
            ->setEntityId($entityId)
            ->setEntityName($entityName)
            ->setHasExternalBarcodeProviders($hasExternalBarcodeProviders)
            ->setIsInternal($isInternal)
            ->setLastSyncDate($lastSyncDate)
            ->setLastSyncError($lastSyncError)
            ->setModifiedProperties($modifiedProperties)
            ->setParentEntityAccessControlDataId($parentEntityAccessControlDataId)
            ->setScheduledForDelete($scheduledForDelete)
            ->setShowtimeBarcodesSyncMessage($showtimeBarcodesSyncMessage)
            ->setShowtimeBarcodesSyncStatus($showtimeBarcodesSyncStatus)
            ->setShowtimeSyncRequestId($showtimeSyncRequestId)
            ->setSyncAttendanceData($syncAttendanceData)
            ->setUsesAccessControl($usesAccessControl)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccessControlProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProviderId()
    {
        return isset($this->AccessControlProviderId) ? $this->AccessControlProviderId : null;
    }
    /**
     * Set AccessControlProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProviderId
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setAccessControlProviderId($accessControlProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProviderId) && !is_string($accessControlProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProviderId, true), gettype($accessControlProviderId)), __LINE__);
        }
        if (is_null($accessControlProviderId) || (is_array($accessControlProviderId) && empty($accessControlProviderId))) {
            unset($this->AccessControlProviderId);
        } else {
            $this->AccessControlProviderId = $accessControlProviderId;
        }
        return $this;
    }
    /**
     * Get AccessControlSwitchedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAccessControlSwitchedOn()
    {
        return isset($this->AccessControlSwitchedOn) ? $this->AccessControlSwitchedOn : null;
    }
    /**
     * Set AccessControlSwitchedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $accessControlSwitchedOn
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setAccessControlSwitchedOn($accessControlSwitchedOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($accessControlSwitchedOn) && !is_bool($accessControlSwitchedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accessControlSwitchedOn, true), gettype($accessControlSwitchedOn)), __LINE__);
        }
        if (is_null($accessControlSwitchedOn) || (is_array($accessControlSwitchedOn) && empty($accessControlSwitchedOn))) {
            unset($this->AccessControlSwitchedOn);
        } else {
            $this->AccessControlSwitchedOn = $accessControlSwitchedOn;
        }
        return $this;
    }
    /**
     * Get AccessControlSyncStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSyncStatus()
    {
        return isset($this->AccessControlSyncStatus) ? $this->AccessControlSyncStatus : null;
    }
    /**
     * Set AccessControlSyncStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessControlSynchronizationStatus::valueIsValid()
     * @uses \patest\EnumType\AccessControlSynchronizationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessControlSyncStatus
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setAccessControlSyncStatus($accessControlSyncStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessControlSynchronizationStatus::valueIsValid($accessControlSyncStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessControlSynchronizationStatus', is_array($accessControlSyncStatus) ? implode(', ', $accessControlSyncStatus) : var_export($accessControlSyncStatus, true), implode(', ', \patest\EnumType\AccessControlSynchronizationStatus::getValidValues())), __LINE__);
        }
        if (is_null($accessControlSyncStatus) || (is_array($accessControlSyncStatus) && empty($accessControlSyncStatus))) {
            unset($this->AccessControlSyncStatus);
        } else {
            $this->AccessControlSyncStatus = $accessControlSyncStatus;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAccessControlSystemName()
    {
        return isset($this->AccessControlSystemName) ? $this->AccessControlSystemName : null;
    }
    /**
     * Set AccessControlSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $accessControlSystemName
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setAccessControlSystemName(\patest\StructType\GlobalString $accessControlSystemName = null)
    {
        if (is_null($accessControlSystemName) || (is_array($accessControlSystemName) && empty($accessControlSystemName))) {
            unset($this->AccessControlSystemName);
        } else {
            $this->AccessControlSystemName = $accessControlSystemName;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemReferenceId()
    {
        return isset($this->AccessControlSystemReferenceId) ? $this->AccessControlSystemReferenceId : null;
    }
    /**
     * Set AccessControlSystemReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemReferenceId
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setAccessControlSystemReferenceId($accessControlSystemReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemReferenceId) && !is_string($accessControlSystemReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemReferenceId, true), gettype($accessControlSystemReferenceId)), __LINE__);
        }
        if (is_null($accessControlSystemReferenceId) || (is_array($accessControlSystemReferenceId) && empty($accessControlSystemReferenceId))) {
            unset($this->AccessControlSystemReferenceId);
        } else {
            $this->AccessControlSystemReferenceId = $accessControlSystemReferenceId;
        }
        return $this;
    }
    /**
     * Get AttendanceDataSyncDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttendanceDataSyncDate()
    {
        return isset($this->AttendanceDataSyncDate) ? $this->AttendanceDataSyncDate : null;
    }
    /**
     * Set AttendanceDataSyncDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attendanceDataSyncDate
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setAttendanceDataSyncDate($attendanceDataSyncDate = null)
    {
        // validation for constraint: string
        if (!is_null($attendanceDataSyncDate) && !is_string($attendanceDataSyncDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attendanceDataSyncDate, true), gettype($attendanceDataSyncDate)), __LINE__);
        }
        if (is_null($attendanceDataSyncDate) || (is_array($attendanceDataSyncDate) && empty($attendanceDataSyncDate))) {
            unset($this->AttendanceDataSyncDate);
        } else {
            $this->AttendanceDataSyncDate = $attendanceDataSyncDate;
        }
        return $this;
    }
    /**
     * Get CanBeScannedRemotely value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanBeScannedRemotely()
    {
        return isset($this->CanBeScannedRemotely) ? $this->CanBeScannedRemotely : null;
    }
    /**
     * Set CanBeScannedRemotely value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canBeScannedRemotely
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setCanBeScannedRemotely($canBeScannedRemotely = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBeScannedRemotely) && !is_bool($canBeScannedRemotely)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBeScannedRemotely, true), gettype($canBeScannedRemotely)), __LINE__);
        }
        if (is_null($canBeScannedRemotely) || (is_array($canBeScannedRemotely) && empty($canBeScannedRemotely))) {
            unset($this->CanBeScannedRemotely);
        } else {
            $this->CanBeScannedRemotely = $canBeScannedRemotely;
        }
        return $this;
    }
    /**
     * Get DetachReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetachReferenceId()
    {
        return isset($this->DetachReferenceId) ? $this->DetachReferenceId : null;
    }
    /**
     * Set DetachReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detachReferenceId
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setDetachReferenceId($detachReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($detachReferenceId) && !is_string($detachReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detachReferenceId, true), gettype($detachReferenceId)), __LINE__);
        }
        if (is_null($detachReferenceId) || (is_array($detachReferenceId) && empty($detachReferenceId))) {
            unset($this->DetachReferenceId);
        } else {
            $this->DetachReferenceId = $detachReferenceId;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get HasExternalBarcodeProviders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasExternalBarcodeProviders()
    {
        return isset($this->HasExternalBarcodeProviders) ? $this->HasExternalBarcodeProviders : null;
    }
    /**
     * Set HasExternalBarcodeProviders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasExternalBarcodeProviders
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setHasExternalBarcodeProviders($hasExternalBarcodeProviders = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasExternalBarcodeProviders) && !is_bool($hasExternalBarcodeProviders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasExternalBarcodeProviders, true), gettype($hasExternalBarcodeProviders)), __LINE__);
        }
        if (is_null($hasExternalBarcodeProviders) || (is_array($hasExternalBarcodeProviders) && empty($hasExternalBarcodeProviders))) {
            unset($this->HasExternalBarcodeProviders);
        } else {
            $this->HasExternalBarcodeProviders = $hasExternalBarcodeProviders;
        }
        return $this;
    }
    /**
     * Get IsInternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInternal()
    {
        return isset($this->IsInternal) ? $this->IsInternal : null;
    }
    /**
     * Set IsInternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInternal
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setIsInternal($isInternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternal) && !is_bool($isInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternal, true), gettype($isInternal)), __LINE__);
        }
        if (is_null($isInternal) || (is_array($isInternal) && empty($isInternal))) {
            unset($this->IsInternal);
        } else {
            $this->IsInternal = $isInternal;
        }
        return $this;
    }
    /**
     * Get LastSyncDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSyncDate()
    {
        return isset($this->LastSyncDate) ? $this->LastSyncDate : null;
    }
    /**
     * Set LastSyncDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSyncDate
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setLastSyncDate($lastSyncDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastSyncDate) && !is_string($lastSyncDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSyncDate, true), gettype($lastSyncDate)), __LINE__);
        }
        if (is_null($lastSyncDate) || (is_array($lastSyncDate) && empty($lastSyncDate))) {
            unset($this->LastSyncDate);
        } else {
            $this->LastSyncDate = $lastSyncDate;
        }
        return $this;
    }
    /**
     * Get LastSyncError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSyncError()
    {
        return isset($this->LastSyncError) ? $this->LastSyncError : null;
    }
    /**
     * Set LastSyncError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSyncError
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setLastSyncError($lastSyncError = null)
    {
        // validation for constraint: string
        if (!is_null($lastSyncError) && !is_string($lastSyncError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSyncError, true), gettype($lastSyncError)), __LINE__);
        }
        if (is_null($lastSyncError) || (is_array($lastSyncError) && empty($lastSyncError))) {
            unset($this->LastSyncError);
        } else {
            $this->LastSyncError = $lastSyncError;
        }
        return $this;
    }
    /**
     * Get ModifiedProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifiedProperties()
    {
        return isset($this->ModifiedProperties) ? $this->ModifiedProperties : null;
    }
    /**
     * Set ModifiedProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifiedProperties
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setModifiedProperties($modifiedProperties = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedProperties) && !is_string($modifiedProperties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedProperties, true), gettype($modifiedProperties)), __LINE__);
        }
        if (is_null($modifiedProperties) || (is_array($modifiedProperties) && empty($modifiedProperties))) {
            unset($this->ModifiedProperties);
        } else {
            $this->ModifiedProperties = $modifiedProperties;
        }
        return $this;
    }
    /**
     * Get ParentEntityAccessControlDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentEntityAccessControlDataId()
    {
        return isset($this->ParentEntityAccessControlDataId) ? $this->ParentEntityAccessControlDataId : null;
    }
    /**
     * Set ParentEntityAccessControlDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentEntityAccessControlDataId
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setParentEntityAccessControlDataId($parentEntityAccessControlDataId = null)
    {
        // validation for constraint: string
        if (!is_null($parentEntityAccessControlDataId) && !is_string($parentEntityAccessControlDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentEntityAccessControlDataId, true), gettype($parentEntityAccessControlDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentEntityAccessControlDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentEntityAccessControlDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentEntityAccessControlDataId, true)), __LINE__);
        }
        if (is_null($parentEntityAccessControlDataId) || (is_array($parentEntityAccessControlDataId) && empty($parentEntityAccessControlDataId))) {
            unset($this->ParentEntityAccessControlDataId);
        } else {
            $this->ParentEntityAccessControlDataId = $parentEntityAccessControlDataId;
        }
        return $this;
    }
    /**
     * Get ScheduledForDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getScheduledForDelete()
    {
        return isset($this->ScheduledForDelete) ? $this->ScheduledForDelete : null;
    }
    /**
     * Set ScheduledForDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $scheduledForDelete
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setScheduledForDelete($scheduledForDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($scheduledForDelete) && !is_bool($scheduledForDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scheduledForDelete, true), gettype($scheduledForDelete)), __LINE__);
        }
        if (is_null($scheduledForDelete) || (is_array($scheduledForDelete) && empty($scheduledForDelete))) {
            unset($this->ScheduledForDelete);
        } else {
            $this->ScheduledForDelete = $scheduledForDelete;
        }
        return $this;
    }
    /**
     * Get ShowtimeBarcodesSyncMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeBarcodesSyncMessage()
    {
        return isset($this->ShowtimeBarcodesSyncMessage) ? $this->ShowtimeBarcodesSyncMessage : null;
    }
    /**
     * Set ShowtimeBarcodesSyncMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeBarcodesSyncMessage
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setShowtimeBarcodesSyncMessage($showtimeBarcodesSyncMessage = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeBarcodesSyncMessage) && !is_string($showtimeBarcodesSyncMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeBarcodesSyncMessage, true), gettype($showtimeBarcodesSyncMessage)), __LINE__);
        }
        if (is_null($showtimeBarcodesSyncMessage) || (is_array($showtimeBarcodesSyncMessage) && empty($showtimeBarcodesSyncMessage))) {
            unset($this->ShowtimeBarcodesSyncMessage);
        } else {
            $this->ShowtimeBarcodesSyncMessage = $showtimeBarcodesSyncMessage;
        }
        return $this;
    }
    /**
     * Get ShowtimeBarcodesSyncStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowtimeBarcodesSyncStatus()
    {
        return isset($this->ShowtimeBarcodesSyncStatus) ? $this->ShowtimeBarcodesSyncStatus : null;
    }
    /**
     * Set ShowtimeBarcodesSyncStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showtimeBarcodesSyncStatus
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setShowtimeBarcodesSyncStatus($showtimeBarcodesSyncStatus = null)
    {
        // validation for constraint: int
        if (!is_null($showtimeBarcodesSyncStatus) && !(is_int($showtimeBarcodesSyncStatus) || ctype_digit($showtimeBarcodesSyncStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showtimeBarcodesSyncStatus, true), gettype($showtimeBarcodesSyncStatus)), __LINE__);
        }
        if (is_null($showtimeBarcodesSyncStatus) || (is_array($showtimeBarcodesSyncStatus) && empty($showtimeBarcodesSyncStatus))) {
            unset($this->ShowtimeBarcodesSyncStatus);
        } else {
            $this->ShowtimeBarcodesSyncStatus = $showtimeBarcodesSyncStatus;
        }
        return $this;
    }
    /**
     * Get ShowtimeSyncRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowtimeSyncRequestId()
    {
        return isset($this->ShowtimeSyncRequestId) ? $this->ShowtimeSyncRequestId : null;
    }
    /**
     * Set ShowtimeSyncRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showtimeSyncRequestId
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setShowtimeSyncRequestId($showtimeSyncRequestId = null)
    {
        // validation for constraint: int
        if (!is_null($showtimeSyncRequestId) && !(is_int($showtimeSyncRequestId) || ctype_digit($showtimeSyncRequestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showtimeSyncRequestId, true), gettype($showtimeSyncRequestId)), __LINE__);
        }
        if (is_null($showtimeSyncRequestId) || (is_array($showtimeSyncRequestId) && empty($showtimeSyncRequestId))) {
            unset($this->ShowtimeSyncRequestId);
        } else {
            $this->ShowtimeSyncRequestId = $showtimeSyncRequestId;
        }
        return $this;
    }
    /**
     * Get SyncAttendanceData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSyncAttendanceData()
    {
        return isset($this->SyncAttendanceData) ? $this->SyncAttendanceData : null;
    }
    /**
     * Set SyncAttendanceData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $syncAttendanceData
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setSyncAttendanceData($syncAttendanceData = null)
    {
        // validation for constraint: boolean
        if (!is_null($syncAttendanceData) && !is_bool($syncAttendanceData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($syncAttendanceData, true), gettype($syncAttendanceData)), __LINE__);
        }
        if (is_null($syncAttendanceData) || (is_array($syncAttendanceData) && empty($syncAttendanceData))) {
            unset($this->SyncAttendanceData);
        } else {
            $this->SyncAttendanceData = $syncAttendanceData;
        }
        return $this;
    }
    /**
     * Get UsesAccessControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsesAccessControl()
    {
        return isset($this->UsesAccessControl) ? $this->UsesAccessControl : null;
    }
    /**
     * Set UsesAccessControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usesAccessControl
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setUsesAccessControl($usesAccessControl = null)
    {
        // validation for constraint: boolean
        if (!is_null($usesAccessControl) && !is_bool($usesAccessControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usesAccessControl, true), gettype($usesAccessControl)), __LINE__);
        }
        if (is_null($usesAccessControl) || (is_array($usesAccessControl) && empty($usesAccessControl))) {
            unset($this->UsesAccessControl);
        } else {
            $this->UsesAccessControl = $usesAccessControl;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\AccessControl_EntityAccessControlData
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
