<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeInfo.Membership StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeInfo_Membership extends AccessControl_BarcodeInfo_NonTerminalEntity
{
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EventInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public $EventInfo;
    /**
     * The JointMembershipInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public $JointMembershipInfo;
    /**
     * The MembershipDefinitionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MembershipDefinitionName;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The NeedJointMembershipData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NeedJointMembershipData;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * Constructor method for AccessControl.BarcodeInfo.Membership
     * @uses AccessControl_BarcodeInfo_Membership::setEndDate()
     * @uses AccessControl_BarcodeInfo_Membership::setEventInfo()
     * @uses AccessControl_BarcodeInfo_Membership::setJointMembershipInfo()
     * @uses AccessControl_BarcodeInfo_Membership::setMembershipDefinitionName()
     * @uses AccessControl_BarcodeInfo_Membership::setMembershipNumber()
     * @uses AccessControl_BarcodeInfo_Membership::setNeedJointMembershipData()
     * @uses AccessControl_BarcodeInfo_Membership::setStartDate()
     * @param string $endDate
     * @param \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo $eventInfo
     * @param \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo $jointMembershipInfo
     * @param \patest\StructType\GlobalString $membershipDefinitionName
     * @param string $membershipNumber
     * @param bool $needJointMembershipData
     * @param string $startDate
     */
    public function __construct($endDate = null, \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo $eventInfo = null, \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo $jointMembershipInfo = null, \patest\StructType\GlobalString $membershipDefinitionName = null, $membershipNumber = null, $needJointMembershipData = null, $startDate = null)
    {
        $this
            ->setEndDate($endDate)
            ->setEventInfo($eventInfo)
            ->setJointMembershipInfo($jointMembershipInfo)
            ->setMembershipDefinitionName($membershipDefinitionName)
            ->setMembershipNumber($membershipNumber)
            ->setNeedJointMembershipData($needJointMembershipData)
            ->setStartDate($startDate);
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\AccessControl_BarcodeInfo_Membership
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EventInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo|null
     */
    public function getEventInfo()
    {
        return isset($this->EventInfo) ? $this->EventInfo : null;
    }
    /**
     * Set EventInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo $eventInfo
     * @return \patest\StructType\AccessControl_BarcodeInfo_Membership
     */
    public function setEventInfo(\patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo $eventInfo = null)
    {
        if (is_null($eventInfo) || (is_array($eventInfo) && empty($eventInfo))) {
            unset($this->EventInfo);
        } else {
            $this->EventInfo = $eventInfo;
        }
        return $this;
    }
    /**
     * Get JointMembershipInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo|null
     */
    public function getJointMembershipInfo()
    {
        return isset($this->JointMembershipInfo) ? $this->JointMembershipInfo : null;
    }
    /**
     * Set JointMembershipInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo $jointMembershipInfo
     * @return \patest\StructType\AccessControl_BarcodeInfo_Membership
     */
    public function setJointMembershipInfo(\patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo $jointMembershipInfo = null)
    {
        if (is_null($jointMembershipInfo) || (is_array($jointMembershipInfo) && empty($jointMembershipInfo))) {
            unset($this->JointMembershipInfo);
        } else {
            $this->JointMembershipInfo = $jointMembershipInfo;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMembershipDefinitionName()
    {
        return isset($this->MembershipDefinitionName) ? $this->MembershipDefinitionName : null;
    }
    /**
     * Set MembershipDefinitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $membershipDefinitionName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Membership
     */
    public function setMembershipDefinitionName(\patest\StructType\GlobalString $membershipDefinitionName = null)
    {
        if (is_null($membershipDefinitionName) || (is_array($membershipDefinitionName) && empty($membershipDefinitionName))) {
            unset($this->MembershipDefinitionName);
        } else {
            $this->MembershipDefinitionName = $membershipDefinitionName;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\AccessControl_BarcodeInfo_Membership
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get NeedJointMembershipData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNeedJointMembershipData()
    {
        return isset($this->NeedJointMembershipData) ? $this->NeedJointMembershipData : null;
    }
    /**
     * Set NeedJointMembershipData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $needJointMembershipData
     * @return \patest\StructType\AccessControl_BarcodeInfo_Membership
     */
    public function setNeedJointMembershipData($needJointMembershipData = null)
    {
        // validation for constraint: boolean
        if (!is_null($needJointMembershipData) && !is_bool($needJointMembershipData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($needJointMembershipData, true), gettype($needJointMembershipData)), __LINE__);
        }
        if (is_null($needJointMembershipData) || (is_array($needJointMembershipData) && empty($needJointMembershipData))) {
            unset($this->NeedJointMembershipData);
        } else {
            $this->NeedJointMembershipData = $needJointMembershipData;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\AccessControl_BarcodeInfo_Membership
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
}
