<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeGeneratorConfig.Skidata StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeGeneratorConfig_Skidata extends AccessControl_BarcodeGeneratorConfig_BaseEntity
{
    /**
     * The BarcodeIssuer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BarcodeIssuer;
    /**
     * The RandomNumberLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RandomNumberLength;
    /**
     * The TemplateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TemplateNumber;
    /**
     * Constructor method for AccessControl.BarcodeGeneratorConfig.Skidata
     * @uses AccessControl_BarcodeGeneratorConfig_Skidata::setBarcodeIssuer()
     * @uses AccessControl_BarcodeGeneratorConfig_Skidata::setRandomNumberLength()
     * @uses AccessControl_BarcodeGeneratorConfig_Skidata::setTemplateNumber()
     * @param int $barcodeIssuer
     * @param int $randomNumberLength
     * @param int $templateNumber
     */
    public function __construct($barcodeIssuer = null, $randomNumberLength = null, $templateNumber = null)
    {
        $this
            ->setBarcodeIssuer($barcodeIssuer)
            ->setRandomNumberLength($randomNumberLength)
            ->setTemplateNumber($templateNumber);
    }
    /**
     * Get BarcodeIssuer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBarcodeIssuer()
    {
        return isset($this->BarcodeIssuer) ? $this->BarcodeIssuer : null;
    }
    /**
     * Set BarcodeIssuer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $barcodeIssuer
     * @return \patest\StructType\AccessControl_BarcodeGeneratorConfig_Skidata
     */
    public function setBarcodeIssuer($barcodeIssuer = null)
    {
        // validation for constraint: int
        if (!is_null($barcodeIssuer) && !(is_int($barcodeIssuer) || ctype_digit($barcodeIssuer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($barcodeIssuer, true), gettype($barcodeIssuer)), __LINE__);
        }
        if (is_null($barcodeIssuer) || (is_array($barcodeIssuer) && empty($barcodeIssuer))) {
            unset($this->BarcodeIssuer);
        } else {
            $this->BarcodeIssuer = $barcodeIssuer;
        }
        return $this;
    }
    /**
     * Get RandomNumberLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRandomNumberLength()
    {
        return isset($this->RandomNumberLength) ? $this->RandomNumberLength : null;
    }
    /**
     * Set RandomNumberLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $randomNumberLength
     * @return \patest\StructType\AccessControl_BarcodeGeneratorConfig_Skidata
     */
    public function setRandomNumberLength($randomNumberLength = null)
    {
        // validation for constraint: int
        if (!is_null($randomNumberLength) && !(is_int($randomNumberLength) || ctype_digit($randomNumberLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($randomNumberLength, true), gettype($randomNumberLength)), __LINE__);
        }
        if (is_null($randomNumberLength) || (is_array($randomNumberLength) && empty($randomNumberLength))) {
            unset($this->RandomNumberLength);
        } else {
            $this->RandomNumberLength = $randomNumberLength;
        }
        return $this;
    }
    /**
     * Get TemplateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTemplateNumber()
    {
        return isset($this->TemplateNumber) ? $this->TemplateNumber : null;
    }
    /**
     * Set TemplateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $templateNumber
     * @return \patest\StructType\AccessControl_BarcodeGeneratorConfig_Skidata
     */
    public function setTemplateNumber($templateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($templateNumber) && !(is_int($templateNumber) || ctype_digit($templateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateNumber, true), gettype($templateNumber)), __LINE__);
        }
        if (is_null($templateNumber) || (is_array($templateNumber) && empty($templateNumber))) {
            unset($this->TemplateNumber);
        } else {
            $this->TemplateNumber = $templateNumber;
        }
        return $this;
    }
}
