<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeGeneratorConfig.BaseEntity StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeGeneratorConfig_BaseEntity extends AnyEntity
{
    /**
     * The BarcodeGeneratorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeGeneratorId;
    /**
     * The BarcodeProviderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeProviderId;
    /**
     * Constructor method for AccessControl.BarcodeGeneratorConfig.BaseEntity
     * @uses AccessControl_BarcodeGeneratorConfig_BaseEntity::setBarcodeGeneratorId()
     * @uses AccessControl_BarcodeGeneratorConfig_BaseEntity::setBarcodeProviderId()
     * @param string $barcodeGeneratorId
     * @param string $barcodeProviderId
     */
    public function __construct($barcodeGeneratorId = null, $barcodeProviderId = null)
    {
        $this
            ->setBarcodeGeneratorId($barcodeGeneratorId)
            ->setBarcodeProviderId($barcodeProviderId);
    }
    /**
     * Get BarcodeGeneratorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeGeneratorId()
    {
        return isset($this->BarcodeGeneratorId) ? $this->BarcodeGeneratorId : null;
    }
    /**
     * Set BarcodeGeneratorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeGeneratorId
     * @return \patest\StructType\AccessControl_BarcodeGeneratorConfig_BaseEntity
     */
    public function setBarcodeGeneratorId($barcodeGeneratorId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeGeneratorId) && !is_string($barcodeGeneratorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeGeneratorId, true), gettype($barcodeGeneratorId)), __LINE__);
        }
        if (is_null($barcodeGeneratorId) || (is_array($barcodeGeneratorId) && empty($barcodeGeneratorId))) {
            unset($this->BarcodeGeneratorId);
        } else {
            $this->BarcodeGeneratorId = $barcodeGeneratorId;
        }
        return $this;
    }
    /**
     * Get BarcodeProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeProviderId()
    {
        return isset($this->BarcodeProviderId) ? $this->BarcodeProviderId : null;
    }
    /**
     * Set BarcodeProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeProviderId
     * @return \patest\StructType\AccessControl_BarcodeGeneratorConfig_BaseEntity
     */
    public function setBarcodeProviderId($barcodeProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeProviderId) && !is_string($barcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeProviderId, true), gettype($barcodeProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeProviderId, true)), __LINE__);
        }
        if (is_null($barcodeProviderId) || (is_array($barcodeProviderId) && empty($barcodeProviderId))) {
            unset($this->BarcodeProviderId);
        } else {
            $this->BarcodeProviderId = $barcodeProviderId;
        }
        return $this;
    }
}
