<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.Barcode StructType
 * @subpackage Structs
 */
class AccessControl_Barcode extends PersistableEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CancelDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CancelDate;
    /**
     * The CancelReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CancelReason;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsVirtual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVirtual;
    /**
     * The LastSyncError
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSyncError;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ReferencedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedEntityId;
    /**
     * The ReferencedEntityIsReturned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReferencedEntityIsReturned;
    /**
     * The ReferencedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferencedEntityName;
    /**
     * The ScanHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeUsage
     */
    public $ScanHistory;
    /**
     * The ScannedEntriesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScannedEntriesCount;
    /**
     * The ShowtimeSyncRequestId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowtimeSyncRequestId;
    /**
     * The ShowtimeSyncStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeSyncStatus;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for AccessControl.Barcode
     * @uses AccessControl_Barcode::setAccessControlSystemId()
     * @uses AccessControl_Barcode::setBarcode()
     * @uses AccessControl_Barcode::setCancelDate()
     * @uses AccessControl_Barcode::setCancelReason()
     * @uses AccessControl_Barcode::setClientId()
     * @uses AccessControl_Barcode::setCreationDate()
     * @uses AccessControl_Barcode::setEventId()
     * @uses AccessControl_Barcode::setIsActive()
     * @uses AccessControl_Barcode::setIsVirtual()
     * @uses AccessControl_Barcode::setLastSyncError()
     * @uses AccessControl_Barcode::setOrganizationUnitId()
     * @uses AccessControl_Barcode::setReferencedEntityId()
     * @uses AccessControl_Barcode::setReferencedEntityIsReturned()
     * @uses AccessControl_Barcode::setReferencedEntityName()
     * @uses AccessControl_Barcode::setScanHistory()
     * @uses AccessControl_Barcode::setScannedEntriesCount()
     * @uses AccessControl_Barcode::setShowtimeSyncRequestId()
     * @uses AccessControl_Barcode::setShowtimeSyncStatus()
     * @uses AccessControl_Barcode::setTicketNumber()
     * @uses AccessControl_Barcode::setXmlContainer()
     * @param string $accessControlSystemId
     * @param string $barcode
     * @param string $cancelDate
     * @param \patest\StructType\GlobalString $cancelReason
     * @param string $clientId
     * @param string $creationDate
     * @param string $eventId
     * @param bool $isActive
     * @param bool $isVirtual
     * @param string $lastSyncError
     * @param string $organizationUnitId
     * @param string $referencedEntityId
     * @param bool $referencedEntityIsReturned
     * @param string $referencedEntityName
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeUsage $scanHistory
     * @param int $scannedEntriesCount
     * @param int $showtimeSyncRequestId
     * @param string $showtimeSyncStatus
     * @param int $ticketNumber
     * @param string $xmlContainer
     */
    public function __construct($accessControlSystemId = null, $barcode = null, $cancelDate = null, \patest\StructType\GlobalString $cancelReason = null, $clientId = null, $creationDate = null, $eventId = null, $isActive = null, $isVirtual = null, $lastSyncError = null, $organizationUnitId = null, $referencedEntityId = null, $referencedEntityIsReturned = null, $referencedEntityName = null, \patest\StructType\RecordSetOfAccessControl_BarcodeUsage $scanHistory = null, $scannedEntriesCount = null, $showtimeSyncRequestId = null, $showtimeSyncStatus = null, $ticketNumber = null, $xmlContainer = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setBarcode($barcode)
            ->setCancelDate($cancelDate)
            ->setCancelReason($cancelReason)
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setEventId($eventId)
            ->setIsActive($isActive)
            ->setIsVirtual($isVirtual)
            ->setLastSyncError($lastSyncError)
            ->setOrganizationUnitId($organizationUnitId)
            ->setReferencedEntityId($referencedEntityId)
            ->setReferencedEntityIsReturned($referencedEntityIsReturned)
            ->setReferencedEntityName($referencedEntityName)
            ->setScanHistory($scanHistory)
            ->setScannedEntriesCount($scannedEntriesCount)
            ->setShowtimeSyncRequestId($showtimeSyncRequestId)
            ->setShowtimeSyncStatus($showtimeSyncStatus)
            ->setTicketNumber($ticketNumber)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CancelDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCancelDate()
    {
        return isset($this->CancelDate) ? $this->CancelDate : null;
    }
    /**
     * Set CancelDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cancelDate
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setCancelDate($cancelDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelDate) && !is_string($cancelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelDate, true), gettype($cancelDate)), __LINE__);
        }
        if (is_null($cancelDate) || (is_array($cancelDate) && empty($cancelDate))) {
            unset($this->CancelDate);
        } else {
            $this->CancelDate = $cancelDate;
        }
        return $this;
    }
    /**
     * Get CancelReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCancelReason()
    {
        return isset($this->CancelReason) ? $this->CancelReason : null;
    }
    /**
     * Set CancelReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $cancelReason
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setCancelReason(\patest\StructType\GlobalString $cancelReason = null)
    {
        if (is_null($cancelReason) || (is_array($cancelReason) && empty($cancelReason))) {
            unset($this->CancelReason);
        } else {
            $this->CancelReason = $cancelReason;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsVirtual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVirtual()
    {
        return isset($this->IsVirtual) ? $this->IsVirtual : null;
    }
    /**
     * Set IsVirtual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVirtual
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setIsVirtual($isVirtual = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVirtual) && !is_bool($isVirtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVirtual, true), gettype($isVirtual)), __LINE__);
        }
        if (is_null($isVirtual) || (is_array($isVirtual) && empty($isVirtual))) {
            unset($this->IsVirtual);
        } else {
            $this->IsVirtual = $isVirtual;
        }
        return $this;
    }
    /**
     * Get LastSyncError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSyncError()
    {
        return isset($this->LastSyncError) ? $this->LastSyncError : null;
    }
    /**
     * Set LastSyncError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSyncError
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setLastSyncError($lastSyncError = null)
    {
        // validation for constraint: string
        if (!is_null($lastSyncError) && !is_string($lastSyncError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSyncError, true), gettype($lastSyncError)), __LINE__);
        }
        if (is_null($lastSyncError) || (is_array($lastSyncError) && empty($lastSyncError))) {
            unset($this->LastSyncError);
        } else {
            $this->LastSyncError = $lastSyncError;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityId()
    {
        return isset($this->ReferencedEntityId) ? $this->ReferencedEntityId : null;
    }
    /**
     * Set ReferencedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityId
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setReferencedEntityId($referencedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityId) && !is_string($referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityId, true), gettype($referencedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referencedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referencedEntityId, true)), __LINE__);
        }
        if (is_null($referencedEntityId) || (is_array($referencedEntityId) && empty($referencedEntityId))) {
            unset($this->ReferencedEntityId);
        } else {
            $this->ReferencedEntityId = $referencedEntityId;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityIsReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReferencedEntityIsReturned()
    {
        return isset($this->ReferencedEntityIsReturned) ? $this->ReferencedEntityIsReturned : null;
    }
    /**
     * Set ReferencedEntityIsReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $referencedEntityIsReturned
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setReferencedEntityIsReturned($referencedEntityIsReturned = null)
    {
        // validation for constraint: boolean
        if (!is_null($referencedEntityIsReturned) && !is_bool($referencedEntityIsReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($referencedEntityIsReturned, true), gettype($referencedEntityIsReturned)), __LINE__);
        }
        if (is_null($referencedEntityIsReturned) || (is_array($referencedEntityIsReturned) && empty($referencedEntityIsReturned))) {
            unset($this->ReferencedEntityIsReturned);
        } else {
            $this->ReferencedEntityIsReturned = $referencedEntityIsReturned;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityName()
    {
        return isset($this->ReferencedEntityName) ? $this->ReferencedEntityName : null;
    }
    /**
     * Set ReferencedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityName
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setReferencedEntityName($referencedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityName) && !is_string($referencedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityName, true), gettype($referencedEntityName)), __LINE__);
        }
        if (is_null($referencedEntityName) || (is_array($referencedEntityName) && empty($referencedEntityName))) {
            unset($this->ReferencedEntityName);
        } else {
            $this->ReferencedEntityName = $referencedEntityName;
        }
        return $this;
    }
    /**
     * Get ScanHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeUsage|null
     */
    public function getScanHistory()
    {
        return isset($this->ScanHistory) ? $this->ScanHistory : null;
    }
    /**
     * Set ScanHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeUsage $scanHistory
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setScanHistory(\patest\StructType\RecordSetOfAccessControl_BarcodeUsage $scanHistory = null)
    {
        if (is_null($scanHistory) || (is_array($scanHistory) && empty($scanHistory))) {
            unset($this->ScanHistory);
        } else {
            $this->ScanHistory = $scanHistory;
        }
        return $this;
    }
    /**
     * Get ScannedEntriesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScannedEntriesCount()
    {
        return isset($this->ScannedEntriesCount) ? $this->ScannedEntriesCount : null;
    }
    /**
     * Set ScannedEntriesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scannedEntriesCount
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setScannedEntriesCount($scannedEntriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($scannedEntriesCount) && !(is_int($scannedEntriesCount) || ctype_digit($scannedEntriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scannedEntriesCount, true), gettype($scannedEntriesCount)), __LINE__);
        }
        if (is_null($scannedEntriesCount) || (is_array($scannedEntriesCount) && empty($scannedEntriesCount))) {
            unset($this->ScannedEntriesCount);
        } else {
            $this->ScannedEntriesCount = $scannedEntriesCount;
        }
        return $this;
    }
    /**
     * Get ShowtimeSyncRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowtimeSyncRequestId()
    {
        return isset($this->ShowtimeSyncRequestId) ? $this->ShowtimeSyncRequestId : null;
    }
    /**
     * Set ShowtimeSyncRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showtimeSyncRequestId
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setShowtimeSyncRequestId($showtimeSyncRequestId = null)
    {
        // validation for constraint: int
        if (!is_null($showtimeSyncRequestId) && !(is_int($showtimeSyncRequestId) || ctype_digit($showtimeSyncRequestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showtimeSyncRequestId, true), gettype($showtimeSyncRequestId)), __LINE__);
        }
        if (is_null($showtimeSyncRequestId) || (is_array($showtimeSyncRequestId) && empty($showtimeSyncRequestId))) {
            unset($this->ShowtimeSyncRequestId);
        } else {
            $this->ShowtimeSyncRequestId = $showtimeSyncRequestId;
        }
        return $this;
    }
    /**
     * Get ShowtimeSyncStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeSyncStatus()
    {
        return isset($this->ShowtimeSyncStatus) ? $this->ShowtimeSyncStatus : null;
    }
    /**
     * Set ShowtimeSyncStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessControlSynchronizationStatus::valueIsValid()
     * @uses \patest\EnumType\AccessControlSynchronizationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $showtimeSyncStatus
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setShowtimeSyncStatus($showtimeSyncStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessControlSynchronizationStatus::valueIsValid($showtimeSyncStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessControlSynchronizationStatus', is_array($showtimeSyncStatus) ? implode(', ', $showtimeSyncStatus) : var_export($showtimeSyncStatus, true), implode(', ', \patest\EnumType\AccessControlSynchronizationStatus::getValidValues())), __LINE__);
        }
        if (is_null($showtimeSyncStatus) || (is_array($showtimeSyncStatus) && empty($showtimeSyncStatus))) {
            unset($this->ShowtimeSyncStatus);
        } else {
            $this->ShowtimeSyncStatus = $showtimeSyncStatus;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\AccessControl_Barcode
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
