<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ApiBarcodeInfo StructType
 * @subpackage Structs
 */
class AccessControl_ApiBarcodeInfo extends AnyEntity
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The Forename
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Forename;
    /**
     * The OriginalOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalOwnerId;
    /**
     * The OwnerClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_ApiBarcodeClientTypeInfo
     */
    public $OwnerClientTypes;
    /**
     * The OwnerDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerDisplayName;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The OwnerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $OwnerType;
    /**
     * The PrevOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrevOwnerId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The PriceTypeGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeGroupId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The ReferencedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedEntityId;
    /**
     * The ReferencedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferencedEntityName;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Surname;
    /**
     * The SyncTimestampUTC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SyncTimestampUTC;
    /**
     * Constructor method for AccessControl.ApiBarcodeInfo
     * @uses AccessControl_ApiBarcodeInfo::setBarcode()
     * @uses AccessControl_ApiBarcodeInfo::setCompanyName()
     * @uses AccessControl_ApiBarcodeInfo::setCrmId()
     * @uses AccessControl_ApiBarcodeInfo::setEmailAddress()
     * @uses AccessControl_ApiBarcodeInfo::setForename()
     * @uses AccessControl_ApiBarcodeInfo::setOriginalOwnerId()
     * @uses AccessControl_ApiBarcodeInfo::setOwnerClientTypes()
     * @uses AccessControl_ApiBarcodeInfo::setOwnerDisplayName()
     * @uses AccessControl_ApiBarcodeInfo::setOwnerId()
     * @uses AccessControl_ApiBarcodeInfo::setOwnerType()
     * @uses AccessControl_ApiBarcodeInfo::setPrevOwnerId()
     * @uses AccessControl_ApiBarcodeInfo::setPriceLevelId()
     * @uses AccessControl_ApiBarcodeInfo::setPriceLevelName()
     * @uses AccessControl_ApiBarcodeInfo::setPriceTypeGroupId()
     * @uses AccessControl_ApiBarcodeInfo::setPriceTypeId()
     * @uses AccessControl_ApiBarcodeInfo::setPriceTypeName()
     * @uses AccessControl_ApiBarcodeInfo::setReferencedEntityId()
     * @uses AccessControl_ApiBarcodeInfo::setReferencedEntityName()
     * @uses AccessControl_ApiBarcodeInfo::setSurname()
     * @uses AccessControl_ApiBarcodeInfo::setSyncTimestampUTC()
     * @param string $barcode
     * @param string $companyName
     * @param string $crmId
     * @param string $emailAddress
     * @param string $forename
     * @param string $originalOwnerId
     * @param \patest\StructType\RecordSetOfAccessControl_ApiBarcodeClientTypeInfo $ownerClientTypes
     * @param string $ownerDisplayName
     * @param string $ownerId
     * @param string[] $ownerType
     * @param string $prevOwnerId
     * @param string $priceLevelId
     * @param string $priceLevelName
     * @param string $priceTypeGroupId
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param string $referencedEntityId
     * @param string $referencedEntityName
     * @param string $surname
     * @param string $syncTimestampUTC
     */
    public function __construct($barcode = null, $companyName = null, $crmId = null, $emailAddress = null, $forename = null, $originalOwnerId = null, \patest\StructType\RecordSetOfAccessControl_ApiBarcodeClientTypeInfo $ownerClientTypes = null, $ownerDisplayName = null, $ownerId = null, array $ownerType = array(), $prevOwnerId = null, $priceLevelId = null, $priceLevelName = null, $priceTypeGroupId = null, $priceTypeId = null, $priceTypeName = null, $referencedEntityId = null, $referencedEntityName = null, $surname = null, $syncTimestampUTC = null)
    {
        $this
            ->setBarcode($barcode)
            ->setCompanyName($companyName)
            ->setCrmId($crmId)
            ->setEmailAddress($emailAddress)
            ->setForename($forename)
            ->setOriginalOwnerId($originalOwnerId)
            ->setOwnerClientTypes($ownerClientTypes)
            ->setOwnerDisplayName($ownerDisplayName)
            ->setOwnerId($ownerId)
            ->setOwnerType($ownerType)
            ->setPrevOwnerId($prevOwnerId)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelName($priceLevelName)
            ->setPriceTypeGroupId($priceTypeGroupId)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setReferencedEntityId($referencedEntityId)
            ->setReferencedEntityName($referencedEntityName)
            ->setSurname($surname)
            ->setSyncTimestampUTC($syncTimestampUTC);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyName
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get Forename value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForename()
    {
        return isset($this->Forename) ? $this->Forename : null;
    }
    /**
     * Set Forename value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forename
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setForename($forename = null)
    {
        // validation for constraint: string
        if (!is_null($forename) && !is_string($forename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forename, true), gettype($forename)), __LINE__);
        }
        if (is_null($forename) || (is_array($forename) && empty($forename))) {
            unset($this->Forename);
        } else {
            $this->Forename = $forename;
        }
        return $this;
    }
    /**
     * Get OriginalOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalOwnerId()
    {
        return isset($this->OriginalOwnerId) ? $this->OriginalOwnerId : null;
    }
    /**
     * Set OriginalOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalOwnerId
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setOriginalOwnerId($originalOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($originalOwnerId) && !is_string($originalOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalOwnerId, true), gettype($originalOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalOwnerId, true)), __LINE__);
        }
        if (is_null($originalOwnerId) || (is_array($originalOwnerId) && empty($originalOwnerId))) {
            unset($this->OriginalOwnerId);
        } else {
            $this->OriginalOwnerId = $originalOwnerId;
        }
        return $this;
    }
    /**
     * Get OwnerClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_ApiBarcodeClientTypeInfo|null
     */
    public function getOwnerClientTypes()
    {
        return isset($this->OwnerClientTypes) ? $this->OwnerClientTypes : null;
    }
    /**
     * Set OwnerClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_ApiBarcodeClientTypeInfo $ownerClientTypes
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setOwnerClientTypes(\patest\StructType\RecordSetOfAccessControl_ApiBarcodeClientTypeInfo $ownerClientTypes = null)
    {
        if (is_null($ownerClientTypes) || (is_array($ownerClientTypes) && empty($ownerClientTypes))) {
            unset($this->OwnerClientTypes);
        } else {
            $this->OwnerClientTypes = $ownerClientTypes;
        }
        return $this;
    }
    /**
     * Get OwnerDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerDisplayName()
    {
        return isset($this->OwnerDisplayName) ? $this->OwnerDisplayName : null;
    }
    /**
     * Set OwnerDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerDisplayName
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setOwnerDisplayName($ownerDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerDisplayName) && !is_string($ownerDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerDisplayName, true), gettype($ownerDisplayName)), __LINE__);
        }
        if (is_null($ownerDisplayName) || (is_array($ownerDisplayName) && empty($ownerDisplayName))) {
            unset($this->OwnerDisplayName);
        } else {
            $this->OwnerDisplayName = $ownerDisplayName;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get OwnerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOwnerType()
    {
        return isset($this->OwnerType) ? $this->OwnerType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOwnerType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOwnerType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOwnerTypeForArrayConstraintsFromSetOwnerType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accessControl_ApiBarcodeInfoOwnerTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($accessControl_ApiBarcodeInfoOwnerTypeItem)) {
                $invalidValues[] = is_object($accessControl_ApiBarcodeInfoOwnerTypeItem) ? get_class($accessControl_ApiBarcodeInfoOwnerTypeItem) : sprintf('%s(%s)', gettype($accessControl_ApiBarcodeInfoOwnerTypeItem), var_export($accessControl_ApiBarcodeInfoOwnerTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OwnerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $ownerType
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setOwnerType(array $ownerType = array())
    {
        // validation for constraint: list
        if ('' !== ($ownerTypeArrayErrorMessage = self::validateOwnerTypeForArrayConstraintsFromSetOwnerType($ownerType))) {
            throw new \InvalidArgumentException($ownerTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($ownerType) || (is_array($ownerType) && empty($ownerType))) {
            unset($this->OwnerType);
        } else {
            $this->OwnerType = is_array($ownerType) ? implode(' ', $ownerType) : null;
        }
        return $this;
    }
    /**
     * Get PrevOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrevOwnerId()
    {
        return isset($this->PrevOwnerId) ? $this->PrevOwnerId : null;
    }
    /**
     * Set PrevOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prevOwnerId
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setPrevOwnerId($prevOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($prevOwnerId) && !is_string($prevOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prevOwnerId, true), gettype($prevOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($prevOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $prevOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($prevOwnerId, true)), __LINE__);
        }
        if (is_null($prevOwnerId) || (is_array($prevOwnerId) && empty($prevOwnerId))) {
            unset($this->PrevOwnerId);
        } else {
            $this->PrevOwnerId = $prevOwnerId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PriceTypeGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeGroupId()
    {
        return isset($this->PriceTypeGroupId) ? $this->PriceTypeGroupId : null;
    }
    /**
     * Set PriceTypeGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeGroupId
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setPriceTypeGroupId($priceTypeGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeGroupId) && !is_string($priceTypeGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeGroupId, true), gettype($priceTypeGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeGroupId, true)), __LINE__);
        }
        if (is_null($priceTypeGroupId) || (is_array($priceTypeGroupId) && empty($priceTypeGroupId))) {
            unset($this->PriceTypeGroupId);
        } else {
            $this->PriceTypeGroupId = $priceTypeGroupId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityId()
    {
        return isset($this->ReferencedEntityId) ? $this->ReferencedEntityId : null;
    }
    /**
     * Set ReferencedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityId
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setReferencedEntityId($referencedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityId) && !is_string($referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityId, true), gettype($referencedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referencedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referencedEntityId, true)), __LINE__);
        }
        if (is_null($referencedEntityId) || (is_array($referencedEntityId) && empty($referencedEntityId))) {
            unset($this->ReferencedEntityId);
        } else {
            $this->ReferencedEntityId = $referencedEntityId;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityName()
    {
        return isset($this->ReferencedEntityName) ? $this->ReferencedEntityName : null;
    }
    /**
     * Set ReferencedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityName
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setReferencedEntityName($referencedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityName) && !is_string($referencedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityName, true), gettype($referencedEntityName)), __LINE__);
        }
        if (is_null($referencedEntityName) || (is_array($referencedEntityName) && empty($referencedEntityName))) {
            unset($this->ReferencedEntityName);
        } else {
            $this->ReferencedEntityName = $referencedEntityName;
        }
        return $this;
    }
    /**
     * Get Surname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSurname()
    {
        return isset($this->Surname) ? $this->Surname : null;
    }
    /**
     * Set Surname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $surname
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        if (is_null($surname) || (is_array($surname) && empty($surname))) {
            unset($this->Surname);
        } else {
            $this->Surname = $surname;
        }
        return $this;
    }
    /**
     * Get SyncTimestampUTC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncTimestampUTC()
    {
        return isset($this->SyncTimestampUTC) ? $this->SyncTimestampUTC : null;
    }
    /**
     * Set SyncTimestampUTC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $syncTimestampUTC
     * @return \patest\StructType\AccessControl_ApiBarcodeInfo
     */
    public function setSyncTimestampUTC($syncTimestampUTC = null)
    {
        // validation for constraint: string
        if (!is_null($syncTimestampUTC) && !is_string($syncTimestampUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncTimestampUTC, true), gettype($syncTimestampUTC)), __LINE__);
        }
        if (is_null($syncTimestampUTC) || (is_array($syncTimestampUTC) && empty($syncTimestampUTC))) {
            unset($this->SyncTimestampUTC);
        } else {
            $this->SyncTimestampUTC = $syncTimestampUTC;
        }
        return $this;
    }
}
