<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.AccessControlSystem StructType
 * @subpackage Structs
 */
class AccessControl_AccessControlSystem extends PersistableEntity
{
    /**
     * The ApiUser
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApiUser;
    /**
     * The AuthoritativeSystemWeblinkUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthoritativeSystemWeblinkUrl;
    /**
     * The AutomaticEntitySynchronization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutomaticEntitySynchronization;
    /**
     * The ConnectionTimeoutSeconds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionTimeoutSeconds;
    /**
     * The ConnectionUri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectionUri;
    /**
     * The Counters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_AccessControlSystemCounter
     */
    public $Counters;
    /**
     * The DefaultBarcodeProviderId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultBarcodeProviderId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EnableTraceLog
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableTraceLog;
    /**
     * The ExternalBarcodeProviderIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExternalBarcodeProviderIds
     */
    public $ExternalBarcodeProviderIds;
    /**
     * The HasExternalBarcodeProviders
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasExternalBarcodeProviders;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsExternalScanning
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExternalScanning;
    /**
     * The IsInternal
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInternal;
    /**
     * The IsSecondarySystemOn
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSecondarySystemOn;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NewMembershipCardsIssuingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewMembershipCardsIssuingPolicy;
    /**
     * The NewSubscriptionCardsIssuingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewSubscriptionCardsIssuingPolicy;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Printers
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_Printer
     */
    public $Printers;
    /**
     * The ProviderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderId;
    /**
     * The ProviderSpecificData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderSpecificData;
    /**
     * The RenewedMembershipCardsIssuingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewedMembershipCardsIssuingPolicy;
    /**
     * The RenewedSubscriptionCardsIssuingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewedSubscriptionCardsIssuingPolicy;
    /**
     * The ScanAuthoritativeFirst
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ScanAuthoritativeFirst;
    /**
     * The SecondarySystemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecondarySystemId;
    /**
     * The ShowTimeAllowGenerateBarcodeNfcPassWhen
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowTimeAllowGenerateBarcodeNfcPassWhen;
    /**
     * The ShowtimeLastSyncError
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeLastSyncError;
    /**
     * The ShowtimeLastSyncTime
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeLastSyncTime;
    /**
     * The ShowtimeMigrationAcSystemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowtimeMigrationAcSystemId;
    /**
     * The ShowtimeMigrationStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeMigrationStatus
     * @var string
     */
    public $ShowtimeMigrationStatus;
    /**
     * The ShowtimeMigrationSyncActiveBarcodesMessage
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeMigrationSyncActiveBarcodesMessage;
    /**
     * The ShowtimeMigrationSyncActiveBarcodesStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeMigrationStatus
     * @var string
     */
    public $ShowtimeMigrationSyncActiveBarcodesStatus;
    /**
     * The ShowtimeMigrationSyncActiveBarcodesStatusDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeMigrationSyncActiveBarcodesStatusDate;
    /**
     * The ShowtimeMigrationSyncEventsMessage
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeMigrationSyncEventsMessage;
    /**
     * The ShowtimeMigrationSyncEventsStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeMigrationStatus
     * @var string
     */
    public $ShowtimeMigrationSyncEventsStatus;
    /**
     * The ShowtimeMigrationSyncEventsStatusDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeMigrationSyncEventsStatusDate;
    /**
     * The ShowtimeMigrationSyncVenueMessage
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeMigrationSyncVenueMessage;
    /**
     * The ShowtimeMigrationSyncVenueStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeMigrationStatus
     * @var string
     */
    public $ShowtimeMigrationSyncVenueStatus;
    /**
     * The ShowtimeMigrationSyncVenueStatusDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeMigrationSyncVenueStatusDate;
    /**
     * The ShowTimeSupportNfcPass
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowTimeSupportNfcPass;
    /**
     * The ShowtimeSyncStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowtimeSyncStatus;
    /**
     * The SupportsMobileApp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SupportsMobileApp;
    /**
     * The TimeZone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZone;
    /**
     * The UseAsDefaultForMemberships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAsDefaultForMemberships;
    /**
     * The UseAsDefaultForSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAsDefaultForSeries;
    /**
     * The UseAsDefaultForVenues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAsDefaultForVenues;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for AccessControl.AccessControlSystem
     * @uses AccessControl_AccessControlSystem::setApiUser()
     * @uses AccessControl_AccessControlSystem::setAuthoritativeSystemWeblinkUrl()
     * @uses AccessControl_AccessControlSystem::setAutomaticEntitySynchronization()
     * @uses AccessControl_AccessControlSystem::setConnectionTimeoutSeconds()
     * @uses AccessControl_AccessControlSystem::setConnectionUri()
     * @uses AccessControl_AccessControlSystem::setCounters()
     * @uses AccessControl_AccessControlSystem::setDefaultBarcodeProviderId()
     * @uses AccessControl_AccessControlSystem::setDescription()
     * @uses AccessControl_AccessControlSystem::setEnableTraceLog()
     * @uses AccessControl_AccessControlSystem::setExternalBarcodeProviderIds()
     * @uses AccessControl_AccessControlSystem::setHasExternalBarcodeProviders()
     * @uses AccessControl_AccessControlSystem::setIsActive()
     * @uses AccessControl_AccessControlSystem::setIsExternalScanning()
     * @uses AccessControl_AccessControlSystem::setIsInternal()
     * @uses AccessControl_AccessControlSystem::setIsSecondarySystemOn()
     * @uses AccessControl_AccessControlSystem::setIsSystem()
     * @uses AccessControl_AccessControlSystem::setName()
     * @uses AccessControl_AccessControlSystem::setNewMembershipCardsIssuingPolicy()
     * @uses AccessControl_AccessControlSystem::setNewSubscriptionCardsIssuingPolicy()
     * @uses AccessControl_AccessControlSystem::setOrganizationUnitId()
     * @uses AccessControl_AccessControlSystem::setPrinters()
     * @uses AccessControl_AccessControlSystem::setProviderId()
     * @uses AccessControl_AccessControlSystem::setProviderSpecificData()
     * @uses AccessControl_AccessControlSystem::setRenewedMembershipCardsIssuingPolicy()
     * @uses AccessControl_AccessControlSystem::setRenewedSubscriptionCardsIssuingPolicy()
     * @uses AccessControl_AccessControlSystem::setScanAuthoritativeFirst()
     * @uses AccessControl_AccessControlSystem::setSecondarySystemId()
     * @uses AccessControl_AccessControlSystem::setShowTimeAllowGenerateBarcodeNfcPassWhen()
     * @uses AccessControl_AccessControlSystem::setShowtimeLastSyncError()
     * @uses AccessControl_AccessControlSystem::setShowtimeLastSyncTime()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationAcSystemId()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationStatus()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncActiveBarcodesMessage()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncActiveBarcodesStatus()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncActiveBarcodesStatusDate()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncEventsMessage()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncEventsStatus()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncEventsStatusDate()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncVenueMessage()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncVenueStatus()
     * @uses AccessControl_AccessControlSystem::setShowtimeMigrationSyncVenueStatusDate()
     * @uses AccessControl_AccessControlSystem::setShowTimeSupportNfcPass()
     * @uses AccessControl_AccessControlSystem::setShowtimeSyncStatus()
     * @uses AccessControl_AccessControlSystem::setSupportsMobileApp()
     * @uses AccessControl_AccessControlSystem::setTimeZone()
     * @uses AccessControl_AccessControlSystem::setUseAsDefaultForMemberships()
     * @uses AccessControl_AccessControlSystem::setUseAsDefaultForSeries()
     * @uses AccessControl_AccessControlSystem::setUseAsDefaultForVenues()
     * @uses AccessControl_AccessControlSystem::setVisibleBySubordinates()
     * @param string $apiUser
     * @param string $authoritativeSystemWeblinkUrl
     * @param bool $automaticEntitySynchronization
     * @param int $connectionTimeoutSeconds
     * @param string $connectionUri
     * @param \patest\StructType\RecordSetOfAccessControl_AccessControlSystemCounter $counters
     * @param string $defaultBarcodeProviderId
     * @param \patest\StructType\GlobalString $description
     * @param bool $enableTraceLog
     * @param \patest\StructType\ExternalBarcodeProviderIds $externalBarcodeProviderIds
     * @param bool $hasExternalBarcodeProviders
     * @param bool $isActive
     * @param bool $isExternalScanning
     * @param bool $isInternal
     * @param bool $isSecondarySystemOn
     * @param bool $isSystem
     * @param \patest\StructType\GlobalString $name
     * @param string $newMembershipCardsIssuingPolicy
     * @param string $newSubscriptionCardsIssuingPolicy
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfPrinting_Printer $printers
     * @param string $providerId
     * @param string $providerSpecificData
     * @param string $renewedMembershipCardsIssuingPolicy
     * @param string $renewedSubscriptionCardsIssuingPolicy
     * @param bool $scanAuthoritativeFirst
     * @param string $secondarySystemId
     * @param string $showTimeAllowGenerateBarcodeNfcPassWhen
     * @param string $showtimeLastSyncError
     * @param string $showtimeLastSyncTime
     * @param string $showtimeMigrationAcSystemId
     * @param string $showtimeMigrationStatus
     * @param string $showtimeMigrationSyncActiveBarcodesMessage
     * @param string $showtimeMigrationSyncActiveBarcodesStatus
     * @param string $showtimeMigrationSyncActiveBarcodesStatusDate
     * @param string $showtimeMigrationSyncEventsMessage
     * @param string $showtimeMigrationSyncEventsStatus
     * @param string $showtimeMigrationSyncEventsStatusDate
     * @param string $showtimeMigrationSyncVenueMessage
     * @param string $showtimeMigrationSyncVenueStatus
     * @param string $showtimeMigrationSyncVenueStatusDate
     * @param bool $showTimeSupportNfcPass
     * @param string $showtimeSyncStatus
     * @param bool $supportsMobileApp
     * @param string $timeZone
     * @param bool $useAsDefaultForMemberships
     * @param bool $useAsDefaultForSeries
     * @param bool $useAsDefaultForVenues
     * @param bool $visibleBySubordinates
     */
    public function __construct($apiUser = null, $authoritativeSystemWeblinkUrl = null, $automaticEntitySynchronization = null, $connectionTimeoutSeconds = null, $connectionUri = null, \patest\StructType\RecordSetOfAccessControl_AccessControlSystemCounter $counters = null, $defaultBarcodeProviderId = null, \patest\StructType\GlobalString $description = null, $enableTraceLog = null, \patest\StructType\ExternalBarcodeProviderIds $externalBarcodeProviderIds = null, $hasExternalBarcodeProviders = null, $isActive = null, $isExternalScanning = null, $isInternal = null, $isSecondarySystemOn = null, $isSystem = null, \patest\StructType\GlobalString $name = null, $newMembershipCardsIssuingPolicy = null, $newSubscriptionCardsIssuingPolicy = null, $organizationUnitId = null, \patest\StructType\RecordSetOfPrinting_Printer $printers = null, $providerId = null, $providerSpecificData = null, $renewedMembershipCardsIssuingPolicy = null, $renewedSubscriptionCardsIssuingPolicy = null, $scanAuthoritativeFirst = null, $secondarySystemId = null, $showTimeAllowGenerateBarcodeNfcPassWhen = null, $showtimeLastSyncError = null, $showtimeLastSyncTime = null, $showtimeMigrationAcSystemId = null, $showtimeMigrationStatus = null, $showtimeMigrationSyncActiveBarcodesMessage = null, $showtimeMigrationSyncActiveBarcodesStatus = null, $showtimeMigrationSyncActiveBarcodesStatusDate = null, $showtimeMigrationSyncEventsMessage = null, $showtimeMigrationSyncEventsStatus = null, $showtimeMigrationSyncEventsStatusDate = null, $showtimeMigrationSyncVenueMessage = null, $showtimeMigrationSyncVenueStatus = null, $showtimeMigrationSyncVenueStatusDate = null, $showTimeSupportNfcPass = null, $showtimeSyncStatus = null, $supportsMobileApp = null, $timeZone = null, $useAsDefaultForMemberships = null, $useAsDefaultForSeries = null, $useAsDefaultForVenues = null, $visibleBySubordinates = null)
    {
        $this
            ->setApiUser($apiUser)
            ->setAuthoritativeSystemWeblinkUrl($authoritativeSystemWeblinkUrl)
            ->setAutomaticEntitySynchronization($automaticEntitySynchronization)
            ->setConnectionTimeoutSeconds($connectionTimeoutSeconds)
            ->setConnectionUri($connectionUri)
            ->setCounters($counters)
            ->setDefaultBarcodeProviderId($defaultBarcodeProviderId)
            ->setDescription($description)
            ->setEnableTraceLog($enableTraceLog)
            ->setExternalBarcodeProviderIds($externalBarcodeProviderIds)
            ->setHasExternalBarcodeProviders($hasExternalBarcodeProviders)
            ->setIsActive($isActive)
            ->setIsExternalScanning($isExternalScanning)
            ->setIsInternal($isInternal)
            ->setIsSecondarySystemOn($isSecondarySystemOn)
            ->setIsSystem($isSystem)
            ->setName($name)
            ->setNewMembershipCardsIssuingPolicy($newMembershipCardsIssuingPolicy)
            ->setNewSubscriptionCardsIssuingPolicy($newSubscriptionCardsIssuingPolicy)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrinters($printers)
            ->setProviderId($providerId)
            ->setProviderSpecificData($providerSpecificData)
            ->setRenewedMembershipCardsIssuingPolicy($renewedMembershipCardsIssuingPolicy)
            ->setRenewedSubscriptionCardsIssuingPolicy($renewedSubscriptionCardsIssuingPolicy)
            ->setScanAuthoritativeFirst($scanAuthoritativeFirst)
            ->setSecondarySystemId($secondarySystemId)
            ->setShowTimeAllowGenerateBarcodeNfcPassWhen($showTimeAllowGenerateBarcodeNfcPassWhen)
            ->setShowtimeLastSyncError($showtimeLastSyncError)
            ->setShowtimeLastSyncTime($showtimeLastSyncTime)
            ->setShowtimeMigrationAcSystemId($showtimeMigrationAcSystemId)
            ->setShowtimeMigrationStatus($showtimeMigrationStatus)
            ->setShowtimeMigrationSyncActiveBarcodesMessage($showtimeMigrationSyncActiveBarcodesMessage)
            ->setShowtimeMigrationSyncActiveBarcodesStatus($showtimeMigrationSyncActiveBarcodesStatus)
            ->setShowtimeMigrationSyncActiveBarcodesStatusDate($showtimeMigrationSyncActiveBarcodesStatusDate)
            ->setShowtimeMigrationSyncEventsMessage($showtimeMigrationSyncEventsMessage)
            ->setShowtimeMigrationSyncEventsStatus($showtimeMigrationSyncEventsStatus)
            ->setShowtimeMigrationSyncEventsStatusDate($showtimeMigrationSyncEventsStatusDate)
            ->setShowtimeMigrationSyncVenueMessage($showtimeMigrationSyncVenueMessage)
            ->setShowtimeMigrationSyncVenueStatus($showtimeMigrationSyncVenueStatus)
            ->setShowtimeMigrationSyncVenueStatusDate($showtimeMigrationSyncVenueStatusDate)
            ->setShowTimeSupportNfcPass($showTimeSupportNfcPass)
            ->setShowtimeSyncStatus($showtimeSyncStatus)
            ->setSupportsMobileApp($supportsMobileApp)
            ->setTimeZone($timeZone)
            ->setUseAsDefaultForMemberships($useAsDefaultForMemberships)
            ->setUseAsDefaultForSeries($useAsDefaultForSeries)
            ->setUseAsDefaultForVenues($useAsDefaultForVenues)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get ApiUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiUser()
    {
        return isset($this->ApiUser) ? $this->ApiUser : null;
    }
    /**
     * Set ApiUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiUser
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setApiUser($apiUser = null)
    {
        // validation for constraint: string
        if (!is_null($apiUser) && !is_string($apiUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiUser, true), gettype($apiUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($apiUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $apiUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($apiUser, true)), __LINE__);
        }
        if (is_null($apiUser) || (is_array($apiUser) && empty($apiUser))) {
            unset($this->ApiUser);
        } else {
            $this->ApiUser = $apiUser;
        }
        return $this;
    }
    /**
     * Get AuthoritativeSystemWeblinkUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthoritativeSystemWeblinkUrl()
    {
        return isset($this->AuthoritativeSystemWeblinkUrl) ? $this->AuthoritativeSystemWeblinkUrl : null;
    }
    /**
     * Set AuthoritativeSystemWeblinkUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authoritativeSystemWeblinkUrl
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setAuthoritativeSystemWeblinkUrl($authoritativeSystemWeblinkUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authoritativeSystemWeblinkUrl) && !is_string($authoritativeSystemWeblinkUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authoritativeSystemWeblinkUrl, true), gettype($authoritativeSystemWeblinkUrl)), __LINE__);
        }
        if (is_null($authoritativeSystemWeblinkUrl) || (is_array($authoritativeSystemWeblinkUrl) && empty($authoritativeSystemWeblinkUrl))) {
            unset($this->AuthoritativeSystemWeblinkUrl);
        } else {
            $this->AuthoritativeSystemWeblinkUrl = $authoritativeSystemWeblinkUrl;
        }
        return $this;
    }
    /**
     * Get AutomaticEntitySynchronization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutomaticEntitySynchronization()
    {
        return isset($this->AutomaticEntitySynchronization) ? $this->AutomaticEntitySynchronization : null;
    }
    /**
     * Set AutomaticEntitySynchronization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $automaticEntitySynchronization
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setAutomaticEntitySynchronization($automaticEntitySynchronization = null)
    {
        // validation for constraint: boolean
        if (!is_null($automaticEntitySynchronization) && !is_bool($automaticEntitySynchronization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automaticEntitySynchronization, true), gettype($automaticEntitySynchronization)), __LINE__);
        }
        if (is_null($automaticEntitySynchronization) || (is_array($automaticEntitySynchronization) && empty($automaticEntitySynchronization))) {
            unset($this->AutomaticEntitySynchronization);
        } else {
            $this->AutomaticEntitySynchronization = $automaticEntitySynchronization;
        }
        return $this;
    }
    /**
     * Get ConnectionTimeoutSeconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionTimeoutSeconds()
    {
        return isset($this->ConnectionTimeoutSeconds) ? $this->ConnectionTimeoutSeconds : null;
    }
    /**
     * Set ConnectionTimeoutSeconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionTimeoutSeconds
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setConnectionTimeoutSeconds($connectionTimeoutSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($connectionTimeoutSeconds) && !(is_int($connectionTimeoutSeconds) || ctype_digit($connectionTimeoutSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionTimeoutSeconds, true), gettype($connectionTimeoutSeconds)), __LINE__);
        }
        if (is_null($connectionTimeoutSeconds) || (is_array($connectionTimeoutSeconds) && empty($connectionTimeoutSeconds))) {
            unset($this->ConnectionTimeoutSeconds);
        } else {
            $this->ConnectionTimeoutSeconds = $connectionTimeoutSeconds;
        }
        return $this;
    }
    /**
     * Get ConnectionUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectionUri()
    {
        return isset($this->ConnectionUri) ? $this->ConnectionUri : null;
    }
    /**
     * Set ConnectionUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectionUri
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setConnectionUri($connectionUri = null)
    {
        // validation for constraint: string
        if (!is_null($connectionUri) && !is_string($connectionUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionUri, true), gettype($connectionUri)), __LINE__);
        }
        if (is_null($connectionUri) || (is_array($connectionUri) && empty($connectionUri))) {
            unset($this->ConnectionUri);
        } else {
            $this->ConnectionUri = $connectionUri;
        }
        return $this;
    }
    /**
     * Get Counters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_AccessControlSystemCounter|null
     */
    public function getCounters()
    {
        return isset($this->Counters) ? $this->Counters : null;
    }
    /**
     * Set Counters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_AccessControlSystemCounter $counters
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setCounters(\patest\StructType\RecordSetOfAccessControl_AccessControlSystemCounter $counters = null)
    {
        if (is_null($counters) || (is_array($counters) && empty($counters))) {
            unset($this->Counters);
        } else {
            $this->Counters = $counters;
        }
        return $this;
    }
    /**
     * Get DefaultBarcodeProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultBarcodeProviderId()
    {
        return isset($this->DefaultBarcodeProviderId) ? $this->DefaultBarcodeProviderId : null;
    }
    /**
     * Set DefaultBarcodeProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultBarcodeProviderId
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setDefaultBarcodeProviderId($defaultBarcodeProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultBarcodeProviderId) && !is_string($defaultBarcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultBarcodeProviderId, true), gettype($defaultBarcodeProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultBarcodeProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultBarcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultBarcodeProviderId, true)), __LINE__);
        }
        if (is_null($defaultBarcodeProviderId) || (is_array($defaultBarcodeProviderId) && empty($defaultBarcodeProviderId))) {
            unset($this->DefaultBarcodeProviderId);
        } else {
            $this->DefaultBarcodeProviderId = $defaultBarcodeProviderId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EnableTraceLog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableTraceLog()
    {
        return isset($this->EnableTraceLog) ? $this->EnableTraceLog : null;
    }
    /**
     * Set EnableTraceLog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableTraceLog
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setEnableTraceLog($enableTraceLog = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableTraceLog) && !is_bool($enableTraceLog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableTraceLog, true), gettype($enableTraceLog)), __LINE__);
        }
        if (is_null($enableTraceLog) || (is_array($enableTraceLog) && empty($enableTraceLog))) {
            unset($this->EnableTraceLog);
        } else {
            $this->EnableTraceLog = $enableTraceLog;
        }
        return $this;
    }
    /**
     * Get ExternalBarcodeProviderIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExternalBarcodeProviderIds|null
     */
    public function getExternalBarcodeProviderIds()
    {
        return isset($this->ExternalBarcodeProviderIds) ? $this->ExternalBarcodeProviderIds : null;
    }
    /**
     * Set ExternalBarcodeProviderIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExternalBarcodeProviderIds $externalBarcodeProviderIds
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setExternalBarcodeProviderIds(\patest\StructType\ExternalBarcodeProviderIds $externalBarcodeProviderIds = null)
    {
        if (is_null($externalBarcodeProviderIds) || (is_array($externalBarcodeProviderIds) && empty($externalBarcodeProviderIds))) {
            unset($this->ExternalBarcodeProviderIds);
        } else {
            $this->ExternalBarcodeProviderIds = $externalBarcodeProviderIds;
        }
        return $this;
    }
    /**
     * Get HasExternalBarcodeProviders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasExternalBarcodeProviders()
    {
        return isset($this->HasExternalBarcodeProviders) ? $this->HasExternalBarcodeProviders : null;
    }
    /**
     * Set HasExternalBarcodeProviders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasExternalBarcodeProviders
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setHasExternalBarcodeProviders($hasExternalBarcodeProviders = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasExternalBarcodeProviders) && !is_bool($hasExternalBarcodeProviders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasExternalBarcodeProviders, true), gettype($hasExternalBarcodeProviders)), __LINE__);
        }
        if (is_null($hasExternalBarcodeProviders) || (is_array($hasExternalBarcodeProviders) && empty($hasExternalBarcodeProviders))) {
            unset($this->HasExternalBarcodeProviders);
        } else {
            $this->HasExternalBarcodeProviders = $hasExternalBarcodeProviders;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsExternalScanning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExternalScanning()
    {
        return isset($this->IsExternalScanning) ? $this->IsExternalScanning : null;
    }
    /**
     * Set IsExternalScanning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExternalScanning
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setIsExternalScanning($isExternalScanning = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExternalScanning) && !is_bool($isExternalScanning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExternalScanning, true), gettype($isExternalScanning)), __LINE__);
        }
        if (is_null($isExternalScanning) || (is_array($isExternalScanning) && empty($isExternalScanning))) {
            unset($this->IsExternalScanning);
        } else {
            $this->IsExternalScanning = $isExternalScanning;
        }
        return $this;
    }
    /**
     * Get IsInternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInternal()
    {
        return isset($this->IsInternal) ? $this->IsInternal : null;
    }
    /**
     * Set IsInternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInternal
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setIsInternal($isInternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternal) && !is_bool($isInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternal, true), gettype($isInternal)), __LINE__);
        }
        if (is_null($isInternal) || (is_array($isInternal) && empty($isInternal))) {
            unset($this->IsInternal);
        } else {
            $this->IsInternal = $isInternal;
        }
        return $this;
    }
    /**
     * Get IsSecondarySystemOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSecondarySystemOn()
    {
        return isset($this->IsSecondarySystemOn) ? $this->IsSecondarySystemOn : null;
    }
    /**
     * Set IsSecondarySystemOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSecondarySystemOn
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setIsSecondarySystemOn($isSecondarySystemOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSecondarySystemOn) && !is_bool($isSecondarySystemOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSecondarySystemOn, true), gettype($isSecondarySystemOn)), __LINE__);
        }
        if (is_null($isSecondarySystemOn) || (is_array($isSecondarySystemOn) && empty($isSecondarySystemOn))) {
            unset($this->IsSecondarySystemOn);
        } else {
            $this->IsSecondarySystemOn = $isSecondarySystemOn;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NewMembershipCardsIssuingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewMembershipCardsIssuingPolicy()
    {
        return isset($this->NewMembershipCardsIssuingPolicy) ? $this->NewMembershipCardsIssuingPolicy : null;
    }
    /**
     * Set NewMembershipCardsIssuingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\NewCardIssuingPolicy::valueIsValid()
     * @uses \patest\EnumType\NewCardIssuingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newMembershipCardsIssuingPolicy
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setNewMembershipCardsIssuingPolicy($newMembershipCardsIssuingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\NewCardIssuingPolicy::valueIsValid($newMembershipCardsIssuingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\NewCardIssuingPolicy', is_array($newMembershipCardsIssuingPolicy) ? implode(', ', $newMembershipCardsIssuingPolicy) : var_export($newMembershipCardsIssuingPolicy, true), implode(', ', \patest\EnumType\NewCardIssuingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($newMembershipCardsIssuingPolicy) || (is_array($newMembershipCardsIssuingPolicy) && empty($newMembershipCardsIssuingPolicy))) {
            unset($this->NewMembershipCardsIssuingPolicy);
        } else {
            $this->NewMembershipCardsIssuingPolicy = $newMembershipCardsIssuingPolicy;
        }
        return $this;
    }
    /**
     * Get NewSubscriptionCardsIssuingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSubscriptionCardsIssuingPolicy()
    {
        return isset($this->NewSubscriptionCardsIssuingPolicy) ? $this->NewSubscriptionCardsIssuingPolicy : null;
    }
    /**
     * Set NewSubscriptionCardsIssuingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\NewCardIssuingPolicy::valueIsValid()
     * @uses \patest\EnumType\NewCardIssuingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newSubscriptionCardsIssuingPolicy
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setNewSubscriptionCardsIssuingPolicy($newSubscriptionCardsIssuingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\NewCardIssuingPolicy::valueIsValid($newSubscriptionCardsIssuingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\NewCardIssuingPolicy', is_array($newSubscriptionCardsIssuingPolicy) ? implode(', ', $newSubscriptionCardsIssuingPolicy) : var_export($newSubscriptionCardsIssuingPolicy, true), implode(', ', \patest\EnumType\NewCardIssuingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($newSubscriptionCardsIssuingPolicy) || (is_array($newSubscriptionCardsIssuingPolicy) && empty($newSubscriptionCardsIssuingPolicy))) {
            unset($this->NewSubscriptionCardsIssuingPolicy);
        } else {
            $this->NewSubscriptionCardsIssuingPolicy = $newSubscriptionCardsIssuingPolicy;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Printers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_Printer|null
     */
    public function getPrinters()
    {
        return isset($this->Printers) ? $this->Printers : null;
    }
    /**
     * Set Printers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_Printer $printers
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setPrinters(\patest\StructType\RecordSetOfPrinting_Printer $printers = null)
    {
        if (is_null($printers) || (is_array($printers) && empty($printers))) {
            unset($this->Printers);
        } else {
            $this->Printers = $printers;
        }
        return $this;
    }
    /**
     * Get ProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderId()
    {
        return isset($this->ProviderId) ? $this->ProviderId : null;
    }
    /**
     * Set ProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerId
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: string
        if (!is_null($providerId) && !is_string($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerId, true), gettype($providerId)), __LINE__);
        }
        if (is_null($providerId) || (is_array($providerId) && empty($providerId))) {
            unset($this->ProviderId);
        } else {
            $this->ProviderId = $providerId;
        }
        return $this;
    }
    /**
     * Get ProviderSpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSpecificData()
    {
        return isset($this->ProviderSpecificData) ? $this->ProviderSpecificData : null;
    }
    /**
     * Set ProviderSpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSpecificData
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setProviderSpecificData($providerSpecificData = null)
    {
        // validation for constraint: string
        if (!is_null($providerSpecificData) && !is_string($providerSpecificData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSpecificData, true), gettype($providerSpecificData)), __LINE__);
        }
        if (is_null($providerSpecificData) || (is_array($providerSpecificData) && empty($providerSpecificData))) {
            unset($this->ProviderSpecificData);
        } else {
            $this->ProviderSpecificData = $providerSpecificData;
        }
        return $this;
    }
    /**
     * Get RenewedMembershipCardsIssuingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedMembershipCardsIssuingPolicy()
    {
        return isset($this->RenewedMembershipCardsIssuingPolicy) ? $this->RenewedMembershipCardsIssuingPolicy : null;
    }
    /**
     * Set RenewedMembershipCardsIssuingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\NewCardIssuingPolicy::valueIsValid()
     * @uses \patest\EnumType\NewCardIssuingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewedMembershipCardsIssuingPolicy
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setRenewedMembershipCardsIssuingPolicy($renewedMembershipCardsIssuingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\NewCardIssuingPolicy::valueIsValid($renewedMembershipCardsIssuingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\NewCardIssuingPolicy', is_array($renewedMembershipCardsIssuingPolicy) ? implode(', ', $renewedMembershipCardsIssuingPolicy) : var_export($renewedMembershipCardsIssuingPolicy, true), implode(', ', \patest\EnumType\NewCardIssuingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($renewedMembershipCardsIssuingPolicy) || (is_array($renewedMembershipCardsIssuingPolicy) && empty($renewedMembershipCardsIssuingPolicy))) {
            unset($this->RenewedMembershipCardsIssuingPolicy);
        } else {
            $this->RenewedMembershipCardsIssuingPolicy = $renewedMembershipCardsIssuingPolicy;
        }
        return $this;
    }
    /**
     * Get RenewedSubscriptionCardsIssuingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedSubscriptionCardsIssuingPolicy()
    {
        return isset($this->RenewedSubscriptionCardsIssuingPolicy) ? $this->RenewedSubscriptionCardsIssuingPolicy : null;
    }
    /**
     * Set RenewedSubscriptionCardsIssuingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\NewCardIssuingPolicy::valueIsValid()
     * @uses \patest\EnumType\NewCardIssuingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewedSubscriptionCardsIssuingPolicy
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setRenewedSubscriptionCardsIssuingPolicy($renewedSubscriptionCardsIssuingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\NewCardIssuingPolicy::valueIsValid($renewedSubscriptionCardsIssuingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\NewCardIssuingPolicy', is_array($renewedSubscriptionCardsIssuingPolicy) ? implode(', ', $renewedSubscriptionCardsIssuingPolicy) : var_export($renewedSubscriptionCardsIssuingPolicy, true), implode(', ', \patest\EnumType\NewCardIssuingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($renewedSubscriptionCardsIssuingPolicy) || (is_array($renewedSubscriptionCardsIssuingPolicy) && empty($renewedSubscriptionCardsIssuingPolicy))) {
            unset($this->RenewedSubscriptionCardsIssuingPolicy);
        } else {
            $this->RenewedSubscriptionCardsIssuingPolicy = $renewedSubscriptionCardsIssuingPolicy;
        }
        return $this;
    }
    /**
     * Get ScanAuthoritativeFirst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getScanAuthoritativeFirst()
    {
        return isset($this->ScanAuthoritativeFirst) ? $this->ScanAuthoritativeFirst : null;
    }
    /**
     * Set ScanAuthoritativeFirst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $scanAuthoritativeFirst
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setScanAuthoritativeFirst($scanAuthoritativeFirst = null)
    {
        // validation for constraint: boolean
        if (!is_null($scanAuthoritativeFirst) && !is_bool($scanAuthoritativeFirst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scanAuthoritativeFirst, true), gettype($scanAuthoritativeFirst)), __LINE__);
        }
        if (is_null($scanAuthoritativeFirst) || (is_array($scanAuthoritativeFirst) && empty($scanAuthoritativeFirst))) {
            unset($this->ScanAuthoritativeFirst);
        } else {
            $this->ScanAuthoritativeFirst = $scanAuthoritativeFirst;
        }
        return $this;
    }
    /**
     * Get SecondarySystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondarySystemId()
    {
        return isset($this->SecondarySystemId) ? $this->SecondarySystemId : null;
    }
    /**
     * Set SecondarySystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondarySystemId
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setSecondarySystemId($secondarySystemId = null)
    {
        // validation for constraint: string
        if (!is_null($secondarySystemId) && !is_string($secondarySystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondarySystemId, true), gettype($secondarySystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($secondarySystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $secondarySystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($secondarySystemId, true)), __LINE__);
        }
        if (is_null($secondarySystemId) || (is_array($secondarySystemId) && empty($secondarySystemId))) {
            unset($this->SecondarySystemId);
        } else {
            $this->SecondarySystemId = $secondarySystemId;
        }
        return $this;
    }
    /**
     * Get ShowTimeAllowGenerateBarcodeNfcPassWhen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTimeAllowGenerateBarcodeNfcPassWhen()
    {
        return isset($this->ShowTimeAllowGenerateBarcodeNfcPassWhen) ? $this->ShowTimeAllowGenerateBarcodeNfcPassWhen : null;
    }
    /**
     * Set ShowTimeAllowGenerateBarcodeNfcPassWhen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ShowTimeAllowNfcPassGenerateOption::valueIsValid()
     * @uses \patest\EnumType\ShowTimeAllowNfcPassGenerateOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $showTimeAllowGenerateBarcodeNfcPassWhen
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowTimeAllowGenerateBarcodeNfcPassWhen($showTimeAllowGenerateBarcodeNfcPassWhen = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ShowTimeAllowNfcPassGenerateOption::valueIsValid($showTimeAllowGenerateBarcodeNfcPassWhen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ShowTimeAllowNfcPassGenerateOption', is_array($showTimeAllowGenerateBarcodeNfcPassWhen) ? implode(', ', $showTimeAllowGenerateBarcodeNfcPassWhen) : var_export($showTimeAllowGenerateBarcodeNfcPassWhen, true), implode(', ', \patest\EnumType\ShowTimeAllowNfcPassGenerateOption::getValidValues())), __LINE__);
        }
        if (is_null($showTimeAllowGenerateBarcodeNfcPassWhen) || (is_array($showTimeAllowGenerateBarcodeNfcPassWhen) && empty($showTimeAllowGenerateBarcodeNfcPassWhen))) {
            unset($this->ShowTimeAllowGenerateBarcodeNfcPassWhen);
        } else {
            $this->ShowTimeAllowGenerateBarcodeNfcPassWhen = $showTimeAllowGenerateBarcodeNfcPassWhen;
        }
        return $this;
    }
    /**
     * Get ShowtimeLastSyncError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeLastSyncError()
    {
        return isset($this->ShowtimeLastSyncError) ? $this->ShowtimeLastSyncError : null;
    }
    /**
     * Set ShowtimeLastSyncError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeLastSyncError
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeLastSyncError($showtimeLastSyncError = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeLastSyncError) && !is_string($showtimeLastSyncError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeLastSyncError, true), gettype($showtimeLastSyncError)), __LINE__);
        }
        if (is_null($showtimeLastSyncError) || (is_array($showtimeLastSyncError) && empty($showtimeLastSyncError))) {
            unset($this->ShowtimeLastSyncError);
        } else {
            $this->ShowtimeLastSyncError = $showtimeLastSyncError;
        }
        return $this;
    }
    /**
     * Get ShowtimeLastSyncTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeLastSyncTime()
    {
        return isset($this->ShowtimeLastSyncTime) ? $this->ShowtimeLastSyncTime : null;
    }
    /**
     * Set ShowtimeLastSyncTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeLastSyncTime
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeLastSyncTime($showtimeLastSyncTime = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeLastSyncTime) && !is_string($showtimeLastSyncTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeLastSyncTime, true), gettype($showtimeLastSyncTime)), __LINE__);
        }
        if (is_null($showtimeLastSyncTime) || (is_array($showtimeLastSyncTime) && empty($showtimeLastSyncTime))) {
            unset($this->ShowtimeLastSyncTime);
        } else {
            $this->ShowtimeLastSyncTime = $showtimeLastSyncTime;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationAcSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationAcSystemId()
    {
        return isset($this->ShowtimeMigrationAcSystemId) ? $this->ShowtimeMigrationAcSystemId : null;
    }
    /**
     * Set ShowtimeMigrationAcSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationAcSystemId
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationAcSystemId($showtimeMigrationAcSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationAcSystemId) && !is_string($showtimeMigrationAcSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationAcSystemId, true), gettype($showtimeMigrationAcSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showtimeMigrationAcSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showtimeMigrationAcSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showtimeMigrationAcSystemId, true)), __LINE__);
        }
        if (is_null($showtimeMigrationAcSystemId) || (is_array($showtimeMigrationAcSystemId) && empty($showtimeMigrationAcSystemId))) {
            unset($this->ShowtimeMigrationAcSystemId);
        } else {
            $this->ShowtimeMigrationAcSystemId = $showtimeMigrationAcSystemId;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationStatus()
    {
        return isset($this->ShowtimeMigrationStatus) ? $this->ShowtimeMigrationStatus : null;
    }
    /**
     * Set ShowtimeMigrationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationStatus
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationStatus($showtimeMigrationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationStatus) && !is_string($showtimeMigrationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationStatus, true), gettype($showtimeMigrationStatus)), __LINE__);
        }
        if (is_null($showtimeMigrationStatus) || (is_array($showtimeMigrationStatus) && empty($showtimeMigrationStatus))) {
            unset($this->ShowtimeMigrationStatus);
        } else {
            $this->ShowtimeMigrationStatus = $showtimeMigrationStatus;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncActiveBarcodesMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncActiveBarcodesMessage()
    {
        return isset($this->ShowtimeMigrationSyncActiveBarcodesMessage) ? $this->ShowtimeMigrationSyncActiveBarcodesMessage : null;
    }
    /**
     * Set ShowtimeMigrationSyncActiveBarcodesMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncActiveBarcodesMessage
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncActiveBarcodesMessage($showtimeMigrationSyncActiveBarcodesMessage = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncActiveBarcodesMessage) && !is_string($showtimeMigrationSyncActiveBarcodesMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncActiveBarcodesMessage, true), gettype($showtimeMigrationSyncActiveBarcodesMessage)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncActiveBarcodesMessage) || (is_array($showtimeMigrationSyncActiveBarcodesMessage) && empty($showtimeMigrationSyncActiveBarcodesMessage))) {
            unset($this->ShowtimeMigrationSyncActiveBarcodesMessage);
        } else {
            $this->ShowtimeMigrationSyncActiveBarcodesMessage = $showtimeMigrationSyncActiveBarcodesMessage;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncActiveBarcodesStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncActiveBarcodesStatus()
    {
        return isset($this->ShowtimeMigrationSyncActiveBarcodesStatus) ? $this->ShowtimeMigrationSyncActiveBarcodesStatus : null;
    }
    /**
     * Set ShowtimeMigrationSyncActiveBarcodesStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncActiveBarcodesStatus
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncActiveBarcodesStatus($showtimeMigrationSyncActiveBarcodesStatus = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncActiveBarcodesStatus) && !is_string($showtimeMigrationSyncActiveBarcodesStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncActiveBarcodesStatus, true), gettype($showtimeMigrationSyncActiveBarcodesStatus)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncActiveBarcodesStatus) || (is_array($showtimeMigrationSyncActiveBarcodesStatus) && empty($showtimeMigrationSyncActiveBarcodesStatus))) {
            unset($this->ShowtimeMigrationSyncActiveBarcodesStatus);
        } else {
            $this->ShowtimeMigrationSyncActiveBarcodesStatus = $showtimeMigrationSyncActiveBarcodesStatus;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncActiveBarcodesStatusDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncActiveBarcodesStatusDate()
    {
        return isset($this->ShowtimeMigrationSyncActiveBarcodesStatusDate) ? $this->ShowtimeMigrationSyncActiveBarcodesStatusDate : null;
    }
    /**
     * Set ShowtimeMigrationSyncActiveBarcodesStatusDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncActiveBarcodesStatusDate
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncActiveBarcodesStatusDate($showtimeMigrationSyncActiveBarcodesStatusDate = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncActiveBarcodesStatusDate) && !is_string($showtimeMigrationSyncActiveBarcodesStatusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncActiveBarcodesStatusDate, true), gettype($showtimeMigrationSyncActiveBarcodesStatusDate)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncActiveBarcodesStatusDate) || (is_array($showtimeMigrationSyncActiveBarcodesStatusDate) && empty($showtimeMigrationSyncActiveBarcodesStatusDate))) {
            unset($this->ShowtimeMigrationSyncActiveBarcodesStatusDate);
        } else {
            $this->ShowtimeMigrationSyncActiveBarcodesStatusDate = $showtimeMigrationSyncActiveBarcodesStatusDate;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncEventsMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncEventsMessage()
    {
        return isset($this->ShowtimeMigrationSyncEventsMessage) ? $this->ShowtimeMigrationSyncEventsMessage : null;
    }
    /**
     * Set ShowtimeMigrationSyncEventsMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncEventsMessage
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncEventsMessage($showtimeMigrationSyncEventsMessage = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncEventsMessage) && !is_string($showtimeMigrationSyncEventsMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncEventsMessage, true), gettype($showtimeMigrationSyncEventsMessage)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncEventsMessage) || (is_array($showtimeMigrationSyncEventsMessage) && empty($showtimeMigrationSyncEventsMessage))) {
            unset($this->ShowtimeMigrationSyncEventsMessage);
        } else {
            $this->ShowtimeMigrationSyncEventsMessage = $showtimeMigrationSyncEventsMessage;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncEventsStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncEventsStatus()
    {
        return isset($this->ShowtimeMigrationSyncEventsStatus) ? $this->ShowtimeMigrationSyncEventsStatus : null;
    }
    /**
     * Set ShowtimeMigrationSyncEventsStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncEventsStatus
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncEventsStatus($showtimeMigrationSyncEventsStatus = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncEventsStatus) && !is_string($showtimeMigrationSyncEventsStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncEventsStatus, true), gettype($showtimeMigrationSyncEventsStatus)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncEventsStatus) || (is_array($showtimeMigrationSyncEventsStatus) && empty($showtimeMigrationSyncEventsStatus))) {
            unset($this->ShowtimeMigrationSyncEventsStatus);
        } else {
            $this->ShowtimeMigrationSyncEventsStatus = $showtimeMigrationSyncEventsStatus;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncEventsStatusDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncEventsStatusDate()
    {
        return isset($this->ShowtimeMigrationSyncEventsStatusDate) ? $this->ShowtimeMigrationSyncEventsStatusDate : null;
    }
    /**
     * Set ShowtimeMigrationSyncEventsStatusDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncEventsStatusDate
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncEventsStatusDate($showtimeMigrationSyncEventsStatusDate = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncEventsStatusDate) && !is_string($showtimeMigrationSyncEventsStatusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncEventsStatusDate, true), gettype($showtimeMigrationSyncEventsStatusDate)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncEventsStatusDate) || (is_array($showtimeMigrationSyncEventsStatusDate) && empty($showtimeMigrationSyncEventsStatusDate))) {
            unset($this->ShowtimeMigrationSyncEventsStatusDate);
        } else {
            $this->ShowtimeMigrationSyncEventsStatusDate = $showtimeMigrationSyncEventsStatusDate;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncVenueMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncVenueMessage()
    {
        return isset($this->ShowtimeMigrationSyncVenueMessage) ? $this->ShowtimeMigrationSyncVenueMessage : null;
    }
    /**
     * Set ShowtimeMigrationSyncVenueMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncVenueMessage
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncVenueMessage($showtimeMigrationSyncVenueMessage = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncVenueMessage) && !is_string($showtimeMigrationSyncVenueMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncVenueMessage, true), gettype($showtimeMigrationSyncVenueMessage)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncVenueMessage) || (is_array($showtimeMigrationSyncVenueMessage) && empty($showtimeMigrationSyncVenueMessage))) {
            unset($this->ShowtimeMigrationSyncVenueMessage);
        } else {
            $this->ShowtimeMigrationSyncVenueMessage = $showtimeMigrationSyncVenueMessage;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncVenueStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncVenueStatus()
    {
        return isset($this->ShowtimeMigrationSyncVenueStatus) ? $this->ShowtimeMigrationSyncVenueStatus : null;
    }
    /**
     * Set ShowtimeMigrationSyncVenueStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncVenueStatus
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncVenueStatus($showtimeMigrationSyncVenueStatus = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncVenueStatus) && !is_string($showtimeMigrationSyncVenueStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncVenueStatus, true), gettype($showtimeMigrationSyncVenueStatus)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncVenueStatus) || (is_array($showtimeMigrationSyncVenueStatus) && empty($showtimeMigrationSyncVenueStatus))) {
            unset($this->ShowtimeMigrationSyncVenueStatus);
        } else {
            $this->ShowtimeMigrationSyncVenueStatus = $showtimeMigrationSyncVenueStatus;
        }
        return $this;
    }
    /**
     * Get ShowtimeMigrationSyncVenueStatusDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeMigrationSyncVenueStatusDate()
    {
        return isset($this->ShowtimeMigrationSyncVenueStatusDate) ? $this->ShowtimeMigrationSyncVenueStatusDate : null;
    }
    /**
     * Set ShowtimeMigrationSyncVenueStatusDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showtimeMigrationSyncVenueStatusDate
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeMigrationSyncVenueStatusDate($showtimeMigrationSyncVenueStatusDate = null)
    {
        // validation for constraint: string
        if (!is_null($showtimeMigrationSyncVenueStatusDate) && !is_string($showtimeMigrationSyncVenueStatusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showtimeMigrationSyncVenueStatusDate, true), gettype($showtimeMigrationSyncVenueStatusDate)), __LINE__);
        }
        if (is_null($showtimeMigrationSyncVenueStatusDate) || (is_array($showtimeMigrationSyncVenueStatusDate) && empty($showtimeMigrationSyncVenueStatusDate))) {
            unset($this->ShowtimeMigrationSyncVenueStatusDate);
        } else {
            $this->ShowtimeMigrationSyncVenueStatusDate = $showtimeMigrationSyncVenueStatusDate;
        }
        return $this;
    }
    /**
     * Get ShowTimeSupportNfcPass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowTimeSupportNfcPass()
    {
        return isset($this->ShowTimeSupportNfcPass) ? $this->ShowTimeSupportNfcPass : null;
    }
    /**
     * Set ShowTimeSupportNfcPass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showTimeSupportNfcPass
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowTimeSupportNfcPass($showTimeSupportNfcPass = null)
    {
        // validation for constraint: boolean
        if (!is_null($showTimeSupportNfcPass) && !is_bool($showTimeSupportNfcPass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showTimeSupportNfcPass, true), gettype($showTimeSupportNfcPass)), __LINE__);
        }
        if (is_null($showTimeSupportNfcPass) || (is_array($showTimeSupportNfcPass) && empty($showTimeSupportNfcPass))) {
            unset($this->ShowTimeSupportNfcPass);
        } else {
            $this->ShowTimeSupportNfcPass = $showTimeSupportNfcPass;
        }
        return $this;
    }
    /**
     * Get ShowtimeSyncStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowtimeSyncStatus()
    {
        return isset($this->ShowtimeSyncStatus) ? $this->ShowtimeSyncStatus : null;
    }
    /**
     * Set ShowtimeSyncStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessControlSynchronizationStatus::valueIsValid()
     * @uses \patest\EnumType\AccessControlSynchronizationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $showtimeSyncStatus
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setShowtimeSyncStatus($showtimeSyncStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccessControlSynchronizationStatus::valueIsValid($showtimeSyncStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessControlSynchronizationStatus', is_array($showtimeSyncStatus) ? implode(', ', $showtimeSyncStatus) : var_export($showtimeSyncStatus, true), implode(', ', \patest\EnumType\AccessControlSynchronizationStatus::getValidValues())), __LINE__);
        }
        if (is_null($showtimeSyncStatus) || (is_array($showtimeSyncStatus) && empty($showtimeSyncStatus))) {
            unset($this->ShowtimeSyncStatus);
        } else {
            $this->ShowtimeSyncStatus = $showtimeSyncStatus;
        }
        return $this;
    }
    /**
     * Get SupportsMobileApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSupportsMobileApp()
    {
        return isset($this->SupportsMobileApp) ? $this->SupportsMobileApp : null;
    }
    /**
     * Set SupportsMobileApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $supportsMobileApp
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setSupportsMobileApp($supportsMobileApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportsMobileApp) && !is_bool($supportsMobileApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supportsMobileApp, true), gettype($supportsMobileApp)), __LINE__);
        }
        if (is_null($supportsMobileApp) || (is_array($supportsMobileApp) && empty($supportsMobileApp))) {
            unset($this->SupportsMobileApp);
        } else {
            $this->SupportsMobileApp = $supportsMobileApp;
        }
        return $this;
    }
    /**
     * Get TimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZone()
    {
        return isset($this->TimeZone) ? $this->TimeZone : null;
    }
    /**
     * Set TimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZone
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        if (is_null($timeZone) || (is_array($timeZone) && empty($timeZone))) {
            unset($this->TimeZone);
        } else {
            $this->TimeZone = $timeZone;
        }
        return $this;
    }
    /**
     * Get UseAsDefaultForMemberships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAsDefaultForMemberships()
    {
        return isset($this->UseAsDefaultForMemberships) ? $this->UseAsDefaultForMemberships : null;
    }
    /**
     * Set UseAsDefaultForMemberships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAsDefaultForMemberships
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setUseAsDefaultForMemberships($useAsDefaultForMemberships = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAsDefaultForMemberships) && !is_bool($useAsDefaultForMemberships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAsDefaultForMemberships, true), gettype($useAsDefaultForMemberships)), __LINE__);
        }
        if (is_null($useAsDefaultForMemberships) || (is_array($useAsDefaultForMemberships) && empty($useAsDefaultForMemberships))) {
            unset($this->UseAsDefaultForMemberships);
        } else {
            $this->UseAsDefaultForMemberships = $useAsDefaultForMemberships;
        }
        return $this;
    }
    /**
     * Get UseAsDefaultForSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAsDefaultForSeries()
    {
        return isset($this->UseAsDefaultForSeries) ? $this->UseAsDefaultForSeries : null;
    }
    /**
     * Set UseAsDefaultForSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAsDefaultForSeries
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setUseAsDefaultForSeries($useAsDefaultForSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAsDefaultForSeries) && !is_bool($useAsDefaultForSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAsDefaultForSeries, true), gettype($useAsDefaultForSeries)), __LINE__);
        }
        if (is_null($useAsDefaultForSeries) || (is_array($useAsDefaultForSeries) && empty($useAsDefaultForSeries))) {
            unset($this->UseAsDefaultForSeries);
        } else {
            $this->UseAsDefaultForSeries = $useAsDefaultForSeries;
        }
        return $this;
    }
    /**
     * Get UseAsDefaultForVenues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAsDefaultForVenues()
    {
        return isset($this->UseAsDefaultForVenues) ? $this->UseAsDefaultForVenues : null;
    }
    /**
     * Set UseAsDefaultForVenues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAsDefaultForVenues
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setUseAsDefaultForVenues($useAsDefaultForVenues = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAsDefaultForVenues) && !is_bool($useAsDefaultForVenues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAsDefaultForVenues, true), gettype($useAsDefaultForVenues)), __LINE__);
        }
        if (is_null($useAsDefaultForVenues) || (is_array($useAsDefaultForVenues) && empty($useAsDefaultForVenues))) {
            unset($this->UseAsDefaultForVenues);
        } else {
            $this->UseAsDefaultForVenues = $useAsDefaultForVenues;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\AccessControl_AccessControlSystem
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
