<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.AccessControlJournalEntry StructType
 * @subpackage Structs
 */
class AccessControl_AccessControlJournalEntry extends Foundation_JournalEntry
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The AccessControlProvider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessControlProvider;
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeRefEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeRefEntityId;
    /**
     * The BarcodeRefEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeRefEntityName;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The MemberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MemberId;
    /**
     * The RequestRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestRefNumber;
    /**
     * The ShowInClientPortal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowInClientPortal;
    /**
     * The SyncAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SyncAction;
    /**
     * The SyncEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SyncEntityId;
    /**
     * The SyncEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SyncEntityName;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for AccessControl.AccessControlJournalEntry
     * @uses AccessControl_AccessControlJournalEntry::setAccessCardId()
     * @uses AccessControl_AccessControlJournalEntry::setAccessControlProvider()
     * @uses AccessControl_AccessControlJournalEntry::setAccessControlSystemId()
     * @uses AccessControl_AccessControlJournalEntry::setBarcode()
     * @uses AccessControl_AccessControlJournalEntry::setBarcodeRefEntityId()
     * @uses AccessControl_AccessControlJournalEntry::setBarcodeRefEntityName()
     * @uses AccessControl_AccessControlJournalEntry::setCardNumber()
     * @uses AccessControl_AccessControlJournalEntry::setClientId()
     * @uses AccessControl_AccessControlJournalEntry::setMemberId()
     * @uses AccessControl_AccessControlJournalEntry::setRequestRefNumber()
     * @uses AccessControl_AccessControlJournalEntry::setShowInClientPortal()
     * @uses AccessControl_AccessControlJournalEntry::setSyncAction()
     * @uses AccessControl_AccessControlJournalEntry::setSyncEntityId()
     * @uses AccessControl_AccessControlJournalEntry::setSyncEntityName()
     * @uses AccessControl_AccessControlJournalEntry::setTransactionId()
     * @param string $accessCardId
     * @param string $accessControlProvider
     * @param string $accessControlSystemId
     * @param string $barcode
     * @param string $barcodeRefEntityId
     * @param string $barcodeRefEntityName
     * @param string $cardNumber
     * @param string $clientId
     * @param string $memberId
     * @param string $requestRefNumber
     * @param bool $showInClientPortal
     * @param string $syncAction
     * @param string $syncEntityId
     * @param string $syncEntityName
     * @param string $transactionId
     */
    public function __construct($accessCardId = null, $accessControlProvider = null, $accessControlSystemId = null, $barcode = null, $barcodeRefEntityId = null, $barcodeRefEntityName = null, $cardNumber = null, $clientId = null, $memberId = null, $requestRefNumber = null, $showInClientPortal = null, $syncAction = null, $syncEntityId = null, $syncEntityName = null, $transactionId = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setAccessControlProvider($accessControlProvider)
            ->setAccessControlSystemId($accessControlSystemId)
            ->setBarcode($barcode)
            ->setBarcodeRefEntityId($barcodeRefEntityId)
            ->setBarcodeRefEntityName($barcodeRefEntityName)
            ->setCardNumber($cardNumber)
            ->setClientId($clientId)
            ->setMemberId($memberId)
            ->setRequestRefNumber($requestRefNumber)
            ->setShowInClientPortal($showInClientPortal)
            ->setSyncAction($syncAction)
            ->setSyncEntityId($syncEntityId)
            ->setSyncEntityName($syncEntityName)
            ->setTransactionId($transactionId);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get AccessControlProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProvider()
    {
        return isset($this->AccessControlProvider) ? $this->AccessControlProvider : null;
    }
    /**
     * Set AccessControlProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProvider
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setAccessControlProvider($accessControlProvider = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProvider) && !is_string($accessControlProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProvider, true), gettype($accessControlProvider)), __LINE__);
        }
        if (is_null($accessControlProvider) || (is_array($accessControlProvider) && empty($accessControlProvider))) {
            unset($this->AccessControlProvider);
        } else {
            $this->AccessControlProvider = $accessControlProvider;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeRefEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeRefEntityId()
    {
        return isset($this->BarcodeRefEntityId) ? $this->BarcodeRefEntityId : null;
    }
    /**
     * Set BarcodeRefEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeRefEntityId
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setBarcodeRefEntityId($barcodeRefEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeRefEntityId) && !is_string($barcodeRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeRefEntityId, true), gettype($barcodeRefEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeRefEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeRefEntityId, true)), __LINE__);
        }
        if (is_null($barcodeRefEntityId) || (is_array($barcodeRefEntityId) && empty($barcodeRefEntityId))) {
            unset($this->BarcodeRefEntityId);
        } else {
            $this->BarcodeRefEntityId = $barcodeRefEntityId;
        }
        return $this;
    }
    /**
     * Get BarcodeRefEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeRefEntityName()
    {
        return isset($this->BarcodeRefEntityName) ? $this->BarcodeRefEntityName : null;
    }
    /**
     * Set BarcodeRefEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeRefEntityName
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setBarcodeRefEntityName($barcodeRefEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeRefEntityName) && !is_string($barcodeRefEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeRefEntityName, true), gettype($barcodeRefEntityName)), __LINE__);
        }
        if (is_null($barcodeRefEntityName) || (is_array($barcodeRefEntityName) && empty($barcodeRefEntityName))) {
            unset($this->BarcodeRefEntityName);
        } else {
            $this->BarcodeRefEntityName = $barcodeRefEntityName;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get MemberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberId()
    {
        return isset($this->MemberId) ? $this->MemberId : null;
    }
    /**
     * Set MemberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberId
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: string
        if (!is_null($memberId) && !is_string($memberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        if (is_null($memberId) || (is_array($memberId) && empty($memberId))) {
            unset($this->MemberId);
        } else {
            $this->MemberId = $memberId;
        }
        return $this;
    }
    /**
     * Get RequestRefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestRefNumber()
    {
        return isset($this->RequestRefNumber) ? $this->RequestRefNumber : null;
    }
    /**
     * Set RequestRefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestRefNumber
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setRequestRefNumber($requestRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($requestRefNumber) && !is_string($requestRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestRefNumber, true), gettype($requestRefNumber)), __LINE__);
        }
        if (is_null($requestRefNumber) || (is_array($requestRefNumber) && empty($requestRefNumber))) {
            unset($this->RequestRefNumber);
        } else {
            $this->RequestRefNumber = $requestRefNumber;
        }
        return $this;
    }
    /**
     * Get ShowInClientPortal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowInClientPortal()
    {
        return isset($this->ShowInClientPortal) ? $this->ShowInClientPortal : null;
    }
    /**
     * Set ShowInClientPortal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showInClientPortal
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setShowInClientPortal($showInClientPortal = null)
    {
        // validation for constraint: boolean
        if (!is_null($showInClientPortal) && !is_bool($showInClientPortal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showInClientPortal, true), gettype($showInClientPortal)), __LINE__);
        }
        if (is_null($showInClientPortal) || (is_array($showInClientPortal) && empty($showInClientPortal))) {
            unset($this->ShowInClientPortal);
        } else {
            $this->ShowInClientPortal = $showInClientPortal;
        }
        return $this;
    }
    /**
     * Get SyncAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncAction()
    {
        return isset($this->SyncAction) ? $this->SyncAction : null;
    }
    /**
     * Set SyncAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DataSynchronizationAction::valueIsValid()
     * @uses \patest\EnumType\DataSynchronizationAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $syncAction
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setSyncAction($syncAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DataSynchronizationAction::valueIsValid($syncAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DataSynchronizationAction', is_array($syncAction) ? implode(', ', $syncAction) : var_export($syncAction, true), implode(', ', \patest\EnumType\DataSynchronizationAction::getValidValues())), __LINE__);
        }
        if (is_null($syncAction) || (is_array($syncAction) && empty($syncAction))) {
            unset($this->SyncAction);
        } else {
            $this->SyncAction = $syncAction;
        }
        return $this;
    }
    /**
     * Get SyncEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncEntityId()
    {
        return isset($this->SyncEntityId) ? $this->SyncEntityId : null;
    }
    /**
     * Set SyncEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $syncEntityId
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setSyncEntityId($syncEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($syncEntityId) && !is_string($syncEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncEntityId, true), gettype($syncEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($syncEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $syncEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($syncEntityId, true)), __LINE__);
        }
        if (is_null($syncEntityId) || (is_array($syncEntityId) && empty($syncEntityId))) {
            unset($this->SyncEntityId);
        } else {
            $this->SyncEntityId = $syncEntityId;
        }
        return $this;
    }
    /**
     * Get SyncEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncEntityName()
    {
        return isset($this->SyncEntityName) ? $this->SyncEntityName : null;
    }
    /**
     * Set SyncEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $syncEntityName
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setSyncEntityName($syncEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($syncEntityName) && !is_string($syncEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncEntityName, true), gettype($syncEntityName)), __LINE__);
        }
        if (is_null($syncEntityName) || (is_array($syncEntityName) && empty($syncEntityName))) {
            unset($this->SyncEntityName);
        } else {
            $this->SyncEntityName = $syncEntityName;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\AccessControl_AccessControlJournalEntry
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
