<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.AccessCardActivation StructType
 * @subpackage Structs
 */
class AccessControl_AccessCardActivation extends PersistableEntity
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The ActivationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivationDate;
    /**
     * The DeactivationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeactivationDate;
    /**
     * The DeactivationReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeactivationReason;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsCardOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCardOwner;
    /**
     * The RefEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RefEntityId;
    /**
     * The RefEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefEntityName;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for AccessControl.AccessCardActivation
     * @uses AccessControl_AccessCardActivation::setAccessCardId()
     * @uses AccessControl_AccessCardActivation::setActivationDate()
     * @uses AccessControl_AccessCardActivation::setDeactivationDate()
     * @uses AccessControl_AccessCardActivation::setDeactivationReason()
     * @uses AccessControl_AccessCardActivation::setIsActive()
     * @uses AccessControl_AccessCardActivation::setIsCardOwner()
     * @uses AccessControl_AccessCardActivation::setRefEntityId()
     * @uses AccessControl_AccessCardActivation::setRefEntityName()
     * @uses AccessControl_AccessCardActivation::setTransactionId()
     * @param string $accessCardId
     * @param string $activationDate
     * @param string $deactivationDate
     * @param string $deactivationReason
     * @param bool $isActive
     * @param bool $isCardOwner
     * @param string $refEntityId
     * @param string $refEntityName
     * @param string $transactionId
     */
    public function __construct($accessCardId = null, $activationDate = null, $deactivationDate = null, $deactivationReason = null, $isActive = null, $isCardOwner = null, $refEntityId = null, $refEntityName = null, $transactionId = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setActivationDate($activationDate)
            ->setDeactivationDate($deactivationDate)
            ->setDeactivationReason($deactivationReason)
            ->setIsActive($isActive)
            ->setIsCardOwner($isCardOwner)
            ->setRefEntityId($refEntityId)
            ->setRefEntityName($refEntityName)
            ->setTransactionId($transactionId);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get ActivationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivationDate()
    {
        return isset($this->ActivationDate) ? $this->ActivationDate : null;
    }
    /**
     * Set ActivationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activationDate
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setActivationDate($activationDate = null)
    {
        // validation for constraint: string
        if (!is_null($activationDate) && !is_string($activationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activationDate, true), gettype($activationDate)), __LINE__);
        }
        if (is_null($activationDate) || (is_array($activationDate) && empty($activationDate))) {
            unset($this->ActivationDate);
        } else {
            $this->ActivationDate = $activationDate;
        }
        return $this;
    }
    /**
     * Get DeactivationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeactivationDate()
    {
        return isset($this->DeactivationDate) ? $this->DeactivationDate : null;
    }
    /**
     * Set DeactivationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deactivationDate
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setDeactivationDate($deactivationDate = null)
    {
        // validation for constraint: string
        if (!is_null($deactivationDate) && !is_string($deactivationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deactivationDate, true), gettype($deactivationDate)), __LINE__);
        }
        if (is_null($deactivationDate) || (is_array($deactivationDate) && empty($deactivationDate))) {
            unset($this->DeactivationDate);
        } else {
            $this->DeactivationDate = $deactivationDate;
        }
        return $this;
    }
    /**
     * Get DeactivationReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeactivationReason()
    {
        return isset($this->DeactivationReason) ? $this->DeactivationReason : null;
    }
    /**
     * Set DeactivationReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deactivationReason
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setDeactivationReason($deactivationReason = null)
    {
        // validation for constraint: string
        if (!is_null($deactivationReason) && !is_string($deactivationReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deactivationReason, true), gettype($deactivationReason)), __LINE__);
        }
        if (is_null($deactivationReason) || (is_array($deactivationReason) && empty($deactivationReason))) {
            unset($this->DeactivationReason);
        } else {
            $this->DeactivationReason = $deactivationReason;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsCardOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCardOwner()
    {
        return isset($this->IsCardOwner) ? $this->IsCardOwner : null;
    }
    /**
     * Set IsCardOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCardOwner
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setIsCardOwner($isCardOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCardOwner) && !is_bool($isCardOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCardOwner, true), gettype($isCardOwner)), __LINE__);
        }
        if (is_null($isCardOwner) || (is_array($isCardOwner) && empty($isCardOwner))) {
            unset($this->IsCardOwner);
        } else {
            $this->IsCardOwner = $isCardOwner;
        }
        return $this;
    }
    /**
     * Get RefEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefEntityId()
    {
        return isset($this->RefEntityId) ? $this->RefEntityId : null;
    }
    /**
     * Set RefEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refEntityId
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setRefEntityId($refEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($refEntityId) && !is_string($refEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refEntityId, true), gettype($refEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($refEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $refEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($refEntityId, true)), __LINE__);
        }
        if (is_null($refEntityId) || (is_array($refEntityId) && empty($refEntityId))) {
            unset($this->RefEntityId);
        } else {
            $this->RefEntityId = $refEntityId;
        }
        return $this;
    }
    /**
     * Get RefEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefEntityName()
    {
        return isset($this->RefEntityName) ? $this->RefEntityName : null;
    }
    /**
     * Set RefEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refEntityName
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setRefEntityName($refEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($refEntityName) && !is_string($refEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refEntityName, true), gettype($refEntityName)), __LINE__);
        }
        if (is_null($refEntityName) || (is_array($refEntityName) && empty($refEntityName))) {
            unset($this->RefEntityName);
        } else {
            $this->RefEntityName = $refEntityName;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\AccessControl_AccessCardActivation
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
