<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractPriceModifier StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AbstractPriceModifier
 * @subpackage Structs
 */
class AbstractPriceModifier extends AbstractStructBase
{
    /**
     * The Activated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Activated;
    /**
     * The BackwardContinuation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceModifierIdentity
     */
    public $BackwardContinuation;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $BaseAmount;
    /**
     * The Children
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAbstractPriceModifier
     */
    public $Children;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $Details;
    /**
     * The Effective
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Effective;
    /**
     * The EffectiveAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $EffectiveAmount;
    /**
     * The ForwardContinuation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceModifierIdentity
     */
    public $ForwardContinuation;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Included
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Included;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsertionMode;
    /**
     * The IsOverridden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOverridden;
    /**
     * The IsSubscriptionSourcedCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSubscriptionSourcedCommission;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The Master
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Master;
    /**
     * The Optional
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Optional;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The Overridable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Overridable;
    /**
     * The ParentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentId;
    /**
     * The PartOfFacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PartOfFacePrice;
    /**
     * The PayEffectiveness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PayEffectiveness;
    /**
     * The PriceModifierDefinition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceModifierDefinitionSnapshot
     */
    public $PriceModifierDefinition;
    /**
     * The SupplierPriceModifierIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceModifierIdentity
     */
    public $SupplierPriceModifierIdentity;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The IsSinglyRefundable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSinglyRefundable;
    /**
     * Constructor method for AbstractPriceModifier
     * @uses AbstractPriceModifier::setActivated()
     * @uses AbstractPriceModifier::setBackwardContinuation()
     * @uses AbstractPriceModifier::setBaseAmount()
     * @uses AbstractPriceModifier::setChildren()
     * @uses AbstractPriceModifier::setDescription()
     * @uses AbstractPriceModifier::setDetails()
     * @uses AbstractPriceModifier::setEffective()
     * @uses AbstractPriceModifier::setEffectiveAmount()
     * @uses AbstractPriceModifier::setForwardContinuation()
     * @uses AbstractPriceModifier::setId()
     * @uses AbstractPriceModifier::setIncluded()
     * @uses AbstractPriceModifier::setInsertionMode()
     * @uses AbstractPriceModifier::setIsOverridden()
     * @uses AbstractPriceModifier::setIsSubscriptionSourcedCommission()
     * @uses AbstractPriceModifier::setItemId()
     * @uses AbstractPriceModifier::setMaster()
     * @uses AbstractPriceModifier::setOptional()
     * @uses AbstractPriceModifier::setOrigin()
     * @uses AbstractPriceModifier::setOverridable()
     * @uses AbstractPriceModifier::setParentId()
     * @uses AbstractPriceModifier::setPartOfFacePrice()
     * @uses AbstractPriceModifier::setPayEffectiveness()
     * @uses AbstractPriceModifier::setPriceModifierDefinition()
     * @uses AbstractPriceModifier::setSupplierPriceModifierIdentity()
     * @uses AbstractPriceModifier::setTotalAmount()
     * @uses AbstractPriceModifier::setIsSinglyRefundable()
     * @param bool $activated
     * @param \patest\StructType\PriceModifierIdentity $backwardContinuation
     * @param \patest\StructType\Money $baseAmount
     * @param \patest\ArrayType\ArrayOfAbstractPriceModifier $children
     * @param string $description
     * @param \patest\ArrayType\ArrayOfint $details
     * @param bool $effective
     * @param \patest\StructType\Money $effectiveAmount
     * @param \patest\StructType\PriceModifierIdentity $forwardContinuation
     * @param int $id
     * @param bool $included
     * @param string $insertionMode
     * @param bool $isOverridden
     * @param bool $isSubscriptionSourcedCommission
     * @param int $itemId
     * @param int $master
     * @param bool $optional
     * @param string $origin
     * @param bool $overridable
     * @param int $parentId
     * @param bool $partOfFacePrice
     * @param string $payEffectiveness
     * @param \patest\StructType\PriceModifierDefinitionSnapshot $priceModifierDefinition
     * @param \patest\StructType\PriceModifierIdentity $supplierPriceModifierIdentity
     * @param \patest\StructType\Money $totalAmount
     * @param bool $isSinglyRefundable
     */
    public function __construct($activated = null, \patest\StructType\PriceModifierIdentity $backwardContinuation = null, \patest\StructType\Money $baseAmount = null, \patest\ArrayType\ArrayOfAbstractPriceModifier $children = null, $description = null, \patest\ArrayType\ArrayOfint $details = null, $effective = null, \patest\StructType\Money $effectiveAmount = null, \patest\StructType\PriceModifierIdentity $forwardContinuation = null, $id = null, $included = null, $insertionMode = null, $isOverridden = null, $isSubscriptionSourcedCommission = null, $itemId = null, $master = null, $optional = null, $origin = null, $overridable = null, $parentId = null, $partOfFacePrice = null, $payEffectiveness = null, \patest\StructType\PriceModifierDefinitionSnapshot $priceModifierDefinition = null, \patest\StructType\PriceModifierIdentity $supplierPriceModifierIdentity = null, \patest\StructType\Money $totalAmount = null, $isSinglyRefundable = null)
    {
        $this
            ->setActivated($activated)
            ->setBackwardContinuation($backwardContinuation)
            ->setBaseAmount($baseAmount)
            ->setChildren($children)
            ->setDescription($description)
            ->setDetails($details)
            ->setEffective($effective)
            ->setEffectiveAmount($effectiveAmount)
            ->setForwardContinuation($forwardContinuation)
            ->setId($id)
            ->setIncluded($included)
            ->setInsertionMode($insertionMode)
            ->setIsOverridden($isOverridden)
            ->setIsSubscriptionSourcedCommission($isSubscriptionSourcedCommission)
            ->setItemId($itemId)
            ->setMaster($master)
            ->setOptional($optional)
            ->setOrigin($origin)
            ->setOverridable($overridable)
            ->setParentId($parentId)
            ->setPartOfFacePrice($partOfFacePrice)
            ->setPayEffectiveness($payEffectiveness)
            ->setPriceModifierDefinition($priceModifierDefinition)
            ->setSupplierPriceModifierIdentity($supplierPriceModifierIdentity)
            ->setTotalAmount($totalAmount)
            ->setIsSinglyRefundable($isSinglyRefundable);
    }
    /**
     * Get Activated value
     * @return bool|null
     */
    public function getActivated()
    {
        return $this->Activated;
    }
    /**
     * Set Activated value
     * @param bool $activated
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setActivated($activated = null)
    {
        // validation for constraint: boolean
        if (!is_null($activated) && !is_bool($activated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activated, true), gettype($activated)), __LINE__);
        }
        $this->Activated = $activated;
        return $this;
    }
    /**
     * Get BackwardContinuation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceModifierIdentity|null
     */
    public function getBackwardContinuation()
    {
        return isset($this->BackwardContinuation) ? $this->BackwardContinuation : null;
    }
    /**
     * Set BackwardContinuation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceModifierIdentity $backwardContinuation
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setBackwardContinuation(\patest\StructType\PriceModifierIdentity $backwardContinuation = null)
    {
        if (is_null($backwardContinuation) || (is_array($backwardContinuation) && empty($backwardContinuation))) {
            unset($this->BackwardContinuation);
        } else {
            $this->BackwardContinuation = $backwardContinuation;
        }
        return $this;
    }
    /**
     * Get BaseAmount value
     * @return \patest\StructType\Money|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param \patest\StructType\Money $baseAmount
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setBaseAmount(\patest\StructType\Money $baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get Children value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAbstractPriceModifier|null
     */
    public function getChildren()
    {
        return isset($this->Children) ? $this->Children : null;
    }
    /**
     * Set Children value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAbstractPriceModifier $children
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setChildren(\patest\ArrayType\ArrayOfAbstractPriceModifier $children = null)
    {
        if (is_null($children) || (is_array($children) && empty($children))) {
            unset($this->Children);
        } else {
            $this->Children = $children;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $details
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setDetails(\patest\ArrayType\ArrayOfint $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get Effective value
     * @return bool|null
     */
    public function getEffective()
    {
        return $this->Effective;
    }
    /**
     * Set Effective value
     * @param bool $effective
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setEffective($effective = null)
    {
        // validation for constraint: boolean
        if (!is_null($effective) && !is_bool($effective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($effective, true), gettype($effective)), __LINE__);
        }
        $this->Effective = $effective;
        return $this;
    }
    /**
     * Get EffectiveAmount value
     * @return \patest\StructType\Money|null
     */
    public function getEffectiveAmount()
    {
        return $this->EffectiveAmount;
    }
    /**
     * Set EffectiveAmount value
     * @param \patest\StructType\Money $effectiveAmount
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setEffectiveAmount(\patest\StructType\Money $effectiveAmount = null)
    {
        $this->EffectiveAmount = $effectiveAmount;
        return $this;
    }
    /**
     * Get ForwardContinuation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceModifierIdentity|null
     */
    public function getForwardContinuation()
    {
        return isset($this->ForwardContinuation) ? $this->ForwardContinuation : null;
    }
    /**
     * Set ForwardContinuation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceModifierIdentity $forwardContinuation
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setForwardContinuation(\patest\StructType\PriceModifierIdentity $forwardContinuation = null)
    {
        if (is_null($forwardContinuation) || (is_array($forwardContinuation) && empty($forwardContinuation))) {
            unset($this->ForwardContinuation);
        } else {
            $this->ForwardContinuation = $forwardContinuation;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Included value
     * @return bool|null
     */
    public function getIncluded()
    {
        return $this->Included;
    }
    /**
     * Set Included value
     * @param bool $included
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setIncluded($included = null)
    {
        // validation for constraint: boolean
        if (!is_null($included) && !is_bool($included)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($included, true), gettype($included)), __LINE__);
        }
        $this->Included = $included;
        return $this;
    }
    /**
     * Get InsertionMode value
     * @return string|null
     */
    public function getInsertionMode()
    {
        return $this->InsertionMode;
    }
    /**
     * Set InsertionMode value
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        $this->InsertionMode = $insertionMode;
        return $this;
    }
    /**
     * Get IsOverridden value
     * @return bool|null
     */
    public function getIsOverridden()
    {
        return $this->IsOverridden;
    }
    /**
     * Set IsOverridden value
     * @param bool $isOverridden
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setIsOverridden($isOverridden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOverridden) && !is_bool($isOverridden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOverridden, true), gettype($isOverridden)), __LINE__);
        }
        $this->IsOverridden = $isOverridden;
        return $this;
    }
    /**
     * Get IsSubscriptionSourcedCommission value
     * @return bool|null
     */
    public function getIsSubscriptionSourcedCommission()
    {
        return $this->IsSubscriptionSourcedCommission;
    }
    /**
     * Set IsSubscriptionSourcedCommission value
     * @param bool $isSubscriptionSourcedCommission
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setIsSubscriptionSourcedCommission($isSubscriptionSourcedCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriptionSourcedCommission) && !is_bool($isSubscriptionSourcedCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriptionSourcedCommission, true), gettype($isSubscriptionSourcedCommission)), __LINE__);
        }
        $this->IsSubscriptionSourcedCommission = $isSubscriptionSourcedCommission;
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get Master value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaster()
    {
        return isset($this->Master) ? $this->Master : null;
    }
    /**
     * Set Master value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $master
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setMaster($master = null)
    {
        // validation for constraint: int
        if (!is_null($master) && !(is_int($master) || ctype_digit($master))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($master, true), gettype($master)), __LINE__);
        }
        if (is_null($master) || (is_array($master) && empty($master))) {
            unset($this->Master);
        } else {
            $this->Master = $master;
        }
        return $this;
    }
    /**
     * Get Optional value
     * @return bool|null
     */
    public function getOptional()
    {
        return $this->Optional;
    }
    /**
     * Set Optional value
     * @param bool $optional
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setOptional($optional = null)
    {
        // validation for constraint: boolean
        if (!is_null($optional) && !is_bool($optional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optional, true), gettype($optional)), __LINE__);
        }
        $this->Optional = $optional;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @uses \patest\EnumType\PriceModifierOrigin::valueIsValid()
     * @uses \patest\EnumType\PriceModifierOrigin::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $origin
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierOrigin::valueIsValid($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierOrigin', is_array($origin) ? implode(', ', $origin) : var_export($origin, true), implode(', ', \patest\EnumType\PriceModifierOrigin::getValidValues())), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Overridable value
     * @return bool|null
     */
    public function getOverridable()
    {
        return $this->Overridable;
    }
    /**
     * Set Overridable value
     * @param bool $overridable
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setOverridable($overridable = null)
    {
        // validation for constraint: boolean
        if (!is_null($overridable) && !is_bool($overridable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overridable, true), gettype($overridable)), __LINE__);
        }
        $this->Overridable = $overridable;
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentId
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: int
        if (!is_null($parentId) && !(is_int($parentId) || ctype_digit($parentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get PartOfFacePrice value
     * @return bool|null
     */
    public function getPartOfFacePrice()
    {
        return $this->PartOfFacePrice;
    }
    /**
     * Set PartOfFacePrice value
     * @param bool $partOfFacePrice
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setPartOfFacePrice($partOfFacePrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($partOfFacePrice) && !is_bool($partOfFacePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partOfFacePrice, true), gettype($partOfFacePrice)), __LINE__);
        }
        $this->PartOfFacePrice = $partOfFacePrice;
        return $this;
    }
    /**
     * Get PayEffectiveness value
     * @return string|null
     */
    public function getPayEffectiveness()
    {
        return $this->PayEffectiveness;
    }
    /**
     * Set PayEffectiveness value
     * @uses \patest\EnumType\PriceModifierPayEffectiveness::valueIsValid()
     * @uses \patest\EnumType\PriceModifierPayEffectiveness::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payEffectiveness
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setPayEffectiveness($payEffectiveness = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierPayEffectiveness::valueIsValid($payEffectiveness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierPayEffectiveness', is_array($payEffectiveness) ? implode(', ', $payEffectiveness) : var_export($payEffectiveness, true), implode(', ', \patest\EnumType\PriceModifierPayEffectiveness::getValidValues())), __LINE__);
        }
        $this->PayEffectiveness = $payEffectiveness;
        return $this;
    }
    /**
     * Get PriceModifierDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceModifierDefinitionSnapshot|null
     */
    public function getPriceModifierDefinition()
    {
        return isset($this->PriceModifierDefinition) ? $this->PriceModifierDefinition : null;
    }
    /**
     * Set PriceModifierDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceModifierDefinitionSnapshot $priceModifierDefinition
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setPriceModifierDefinition(\patest\StructType\PriceModifierDefinitionSnapshot $priceModifierDefinition = null)
    {
        if (is_null($priceModifierDefinition) || (is_array($priceModifierDefinition) && empty($priceModifierDefinition))) {
            unset($this->PriceModifierDefinition);
        } else {
            $this->PriceModifierDefinition = $priceModifierDefinition;
        }
        return $this;
    }
    /**
     * Get SupplierPriceModifierIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceModifierIdentity|null
     */
    public function getSupplierPriceModifierIdentity()
    {
        return isset($this->SupplierPriceModifierIdentity) ? $this->SupplierPriceModifierIdentity : null;
    }
    /**
     * Set SupplierPriceModifierIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceModifierIdentity $supplierPriceModifierIdentity
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setSupplierPriceModifierIdentity(\patest\StructType\PriceModifierIdentity $supplierPriceModifierIdentity = null)
    {
        if (is_null($supplierPriceModifierIdentity) || (is_array($supplierPriceModifierIdentity) && empty($supplierPriceModifierIdentity))) {
            unset($this->SupplierPriceModifierIdentity);
        } else {
            $this->SupplierPriceModifierIdentity = $supplierPriceModifierIdentity;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get IsSinglyRefundable value
     * @return bool|null
     */
    public function getIsSinglyRefundable()
    {
        return $this->IsSinglyRefundable;
    }
    /**
     * Set IsSinglyRefundable value
     * @param bool $isSinglyRefundable
     * @return \patest\StructType\AbstractPriceModifier
     */
    public function setIsSinglyRefundable($isSinglyRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSinglyRefundable) && !is_bool($isSinglyRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSinglyRefundable, true), gettype($isSinglyRefundable)), __LINE__);
        }
        $this->IsSinglyRefundable = $isSinglyRefundable;
        return $this;
    }
}
