<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractPaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AbstractPaymentItem
 * @subpackage Structs
 */
class AbstractPaymentItem extends AbstractItem
{
    /**
     * The AmountsReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AmountsReferenceId;
    /**
     * The Authorized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Authorized;
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Installments;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The ProviderSpecificData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ProviderSpecificData;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The IsFictive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFictive;
    /**
     * The PaymentSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentSessionId;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The IsChangeUnpaidStatusAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsChangeUnpaidStatusAllowed;
    /**
     * The IsCollectTokenWithoutPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCollectTokenWithoutPayment;
    /**
     * The IsForFuturePayByCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsForFuturePayByCustomer;
    /**
     * The IsForFuturePayInternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsForFuturePayInternally;
    /**
     * The ProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProviderSpecificTokenId;
    /**
     * The OriginalPaymentItemIdForRefund
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalPaymentItemIdForRefund;
    /**
     * Constructor method for AbstractPaymentItem
     * @uses AbstractPaymentItem::setAmountsReferenceId()
     * @uses AbstractPaymentItem::setAuthorized()
     * @uses AbstractPaymentItem::setClientAmount()
     * @uses AbstractPaymentItem::setInstallments()
     * @uses AbstractPaymentItem::setPaymentMethodId()
     * @uses AbstractPaymentItem::setProviderSpecificData()
     * @uses AbstractPaymentItem::setStatus()
     * @uses AbstractPaymentItem::setType()
     * @uses AbstractPaymentItem::setTransactionGuid()
     * @uses AbstractPaymentItem::setIsFictive()
     * @uses AbstractPaymentItem::setPaymentSessionId()
     * @uses AbstractPaymentItem::setReferenceNumber()
     * @uses AbstractPaymentItem::setIsChangeUnpaidStatusAllowed()
     * @uses AbstractPaymentItem::setIsCollectTokenWithoutPayment()
     * @uses AbstractPaymentItem::setIsForFuturePayByCustomer()
     * @uses AbstractPaymentItem::setIsForFuturePayInternally()
     * @uses AbstractPaymentItem::setProviderSpecificTokenId()
     * @uses AbstractPaymentItem::setOriginalPaymentItemIdForRefund()
     * @param string $amountsReferenceId
     * @param bool $authorized
     * @param \patest\StructType\Money $clientAmount
     * @param int $installments
     * @param string $paymentMethodId
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData
     * @param string $status
     * @param string $type
     * @param string $transactionGuid
     * @param bool $isFictive
     * @param string $paymentSessionId
     * @param string $referenceNumber
     * @param bool $isChangeUnpaidStatusAllowed
     * @param bool $isCollectTokenWithoutPayment
     * @param bool $isForFuturePayByCustomer
     * @param bool $isForFuturePayInternally
     * @param string $providerSpecificTokenId
     * @param string $originalPaymentItemIdForRefund
     */
    public function __construct($amountsReferenceId = null, $authorized = null, \patest\StructType\Money $clientAmount = null, $installments = null, $paymentMethodId = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData = null, $status = null, $type = null, $transactionGuid = null, $isFictive = null, $paymentSessionId = null, $referenceNumber = null, $isChangeUnpaidStatusAllowed = null, $isCollectTokenWithoutPayment = null, $isForFuturePayByCustomer = null, $isForFuturePayInternally = null, $providerSpecificTokenId = null, $originalPaymentItemIdForRefund = null)
    {
        $this
            ->setAmountsReferenceId($amountsReferenceId)
            ->setAuthorized($authorized)
            ->setClientAmount($clientAmount)
            ->setInstallments($installments)
            ->setPaymentMethodId($paymentMethodId)
            ->setProviderSpecificData($providerSpecificData)
            ->setStatus($status)
            ->setType($type)
            ->setTransactionGuid($transactionGuid)
            ->setIsFictive($isFictive)
            ->setPaymentSessionId($paymentSessionId)
            ->setReferenceNumber($referenceNumber)
            ->setIsChangeUnpaidStatusAllowed($isChangeUnpaidStatusAllowed)
            ->setIsCollectTokenWithoutPayment($isCollectTokenWithoutPayment)
            ->setIsForFuturePayByCustomer($isForFuturePayByCustomer)
            ->setIsForFuturePayInternally($isForFuturePayInternally)
            ->setProviderSpecificTokenId($providerSpecificTokenId)
            ->setOriginalPaymentItemIdForRefund($originalPaymentItemIdForRefund);
    }
    /**
     * Get AmountsReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountsReferenceId()
    {
        return isset($this->AmountsReferenceId) ? $this->AmountsReferenceId : null;
    }
    /**
     * Set AmountsReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amountsReferenceId
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setAmountsReferenceId($amountsReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($amountsReferenceId) && !is_string($amountsReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountsReferenceId, true), gettype($amountsReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($amountsReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $amountsReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($amountsReferenceId, true)), __LINE__);
        }
        if (is_null($amountsReferenceId) || (is_array($amountsReferenceId) && empty($amountsReferenceId))) {
            unset($this->AmountsReferenceId);
        } else {
            $this->AmountsReferenceId = $amountsReferenceId;
        }
        return $this;
    }
    /**
     * Get Authorized value
     * @return bool|null
     */
    public function getAuthorized()
    {
        return $this->Authorized;
    }
    /**
     * Set Authorized value
     * @param bool $authorized
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setAuthorized($authorized = null)
    {
        // validation for constraint: boolean
        if (!is_null($authorized) && !is_bool($authorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($authorized, true), gettype($authorized)), __LINE__);
        }
        $this->Authorized = $authorized;
        return $this;
    }
    /**
     * Get ClientAmount value
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return $this->ClientAmount;
    }
    /**
     * Set ClientAmount value
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        $this->ClientAmount = $clientAmount;
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installments
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setInstallments($installments = null)
    {
        // validation for constraint: int
        if (!is_null($installments) && !(is_int($installments) || ctype_digit($installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installments, true), gettype($installments)), __LINE__);
        }
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get ProviderSpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getProviderSpecificData()
    {
        return isset($this->ProviderSpecificData) ? $this->ProviderSpecificData : null;
    }
    /**
     * Set ProviderSpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setProviderSpecificData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData = null)
    {
        if (is_null($providerSpecificData) || (is_array($providerSpecificData) && empty($providerSpecificData))) {
            unset($this->ProviderSpecificData);
        } else {
            $this->ProviderSpecificData = $providerSpecificData;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get IsFictive value
     * @return bool|null
     */
    public function getIsFictive()
    {
        return $this->IsFictive;
    }
    /**
     * Set IsFictive value
     * @param bool $isFictive
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setIsFictive($isFictive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFictive) && !is_bool($isFictive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFictive, true), gettype($isFictive)), __LINE__);
        }
        $this->IsFictive = $isFictive;
        return $this;
    }
    /**
     * Get PaymentSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentSessionId()
    {
        return isset($this->PaymentSessionId) ? $this->PaymentSessionId : null;
    }
    /**
     * Set PaymentSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentSessionId
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setPaymentSessionId($paymentSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSessionId) && !is_string($paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSessionId, true), gettype($paymentSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentSessionId, true)), __LINE__);
        }
        if (is_null($paymentSessionId) || (is_array($paymentSessionId) && empty($paymentSessionId))) {
            unset($this->PaymentSessionId);
        } else {
            $this->PaymentSessionId = $paymentSessionId;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceNumber
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get IsChangeUnpaidStatusAllowed value
     * @return bool|null
     */
    public function getIsChangeUnpaidStatusAllowed()
    {
        return $this->IsChangeUnpaidStatusAllowed;
    }
    /**
     * Set IsChangeUnpaidStatusAllowed value
     * @param bool $isChangeUnpaidStatusAllowed
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setIsChangeUnpaidStatusAllowed($isChangeUnpaidStatusAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isChangeUnpaidStatusAllowed) && !is_bool($isChangeUnpaidStatusAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isChangeUnpaidStatusAllowed, true), gettype($isChangeUnpaidStatusAllowed)), __LINE__);
        }
        $this->IsChangeUnpaidStatusAllowed = $isChangeUnpaidStatusAllowed;
        return $this;
    }
    /**
     * Get IsCollectTokenWithoutPayment value
     * @return bool|null
     */
    public function getIsCollectTokenWithoutPayment()
    {
        return $this->IsCollectTokenWithoutPayment;
    }
    /**
     * Set IsCollectTokenWithoutPayment value
     * @param bool $isCollectTokenWithoutPayment
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setIsCollectTokenWithoutPayment($isCollectTokenWithoutPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCollectTokenWithoutPayment) && !is_bool($isCollectTokenWithoutPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCollectTokenWithoutPayment, true), gettype($isCollectTokenWithoutPayment)), __LINE__);
        }
        $this->IsCollectTokenWithoutPayment = $isCollectTokenWithoutPayment;
        return $this;
    }
    /**
     * Get IsForFuturePayByCustomer value
     * @return bool|null
     */
    public function getIsForFuturePayByCustomer()
    {
        return $this->IsForFuturePayByCustomer;
    }
    /**
     * Set IsForFuturePayByCustomer value
     * @param bool $isForFuturePayByCustomer
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setIsForFuturePayByCustomer($isForFuturePayByCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayByCustomer) && !is_bool($isForFuturePayByCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayByCustomer, true), gettype($isForFuturePayByCustomer)), __LINE__);
        }
        $this->IsForFuturePayByCustomer = $isForFuturePayByCustomer;
        return $this;
    }
    /**
     * Get IsForFuturePayInternally value
     * @return bool|null
     */
    public function getIsForFuturePayInternally()
    {
        return $this->IsForFuturePayInternally;
    }
    /**
     * Set IsForFuturePayInternally value
     * @param bool $isForFuturePayInternally
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setIsForFuturePayInternally($isForFuturePayInternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayInternally) && !is_bool($isForFuturePayInternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayInternally, true), gettype($isForFuturePayInternally)), __LINE__);
        }
        $this->IsForFuturePayInternally = $isForFuturePayInternally;
        return $this;
    }
    /**
     * Get ProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSpecificTokenId()
    {
        return isset($this->ProviderSpecificTokenId) ? $this->ProviderSpecificTokenId : null;
    }
    /**
     * Set ProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSpecificTokenId
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setProviderSpecificTokenId($providerSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($providerSpecificTokenId) && !is_string($providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSpecificTokenId, true), gettype($providerSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($providerSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($providerSpecificTokenId, true)), __LINE__);
        }
        if (is_null($providerSpecificTokenId) || (is_array($providerSpecificTokenId) && empty($providerSpecificTokenId))) {
            unset($this->ProviderSpecificTokenId);
        } else {
            $this->ProviderSpecificTokenId = $providerSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get OriginalPaymentItemIdForRefund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPaymentItemIdForRefund()
    {
        return isset($this->OriginalPaymentItemIdForRefund) ? $this->OriginalPaymentItemIdForRefund : null;
    }
    /**
     * Set OriginalPaymentItemIdForRefund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPaymentItemIdForRefund
     * @return \patest\StructType\AbstractPaymentItem
     */
    public function setOriginalPaymentItemIdForRefund($originalPaymentItemIdForRefund = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentItemIdForRefund) && !is_string($originalPaymentItemIdForRefund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentItemIdForRefund, true), gettype($originalPaymentItemIdForRefund)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalPaymentItemIdForRefund) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalPaymentItemIdForRefund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalPaymentItemIdForRefund, true)), __LINE__);
        }
        if (is_null($originalPaymentItemIdForRefund) || (is_array($originalPaymentItemIdForRefund) && empty($originalPaymentItemIdForRefund))) {
            unset($this->OriginalPaymentItemIdForRefund);
        } else {
            $this->OriginalPaymentItemIdForRefund = $originalPaymentItemIdForRefund;
        }
        return $this;
    }
}
