<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AbstractItem
 * @subpackage Structs
 */
class AbstractItem extends AbstractStructBase
{
    /**
     * The BasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $BasePrice;
    /**
     * The BusinessFlow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessFlow;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExtraFields
     */
    public $ExtraFields;
    /**
     * The FacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $FacePrice;
    /**
     * The InsertionGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InsertionGroup;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsertionMode;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemType;
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $ListPrice;
    /**
     * The PackageItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $PackageItemIds;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAbstractPriceModifier
     */
    public $PriceModifiers;
    /**
     * The PriceToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $PriceToPay;
    /**
     * The RequestedAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestedAction;
    /**
     * The ServiceSpecificHandle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ServiceSpecificHandle;
    /**
     * The SupplierItemIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ItemIdentity
     */
    public $SupplierItemIdentity;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The ServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificId;
    /**
     * The IsIncomplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIncomplete;
    /**
     * The ValidationErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfFailureInformation
     */
    public $ValidationErrors;
    /**
     * The EffectiveListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $EffectiveListPrice;
    /**
     * The RegularPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RegularPrice;
    /**
     * The AdjustedPriceToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $AdjustedPriceToPay;
    /**
     * Constructor method for AbstractItem
     * @uses AbstractItem::setBasePrice()
     * @uses AbstractItem::setBusinessFlow()
     * @uses AbstractItem::setClientId()
     * @uses AbstractItem::setDescription()
     * @uses AbstractItem::setExtraFields()
     * @uses AbstractItem::setFacePrice()
     * @uses AbstractItem::setInsertionGroup()
     * @uses AbstractItem::setInsertionMode()
     * @uses AbstractItem::setItemId()
     * @uses AbstractItem::setItemType()
     * @uses AbstractItem::setListPrice()
     * @uses AbstractItem::setPackageItemIds()
     * @uses AbstractItem::setPriceModifiers()
     * @uses AbstractItem::setPriceToPay()
     * @uses AbstractItem::setRequestedAction()
     * @uses AbstractItem::setServiceSpecificHandle()
     * @uses AbstractItem::setSupplierItemIdentity()
     * @uses AbstractItem::setTotalPrice()
     * @uses AbstractItem::setServiceSpecificId()
     * @uses AbstractItem::setIsIncomplete()
     * @uses AbstractItem::setValidationErrors()
     * @uses AbstractItem::setEffectiveListPrice()
     * @uses AbstractItem::setRegularPrice()
     * @uses AbstractItem::setAdjustedPriceToPay()
     * @param \patest\StructType\Money $basePrice
     * @param string $businessFlow
     * @param string $clientId
     * @param string $description
     * @param \patest\StructType\ExtraFields $extraFields
     * @param \patest\StructType\Money $facePrice
     * @param int $insertionGroup
     * @param string $insertionMode
     * @param int $itemId
     * @param int $itemType
     * @param \patest\StructType\Money $listPrice
     * @param \patest\ArrayType\ArrayOfint $packageItemIds
     * @param \patest\ArrayType\ArrayOfAbstractPriceModifier $priceModifiers
     * @param \patest\StructType\Money $priceToPay
     * @param string $requestedAction
     * @param int $serviceSpecificHandle
     * @param \patest\StructType\ItemIdentity $supplierItemIdentity
     * @param \patest\StructType\Money $totalPrice
     * @param string $serviceSpecificId
     * @param bool $isIncomplete
     * @param \patest\ArrayType\ArrayOfFailureInformation $validationErrors
     * @param \patest\StructType\Money $effectiveListPrice
     * @param \patest\StructType\Money $regularPrice
     * @param \patest\StructType\Money $adjustedPriceToPay
     */
    public function __construct(\patest\StructType\Money $basePrice = null, $businessFlow = null, $clientId = null, $description = null, \patest\StructType\ExtraFields $extraFields = null, \patest\StructType\Money $facePrice = null, $insertionGroup = null, $insertionMode = null, $itemId = null, $itemType = null, \patest\StructType\Money $listPrice = null, \patest\ArrayType\ArrayOfint $packageItemIds = null, \patest\ArrayType\ArrayOfAbstractPriceModifier $priceModifiers = null, \patest\StructType\Money $priceToPay = null, $requestedAction = null, $serviceSpecificHandle = null, \patest\StructType\ItemIdentity $supplierItemIdentity = null, \patest\StructType\Money $totalPrice = null, $serviceSpecificId = null, $isIncomplete = null, \patest\ArrayType\ArrayOfFailureInformation $validationErrors = null, \patest\StructType\Money $effectiveListPrice = null, \patest\StructType\Money $regularPrice = null, \patest\StructType\Money $adjustedPriceToPay = null)
    {
        $this
            ->setBasePrice($basePrice)
            ->setBusinessFlow($businessFlow)
            ->setClientId($clientId)
            ->setDescription($description)
            ->setExtraFields($extraFields)
            ->setFacePrice($facePrice)
            ->setInsertionGroup($insertionGroup)
            ->setInsertionMode($insertionMode)
            ->setItemId($itemId)
            ->setItemType($itemType)
            ->setListPrice($listPrice)
            ->setPackageItemIds($packageItemIds)
            ->setPriceModifiers($priceModifiers)
            ->setPriceToPay($priceToPay)
            ->setRequestedAction($requestedAction)
            ->setServiceSpecificHandle($serviceSpecificHandle)
            ->setSupplierItemIdentity($supplierItemIdentity)
            ->setTotalPrice($totalPrice)
            ->setServiceSpecificId($serviceSpecificId)
            ->setIsIncomplete($isIncomplete)
            ->setValidationErrors($validationErrors)
            ->setEffectiveListPrice($effectiveListPrice)
            ->setRegularPrice($regularPrice)
            ->setAdjustedPriceToPay($adjustedPriceToPay);
    }
    /**
     * Get BasePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getBasePrice()
    {
        return isset($this->BasePrice) ? $this->BasePrice : null;
    }
    /**
     * Set BasePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $basePrice
     * @return \patest\StructType\AbstractItem
     */
    public function setBasePrice(\patest\StructType\Money $basePrice = null)
    {
        if (is_null($basePrice) || (is_array($basePrice) && empty($basePrice))) {
            unset($this->BasePrice);
        } else {
            $this->BasePrice = $basePrice;
        }
        return $this;
    }
    /**
     * Get BusinessFlow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessFlow()
    {
        return isset($this->BusinessFlow) ? $this->BusinessFlow : null;
    }
    /**
     * Set BusinessFlow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessFlow
     * @return \patest\StructType\AbstractItem
     */
    public function setBusinessFlow($businessFlow = null)
    {
        // validation for constraint: string
        if (!is_null($businessFlow) && !is_string($businessFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessFlow, true), gettype($businessFlow)), __LINE__);
        }
        if (is_null($businessFlow) || (is_array($businessFlow) && empty($businessFlow))) {
            unset($this->BusinessFlow);
        } else {
            $this->BusinessFlow = $businessFlow;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AbstractItem
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\AbstractItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExtraFields|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExtraFields $extraFields
     * @return \patest\StructType\AbstractItem
     */
    public function setExtraFields(\patest\StructType\ExtraFields $extraFields = null)
    {
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get FacePrice value
     * @return \patest\StructType\Money|null
     */
    public function getFacePrice()
    {
        return $this->FacePrice;
    }
    /**
     * Set FacePrice value
     * @param \patest\StructType\Money $facePrice
     * @return \patest\StructType\AbstractItem
     */
    public function setFacePrice(\patest\StructType\Money $facePrice = null)
    {
        $this->FacePrice = $facePrice;
        return $this;
    }
    /**
     * Get InsertionGroup value
     * @return int|null
     */
    public function getInsertionGroup()
    {
        return $this->InsertionGroup;
    }
    /**
     * Set InsertionGroup value
     * @param int $insertionGroup
     * @return \patest\StructType\AbstractItem
     */
    public function setInsertionGroup($insertionGroup = null)
    {
        // validation for constraint: int
        if (!is_null($insertionGroup) && !(is_int($insertionGroup) || ctype_digit($insertionGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insertionGroup, true), gettype($insertionGroup)), __LINE__);
        }
        $this->InsertionGroup = $insertionGroup;
        return $this;
    }
    /**
     * Get InsertionMode value
     * @return string|null
     */
    public function getInsertionMode()
    {
        return $this->InsertionMode;
    }
    /**
     * Set InsertionMode value
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\AbstractItem
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        $this->InsertionMode = $insertionMode;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\AbstractItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ItemType value
     * @return int|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param int $itemType
     * @return \patest\StructType\AbstractItem
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get ListPrice value
     * @return \patest\StructType\Money|null
     */
    public function getListPrice()
    {
        return $this->ListPrice;
    }
    /**
     * Set ListPrice value
     * @param \patest\StructType\Money $listPrice
     * @return \patest\StructType\AbstractItem
     */
    public function setListPrice(\patest\StructType\Money $listPrice = null)
    {
        $this->ListPrice = $listPrice;
        return $this;
    }
    /**
     * Get PackageItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getPackageItemIds()
    {
        return isset($this->PackageItemIds) ? $this->PackageItemIds : null;
    }
    /**
     * Set PackageItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $packageItemIds
     * @return \patest\StructType\AbstractItem
     */
    public function setPackageItemIds(\patest\ArrayType\ArrayOfint $packageItemIds = null)
    {
        if (is_null($packageItemIds) || (is_array($packageItemIds) && empty($packageItemIds))) {
            unset($this->PackageItemIds);
        } else {
            $this->PackageItemIds = $packageItemIds;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAbstractPriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAbstractPriceModifier $priceModifiers
     * @return \patest\StructType\AbstractItem
     */
    public function setPriceModifiers(\patest\ArrayType\ArrayOfAbstractPriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get PriceToPay value
     * @return \patest\StructType\Money|null
     */
    public function getPriceToPay()
    {
        return $this->PriceToPay;
    }
    /**
     * Set PriceToPay value
     * @param \patest\StructType\Money $priceToPay
     * @return \patest\StructType\AbstractItem
     */
    public function setPriceToPay(\patest\StructType\Money $priceToPay = null)
    {
        $this->PriceToPay = $priceToPay;
        return $this;
    }
    /**
     * Get RequestedAction value
     * @return string|null
     */
    public function getRequestedAction()
    {
        return $this->RequestedAction;
    }
    /**
     * Set RequestedAction value
     * @uses \patest\EnumType\ItemRequestedAction::valueIsValid()
     * @uses \patest\EnumType\ItemRequestedAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedAction
     * @return \patest\StructType\AbstractItem
     */
    public function setRequestedAction($requestedAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemRequestedAction::valueIsValid($requestedAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemRequestedAction', is_array($requestedAction) ? implode(', ', $requestedAction) : var_export($requestedAction, true), implode(', ', \patest\EnumType\ItemRequestedAction::getValidValues())), __LINE__);
        }
        $this->RequestedAction = $requestedAction;
        return $this;
    }
    /**
     * Get ServiceSpecificHandle value
     * @return int|null
     */
    public function getServiceSpecificHandle()
    {
        return $this->ServiceSpecificHandle;
    }
    /**
     * Set ServiceSpecificHandle value
     * @param int $serviceSpecificHandle
     * @return \patest\StructType\AbstractItem
     */
    public function setServiceSpecificHandle($serviceSpecificHandle = null)
    {
        // validation for constraint: int
        if (!is_null($serviceSpecificHandle) && !(is_int($serviceSpecificHandle) || ctype_digit($serviceSpecificHandle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceSpecificHandle, true), gettype($serviceSpecificHandle)), __LINE__);
        }
        $this->ServiceSpecificHandle = $serviceSpecificHandle;
        return $this;
    }
    /**
     * Get SupplierItemIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ItemIdentity|null
     */
    public function getSupplierItemIdentity()
    {
        return isset($this->SupplierItemIdentity) ? $this->SupplierItemIdentity : null;
    }
    /**
     * Set SupplierItemIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ItemIdentity $supplierItemIdentity
     * @return \patest\StructType\AbstractItem
     */
    public function setSupplierItemIdentity(\patest\StructType\ItemIdentity $supplierItemIdentity = null)
    {
        if (is_null($supplierItemIdentity) || (is_array($supplierItemIdentity) && empty($supplierItemIdentity))) {
            unset($this->SupplierItemIdentity);
        } else {
            $this->SupplierItemIdentity = $supplierItemIdentity;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\AbstractItem
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get ServiceSpecificId value
     * @return string|null
     */
    public function getServiceSpecificId()
    {
        return $this->ServiceSpecificId;
    }
    /**
     * Set ServiceSpecificId value
     * @param string $serviceSpecificId
     * @return \patest\StructType\AbstractItem
     */
    public function setServiceSpecificId($serviceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificId) && !is_string($serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificId, true), gettype($serviceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificId, true)), __LINE__);
        }
        $this->ServiceSpecificId = $serviceSpecificId;
        return $this;
    }
    /**
     * Get IsIncomplete value
     * @return bool|null
     */
    public function getIsIncomplete()
    {
        return $this->IsIncomplete;
    }
    /**
     * Set IsIncomplete value
     * @param bool $isIncomplete
     * @return \patest\StructType\AbstractItem
     */
    public function setIsIncomplete($isIncomplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncomplete) && !is_bool($isIncomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncomplete, true), gettype($isIncomplete)), __LINE__);
        }
        $this->IsIncomplete = $isIncomplete;
        return $this;
    }
    /**
     * Get ValidationErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfFailureInformation|null
     */
    public function getValidationErrors()
    {
        return isset($this->ValidationErrors) ? $this->ValidationErrors : null;
    }
    /**
     * Set ValidationErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfFailureInformation $validationErrors
     * @return \patest\StructType\AbstractItem
     */
    public function setValidationErrors(\patest\ArrayType\ArrayOfFailureInformation $validationErrors = null)
    {
        if (is_null($validationErrors) || (is_array($validationErrors) && empty($validationErrors))) {
            unset($this->ValidationErrors);
        } else {
            $this->ValidationErrors = $validationErrors;
        }
        return $this;
    }
    /**
     * Get EffectiveListPrice value
     * @return \patest\StructType\Money|null
     */
    public function getEffectiveListPrice()
    {
        return $this->EffectiveListPrice;
    }
    /**
     * Set EffectiveListPrice value
     * @param \patest\StructType\Money $effectiveListPrice
     * @return \patest\StructType\AbstractItem
     */
    public function setEffectiveListPrice(\patest\StructType\Money $effectiveListPrice = null)
    {
        $this->EffectiveListPrice = $effectiveListPrice;
        return $this;
    }
    /**
     * Get RegularPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRegularPrice()
    {
        return isset($this->RegularPrice) ? $this->RegularPrice : null;
    }
    /**
     * Set RegularPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $regularPrice
     * @return \patest\StructType\AbstractItem
     */
    public function setRegularPrice(\patest\StructType\Money $regularPrice = null)
    {
        if (is_null($regularPrice) || (is_array($regularPrice) && empty($regularPrice))) {
            unset($this->RegularPrice);
        } else {
            $this->RegularPrice = $regularPrice;
        }
        return $this;
    }
    /**
     * Get AdjustedPriceToPay value
     * @return \patest\StructType\Money|null
     */
    public function getAdjustedPriceToPay()
    {
        return $this->AdjustedPriceToPay;
    }
    /**
     * Set AdjustedPriceToPay value
     * @param \patest\StructType\Money $adjustedPriceToPay
     * @return \patest\StructType\AbstractItem
     */
    public function setAdjustedPriceToPay(\patest\StructType\Money $adjustedPriceToPay = null)
    {
        $this->AdjustedPriceToPay = $adjustedPriceToPay;
        return $this;
    }
}
