<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate ServiceType
 * @subpackage Services
 */
class Validate extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ValidateBarcode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateBarcode_Request $iAccessControlFacade_ValidateBarcode_RequestMsg
     * @return \patest\StructType\ValidateBarcode_Response|bool
     */
    public function ValidateBarcode(\patest\StructType\ValidateBarcode_Request $iAccessControlFacade_ValidateBarcode_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateBarcode($iAccessControlFacade_ValidateBarcode_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ValidateTransactionAccessControlData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateTransactionAccessControlDataRequest $iAccessControlFacade_ValidateTransactionAccessControlData_RequestMsg
     * @return \patest\StructType\ValidateTransactionAccessControlDataResponse|bool
     */
    public function ValidateTransactionAccessControlData(\patest\StructType\ValidateTransactionAccessControlDataRequest $iAccessControlFacade_ValidateTransactionAccessControlData_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateTransactionAccessControlData($iAccessControlFacade_ValidateTransactionAccessControlData_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateAddress
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateAddressRequest $iCrmFacade_ValidateAddress_RequestMsg
     * @return \patest\StructType\ValidateAddressResponse|bool
     */
    public function ValidateAddress(\patest\StructType\ValidateAddressRequest $iCrmFacade_ValidateAddress_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateAddress($iCrmFacade_ValidateAddress_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateContactDetail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateContactDetail_Request $iCrmFacade_ValidateContactDetail_RequestMsg
     * @return \patest\StructType\ValidateContactDetail_Response|bool
     */
    public function ValidateContactDetail(\patest\StructType\ValidateContactDetail_Request $iCrmFacade_ValidateContactDetail_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateContactDetail($iCrmFacade_ValidateContactDetail_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateBatchBeforeProcess
     * This method has been renamed because it is defined several times but with
     * different signature
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DonationValidateBatchBeforeProcessRequest $iDonationFacade_ValidateBatchBeforeProcess_RequestMsg
     * @return \patest\StructType\DonationValidateBatchBeforeProcessResponse|bool
     */
    public function ValidateBatchBeforeProcess(\patest\StructType\DonationValidateBatchBeforeProcessRequest $iDonationFacade_ValidateBatchBeforeProcess_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateBatchBeforeProcess($iDonationFacade_ValidateBatchBeforeProcess_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateAndAddBundleToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddBundleToBasket_Request $iEsroFacade_ValidateAndAddBundleToBasket_RequestMsg
     * @return \patest\StructType\ValidateAndAddBundleToBasketResponse|bool
     */
    public function ValidateAndAddBundleToBasket(\patest\StructType\AddBundleToBasket_Request $iEsroFacade_ValidateAndAddBundleToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateAndAddBundleToBasket($iEsroFacade_ValidateAndAddBundleToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateBatchBeforeProcess
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\MembershipValidateBatchBeforeProcessRequest $iMembershipFacade_ValidateBatchBeforeProcess_RequestMsg
     * @return \patest\StructType\MembershipValidateBatchBeforeProcessResponse|bool
     */
    public function ValidateBatchBeforeProcess_9905e58da5387f64870d1e0aa540532d(\patest\StructType\MembershipValidateBatchBeforeProcessRequest $iMembershipFacade_ValidateBatchBeforeProcess_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateBatchBeforeProcess($iMembershipFacade_ValidateBatchBeforeProcess_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateTransaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateTransaction_Request $iSaleFacade_ValidateTransaction_RequestMsg
     * @return \patest\StructType\ValidateTransaction_Response|bool
     */
    public function ValidateTransaction(\patest\StructType\ValidateTransaction_Request $iSaleFacade_ValidateTransaction_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateTransaction($iSaleFacade_ValidateTransaction_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateSelectedProductsForBundle
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateSelectedProductsForBundleRequest $iSaleFacade_ValidateSelectedProductsForBundle_RequestMsg
     * @return \patest\StructType\ValidateSelectedProductsForBundleResponse|bool
     */
    public function ValidateSelectedProductsForBundle(\patest\StructType\ValidateSelectedProductsForBundleRequest $iSaleFacade_ValidateSelectedProductsForBundle_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateSelectedProductsForBundle($iSaleFacade_ValidateSelectedProductsForBundle_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateJwtTokenForExternalService
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateJwtTokenForExternalService_Request $iSecurityFacade_ValidateJwtTokenForExternalService_RequestMsg
     * @return \patest\StructType\ValidateJwtTokenForExternalService_Response|bool
     */
    public function ValidateJwtTokenForExternalService(\patest\StructType\ValidateJwtTokenForExternalService_Request $iSecurityFacade_ValidateJwtTokenForExternalService_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateJwtTokenForExternalService($iSecurityFacade_ValidateJwtTokenForExternalService_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateBreakingHallDesignChanges
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateBreakingHallDesignChangesRequest $iTicketingFacade_ValidateBreakingHallDesignChanges_RequestMsg
     * @return \patest\StructType\ValidateBreakingHallDesignChangesResponse|bool
     */
    public function ValidateBreakingHallDesignChanges(\patest\StructType\ValidateBreakingHallDesignChangesRequest $iTicketingFacade_ValidateBreakingHallDesignChanges_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateBreakingHallDesignChanges($iTicketingFacade_ValidateBreakingHallDesignChanges_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ValidateForClientContainedInAnotherBallotApplication
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateForClientContainedInAnotherBallotApplicationRequest $iTicketingFacade_ValidateForClientContainedInAnotherBallotApplication_RequestMsg
     * @return \patest\StructType\ValidateForClientContainedInAnotherBallotApplicationResponse|bool
     */
    public function ValidateForClientContainedInAnotherBallotApplication(\patest\StructType\ValidateForClientContainedInAnotherBallotApplicationRequest $iTicketingFacade_ValidateForClientContainedInAnotherBallotApplication_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateForClientContainedInAnotherBallotApplication($iTicketingFacade_ValidateForClientContainedInAnotherBallotApplication_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ValidateForAnyClientsContainedInAnotherBallotApplication
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ValidateForAnyClientsContainedInAnotherBallotApplicationRequest $iTicketingFacade_ValidateForAnyClientsContainedInAnotherBallotApplication_RequestMsg
     * @return \patest\StructType\ValidateForAnyClientsContainedInAnotherBallotApplicationResponse|bool
     */
    public function ValidateForAnyClientsContainedInAnotherBallotApplication(\patest\StructType\ValidateForAnyClientsContainedInAnotherBallotApplicationRequest $iTicketingFacade_ValidateForAnyClientsContainedInAnotherBallotApplication_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateForAnyClientsContainedInAnotherBallotApplication($iTicketingFacade_ValidateForAnyClientsContainedInAnotherBallotApplication_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ValidateWithdrawPendingTransferTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\_x0020_WithdrawPendingTransferTickets_Request $iTicketingFacade_ValidateWithdrawPendingTransferTickets_RequestMsg
     * @return \patest\StructType\ValidateWithdrawPendingTransferTickets_Response|bool
     */
    public function ValidateWithdrawPendingTransferTickets(\patest\StructType\_x0020_WithdrawPendingTransferTickets_Request $iTicketingFacade_ValidateWithdrawPendingTransferTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidateWithdrawPendingTransferTickets($iTicketingFacade_ValidateWithdrawPendingTransferTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\DonationValidateBatchBeforeProcessResponse|\patest\StructType\MembershipValidateBatchBeforeProcessResponse|\patest\StructType\ValidateAddressResponse|\patest\StructType\ValidateAndAddBundleToBasketResponse|\patest\StructType\ValidateBarcode_Response|\patest\StructType\ValidateBreakingHallDesignChangesResponse|\patest\StructType\ValidateContactDetail_Response|\patest\StructType\ValidateForAnyClientsContainedInAnotherBallotApplicationResponse|\patest\StructType\ValidateForClientContainedInAnotherBallotApplicationResponse|\patest\StructType\ValidateJwtTokenForExternalService_Response|\patest\StructType\ValidateSelectedProductsForBundleResponse|\patest\StructType\ValidateTransactionAccessControlDataResponse|\patest\StructType\ValidateTransaction_Response|\patest\StructType\ValidateWithdrawPendingTransferTickets_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
