<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SetUniversalFlag
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetUniversalFlagRequest $iFoundationService_SetUniversalFlag_RequestMsg
     * @return \patest\StructType\SetUniversalFlagResponse|bool
     */
    public function SetUniversalFlag(\patest\StructType\SetUniversalFlagRequest $iFoundationService_SetUniversalFlag_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetUniversalFlag($iFoundationService_SetUniversalFlag_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSubscriptionExtraEvents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetSubscriptionExtraEventsRequest $iEsroFacade_SetSubscriptionExtraEvents_RequestMsg
     * @return \patest\StructType\SetSubscriptionExtraEventsResponse|bool
     */
    public function SetSubscriptionExtraEvents(\patest\StructType\SetSubscriptionExtraEventsRequest $iEsroFacade_SetSubscriptionExtraEvents_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSubscriptionExtraEvents($iEsroFacade_SetSubscriptionExtraEvents_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetPrintOptionsForBasketSale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetPrintOptionsForBasketSale_Request $iPrintingFacade_SetPrintOptionsForBasketSale_RequestMsg
     * @return \patest\StructType\SetPrintOptionsForBasketSale_Response|bool
     */
    public function SetPrintOptionsForBasketSale(\patest\StructType\SetPrintOptionsForBasketSale_Request $iPrintingFacade_SetPrintOptionsForBasketSale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetPrintOptionsForBasketSale($iPrintingFacade_SetPrintOptionsForBasketSale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetPrintOptionsForBasketSalesBatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetPrintOptionsForBasketSalesBatch_Request $iPrintingFacade_SetPrintOptionsForBasketSalesBatch_RequestMsg
     * @return \patest\StructType\SetPrintOptionsForBasketSalesBatch_Response|bool
     */
    public function SetPrintOptionsForBasketSalesBatch(\patest\StructType\SetPrintOptionsForBasketSalesBatch_Request $iPrintingFacade_SetPrintOptionsForBasketSalesBatch_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetPrintOptionsForBasketSalesBatch($iPrintingFacade_SetPrintOptionsForBasketSalesBatch_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SetPrintOptionsForFollowUpBasketPrint
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetPrintOptionsForFollowUpBasketPrint_Request $iPrintingFacade_SetPrintOptionsForFollowUpBasketPrint_RequestMsg
     * @return \patest\StructType\SetPrintOptionsForFollowUpBasketPrint_Response|bool
     */
    public function SetPrintOptionsForFollowUpBasketPrint(\patest\StructType\SetPrintOptionsForFollowUpBasketPrint_Request $iPrintingFacade_SetPrintOptionsForFollowUpBasketPrint_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetPrintOptionsForFollowUpBasketPrint($iPrintingFacade_SetPrintOptionsForFollowUpBasketPrint_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSecurityRole
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetSecurityRole_Request $iSecurityFacade_SetSecurityRole_RequestMsg
     * @return \patest\StructType\SetSecurityRole_Response|bool
     */
    public function SetSecurityRole(\patest\StructType\SetSecurityRole_Request $iSecurityFacade_SetSecurityRole_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSecurityRole($iSecurityFacade_SetSecurityRole_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetUserApplicationPreference
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetUserApplicationPreference_Request $iSecurityFacade_SetUserApplicationPreference_RequestMsg
     * @return \patest\StructType\SetUserApplicationPreferenceResponse_Response|bool
     */
    public function SetUserApplicationPreference(\patest\StructType\SetUserApplicationPreference_Request $iSecurityFacade_SetUserApplicationPreference_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetUserApplicationPreference($iSecurityFacade_SetUserApplicationPreference_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SetTicketSchemeEnrollmentsOfBasketSubscriptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest $iSubscriptionFacade_SetTicketSchemeEnrollmentsOfBasketSubscriptions_RequestMsg
     * @return \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsResponse|bool
     */
    public function SetTicketSchemeEnrollmentsOfBasketSubscriptions(\patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest $iSubscriptionFacade_SetTicketSchemeEnrollmentsOfBasketSubscriptions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetTicketSchemeEnrollmentsOfBasketSubscriptions($iSubscriptionFacade_SetTicketSchemeEnrollmentsOfBasketSubscriptions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetHospitalityTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetHospitalityTickets_Request $iTicketingFacade_SetHospitalityTickets_RequestMsg
     * @return \patest\StructType\SetHospitalityTickets_Response|bool
     */
    public function SetHospitalityTickets(\patest\StructType\SetHospitalityTickets_Request $iTicketingFacade_SetHospitalityTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetHospitalityTickets($iTicketingFacade_SetHospitalityTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetHospitalitySubscriptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SetHospitalitySubscriptions_Request $iTicketingFacade_SetHospitalitySubscriptions_RequestMsg
     * @return \patest\StructType\SetHospitalitySubscriptions_Response|bool
     */
    public function SetHospitalitySubscriptions(\patest\StructType\SetHospitalitySubscriptions_Request $iTicketingFacade_SetHospitalitySubscriptions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SetHospitalitySubscriptions($iTicketingFacade_SetHospitalitySubscriptions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\SetHospitalitySubscriptions_Response|\patest\StructType\SetHospitalityTickets_Response|\patest\StructType\SetPrintOptionsForBasketSalesBatch_Response|\patest\StructType\SetPrintOptionsForBasketSale_Response|\patest\StructType\SetPrintOptionsForFollowUpBasketPrint_Response|\patest\StructType\SetSecurityRole_Response|\patest\StructType\SetSubscriptionExtraEventsResponse|\patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsResponse|\patest\StructType\SetUniversalFlagResponse|\patest\StructType\SetUserApplicationPreferenceResponse_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
