<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Report ServiceType
 * @subpackage Services
 */
class Report extends AbstractSoapClientBase
{
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReportExternalBarcodeUsages
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ReportExternalBarcodeUsagesRequest $iAccessControlFacade_ReportExternalBarcodeUsages_RequestMsg
     * @return \patest\StructType\ReportExternalBarcodeUsagesResponse|bool
     */
    public function ReportExternalBarcodeUsages(\patest\StructType\ReportExternalBarcodeUsagesRequest $iAccessControlFacade_ReportExternalBarcodeUsages_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ReportExternalBarcodeUsages($iAccessControlFacade_ReportExternalBarcodeUsages_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportOfflineScanBarcodeUsages
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ReportOfflineScanBarcodeUsagesRequest $iAccessControlFacade_ReportOfflineScanBarcodeUsages_RequestMsg
     * @return \patest\StructType\ReportOfflineScanBarcodeUsagesResponse|bool
     */
    public function ReportOfflineScanBarcodeUsages(\patest\StructType\ReportOfflineScanBarcodeUsagesRequest $iAccessControlFacade_ReportOfflineScanBarcodeUsages_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ReportOfflineScanBarcodeUsages($iAccessControlFacade_ReportOfflineScanBarcodeUsages_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\ReportExternalBarcodeUsagesResponse|\patest\StructType\ReportOfflineScanBarcodeUsagesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
