<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RemoveUniversalFlag
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RemoveUniversalFlagRequest $iFoundationService_RemoveUniversalFlag_RequestMsg
     * @return \patest\StructType\RemoveUniversalFlagResponse|bool
     */
    public function RemoveUniversalFlag(\patest\StructType\RemoveUniversalFlagRequest $iFoundationService_RemoveUniversalFlag_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveUniversalFlag($iFoundationService_RemoveUniversalFlag_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveClient
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RemoveClientRequest $iCrmFacade_RemoveClient_RequestMsg
     * @return \patest\StructType\RemoveClientResponse|bool
     */
    public function RemoveClient(\patest\StructType\RemoveClientRequest $iCrmFacade_RemoveClient_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveClient($iCrmFacade_RemoveClient_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveClientTypeFromClients
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RemoveClientTypeFromClientsRequest $iCrmFacade_RemoveClientTypeFromClients_RequestMsg
     * @return \patest\StructType\RemoveClientTypeFromClientsResponse|bool
     */
    public function RemoveClientTypeFromClients(\patest\StructType\RemoveClientTypeFromClientsRequest $iCrmFacade_RemoveClientTypeFromClients_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveClientTypeFromClients($iCrmFacade_RemoveClientTypeFromClients_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveTicketsFromBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RemoveTicketsFromBasket_Request $iTicketingFacade_RemoveTicketsFromBasket_RequestMsg
     * @return \patest\StructType\RemoveTicketsFromBasket_Response|bool
     */
    public function RemoveTicketsFromBasket(\patest\StructType\RemoveTicketsFromBasket_Request $iTicketingFacade_RemoveTicketsFromBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveTicketsFromBasket($iTicketingFacade_RemoveTicketsFromBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveCustomSeatPrices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RemoveCustomSeatPricesRequest $iTicketingFacade_RemoveCustomSeatPrices_RequestMsg
     * @return \patest\StructType\RemoveCustomSeatPricesResponse|bool
     */
    public function RemoveCustomSeatPrices(\patest\StructType\RemoveCustomSeatPricesRequest $iTicketingFacade_RemoveCustomSeatPrices_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveCustomSeatPrices($iTicketingFacade_RemoveCustomSeatPrices_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\RemoveClientResponse|\patest\StructType\RemoveClientTypeFromClientsResponse|\patest\StructType\RemoveCustomSeatPricesResponse|\patest\StructType\RemoveTicketsFromBasket_Response|\patest\StructType\RemoveUniversalFlagResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
