<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Re ServiceType
 * @subpackage Services
 */
class Re extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReLockOrAllocateSubscriptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ReLockOrAllocateSubscriptions_Request $iSubscriptionFacade_ReLockOrAllocateSubscriptions_RequestMsg
     * @return \patest\StructType\ReLockOrAllocateSubscriptions_Response|bool
     */
    public function ReLockOrAllocateSubscriptions(\patest\StructType\ReLockOrAllocateSubscriptions_Request $iSubscriptionFacade_ReLockOrAllocateSubscriptions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ReLockOrAllocateSubscriptions($iSubscriptionFacade_ReLockOrAllocateSubscriptions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReLockTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ReLockTickets_Request $iTicketingFacade_ReLockTickets_RequestMsg
     * @return \patest\StructType\ReLockTickets_Response|bool
     */
    public function ReLockTickets(\patest\StructType\ReLockTickets_Request $iTicketingFacade_ReLockTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ReLockTickets($iTicketingFacade_ReLockTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReLockOrAllocateTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ReLockOrAllocateTickets_Request $iTicketingFacade_ReLockOrAllocateTickets_RequestMsg
     * @return \patest\StructType\ReLockOrAllocateTickets_Response|bool
     */
    public function ReLockOrAllocateTickets(\patest\StructType\ReLockOrAllocateTickets_Request $iTicketingFacade_ReLockOrAllocateTickets_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ReLockOrAllocateTickets($iTicketingFacade_ReLockOrAllocateTickets_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\ReLockOrAllocateSubscriptions_Response|\patest\StructType\ReLockOrAllocateTickets_Response|\patest\StructType\ReLockTickets_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
