<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prepare ServiceType
 * @subpackage Services
 */
class Prepare extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named PrepareBizActionRequest
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\PrepareBizActionRequestRequest $iFoundationService_PrepareBizActionRequest_RequestMsg
     * @return \patest\StructType\PrepareBizActionRequestResponse|bool
     */
    public function PrepareBizActionRequest(\patest\StructType\PrepareBizActionRequestRequest $iFoundationService_PrepareBizActionRequest_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareBizActionRequest($iFoundationService_PrepareBizActionRequest_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PrepareInitiateSubscriptionsRenewalRequest
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest $iSubscriptionFacade_PrepareInitiateSubscriptionsRenewalRequest_RequestMsg
     * @return \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestResponse|bool
     */
    public function PrepareInitiateSubscriptionsRenewalRequest(\patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest $iSubscriptionFacade_PrepareInitiateSubscriptionsRenewalRequest_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareInitiateSubscriptionsRenewalRequest($iSubscriptionFacade_PrepareInitiateSubscriptionsRenewalRequest_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PrepareEffectiveAvailabilityFilterToken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\PrepareEffectiveAvailabilityFilterTokenRequest $iTicketingFacade_PrepareEffectiveAvailabilityFilterToken_RequestMsg
     * @return \patest\StructType\PrepareEffectiveAvailabilityFilterTokenResponse|bool
     */
    public function PrepareEffectiveAvailabilityFilterToken(\patest\StructType\PrepareEffectiveAvailabilityFilterTokenRequest $iTicketingFacade_PrepareEffectiveAvailabilityFilterToken_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareEffectiveAvailabilityFilterToken($iTicketingFacade_PrepareEffectiveAvailabilityFilterToken_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PrepareAvailabilityFilterForHospitality
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\PrepareAvailabilityFilterForHospitalityRequest $iTicketingFacade_PrepareAvailabilityFilterForHospitality_RequestMsg
     * @return \patest\StructType\PrepareAvailabilityFilterForHospitalityResponse|bool
     */
    public function PrepareAvailabilityFilterForHospitality(\patest\StructType\PrepareAvailabilityFilterForHospitalityRequest $iTicketingFacade_PrepareAvailabilityFilterForHospitality_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareAvailabilityFilterForHospitality($iTicketingFacade_PrepareAvailabilityFilterForHospitality_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PrepareEventAvailabilityFilterForCoupon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\PrepareEventAvailabilityFilterForCouponRequest $iTicketingFacade_PrepareEventAvailabilityFilterForCoupon_RequestMsg
     * @return \patest\StructType\PrepareEventAvailabilityFilterForCouponResponse|bool
     */
    public function PrepareEventAvailabilityFilterForCoupon(\patest\StructType\PrepareEventAvailabilityFilterForCouponRequest $iTicketingFacade_PrepareEventAvailabilityFilterForCoupon_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareEventAvailabilityFilterForCoupon($iTicketingFacade_PrepareEventAvailabilityFilterForCoupon_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PrepareSeriesAvailabilityFilterForCoupon
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\PrepareSeriesAvailabilityFilterForCouponRequest $iTicketingFacade_PrepareSeriesAvailabilityFilterForCoupon_RequestMsg
     * @return \patest\StructType\PrepareSeriesAvailabilityFilterForCouponResponse|bool
     */
    public function PrepareSeriesAvailabilityFilterForCoupon(\patest\StructType\PrepareSeriesAvailabilityFilterForCouponRequest $iTicketingFacade_PrepareSeriesAvailabilityFilterForCoupon_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareSeriesAvailabilityFilterForCoupon($iTicketingFacade_PrepareSeriesAvailabilityFilterForCoupon_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PrepareAvailabilityFilterForBundleElement
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\PrepareAvailabilityFilterForBundleElementRequest $iTicketingFacade_PrepareAvailabilityFilterForBundleElement_RequestMsg
     * @return \patest\StructType\PrepareAvailabilityFilterForBundleElementResponse|bool
     */
    public function PrepareAvailabilityFilterForBundleElement(\patest\StructType\PrepareAvailabilityFilterForBundleElementRequest $iTicketingFacade_PrepareAvailabilityFilterForBundleElement_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareAvailabilityFilterForBundleElement($iTicketingFacade_PrepareAvailabilityFilterForBundleElement_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\PrepareAvailabilityFilterForBundleElementResponse|\patest\StructType\PrepareAvailabilityFilterForHospitalityResponse|\patest\StructType\PrepareBizActionRequestResponse|\patest\StructType\PrepareEffectiveAvailabilityFilterTokenResponse|\patest\StructType\PrepareEventAvailabilityFilterForCouponResponse|\patest\StructType\PrepareInitiateSubscriptionsRenewalRequestResponse|\patest\StructType\PrepareSeriesAvailabilityFilterForCouponResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
