<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Log ServiceType
 * @subpackage Services
 */
class Log extends AbstractSoapClientBase
{
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named LogBanner
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\LogBannerRequest $iTenantAdministrationService_LogBanner_RequestMsg
     * @return \patest\StructType\LogBannerResponse|bool
     */
    public function LogBanner(\patest\StructType\LogBannerRequest $iTenantAdministrationService_LogBanner_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->LogBanner($iTenantAdministrationService_LogBanner_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LogIntoOrganizationUnit
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\LogIntoOrganizationUnit_Request $iSecurityFacade_LogIntoOrganizationUnit_RequestMsg
     * @return \patest\StructType\LogIntoOrganizationUnit_Response|bool
     */
    public function LogIntoOrganizationUnit(\patest\StructType\LogIntoOrganizationUnit_Request $iSecurityFacade_LogIntoOrganizationUnit_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->LogIntoOrganizationUnit($iSecurityFacade_LogIntoOrganizationUnit_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * LogWithdrawPendingTransferTicketsDetails
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\WithdrawPendingTransferTicketsDetails_Request $iTicketingFacade_LogWithdrawPendingTransferTicketsDetails_RequestMsg
     * @return \patest\StructType\LogWithdrawPendingTransferTicketsDetails_Response|bool
     */
    public function LogWithdrawPendingTransferTicketsDetails(\patest\StructType\WithdrawPendingTransferTicketsDetails_Request $iTicketingFacade_LogWithdrawPendingTransferTicketsDetails_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->LogWithdrawPendingTransferTicketsDetails($iTicketingFacade_LogWithdrawPendingTransferTicketsDetails_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LogCancelPartyByTicketIdsDetails
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CancelPartyByTicketIdsDetails_Request $iTicketingFacade_LogCancelPartyByTicketIdsDetails_RequestMsg
     * @return \patest\StructType\LogCancelPartyByTicketIdsDetails_Response|bool
     */
    public function LogCancelPartyByTicketIdsDetails(\patest\StructType\CancelPartyByTicketIdsDetails_Request $iTicketingFacade_LogCancelPartyByTicketIdsDetails_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->LogCancelPartyByTicketIdsDetails($iTicketingFacade_LogCancelPartyByTicketIdsDetails_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\LogBannerResponse|\patest\StructType\LogCancelPartyByTicketIdsDetails_Response|\patest\StructType\LogIntoOrganizationUnit_Response|\patest\StructType\LogWithdrawPendingTransferTicketsDetails_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
