<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @subpackage Services
 */
class Generate extends AbstractSoapClientBase
{
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GenerateOTP
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GenerateOTP_Request $iAuthenticationFacade_GenerateOTP_RequestMsg
     * @return \patest\StructType\GenerateOTP_Response|bool
     */
    public function GenerateOTP(\patest\StructType\GenerateOTP_Request $iAuthenticationFacade_GenerateOTP_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateOTP($iAuthenticationFacade_GenerateOTP_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateBarcodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GenerateBarcodes_Request $iPrintingFacade_GenerateBarcodes_RequestMsg
     * @return \patest\StructType\GenerateBarcodes_Response|bool
     */
    public function GenerateBarcodes(\patest\StructType\GenerateBarcodes_Request $iPrintingFacade_GenerateBarcodes_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateBarcodes($iPrintingFacade_GenerateBarcodes_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GenerateBarcodesAsync
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\GenerateBarcodesAsync_Request $iPrintingFacade_GenerateBarcodesAsync_RequestMsg
     * @return \patest\StructType\GenerateBarcodesAsync_Response|bool
     */
    public function GenerateBarcodesAsync(\patest\StructType\GenerateBarcodesAsync_Request $iPrintingFacade_GenerateBarcodesAsync_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateBarcodesAsync($iPrintingFacade_GenerateBarcodesAsync_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\GenerateBarcodesAsync_Response|\patest\StructType\GenerateBarcodes_Response|\patest\StructType\GenerateOTP_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
