<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Connect ServiceType
 * @subpackage Services
 */
class Connect extends AbstractSoapClientBase
{
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Connect
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\Connect_Request $iSecurityFacade_Connect_RequestMsg
     * @return \patest\StructType\Connect_Response|bool
     */
    public function Connect(\patest\StructType\Connect_Request $iSecurityFacade_Connect_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Connect($iSecurityFacade_Connect_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConnectWithJWT
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ConnectWithJWT_Request $iSecurityFacade_ConnectWithJWT_RequestMsg
     * @return \patest\StructType\Connect_Response|bool
     */
    public function ConnectWithJWT(\patest\StructType\ConnectWithJWT_Request $iSecurityFacade_ConnectWithJWT_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ConnectWithJWT($iSecurityFacade_ConnectWithJWT_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConnectWithOTP
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ConnectWithOTP_Request $iSecurityFacade_ConnectWithOTP_RequestMsg
     * @return \patest\StructType\Connect_Response|bool
     */
    public function ConnectWithOTP(\patest\StructType\ConnectWithOTP_Request $iSecurityFacade_ConnectWithOTP_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ConnectWithOTP($iSecurityFacade_ConnectWithOTP_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConnectWithContextToken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ConnectWithContextToken_Request $iSecurityFacade_ConnectWithContextToken_RequestMsg
     * @return \patest\StructType\Connect_Response|bool
     */
    public function ConnectWithContextToken(\patest\StructType\ConnectWithContextToken_Request $iSecurityFacade_ConnectWithContextToken_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ConnectWithContextToken($iSecurityFacade_ConnectWithContextToken_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\Connect_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
