<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Confirm ServiceType
 * @subpackage Services
 */
class Confirm extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ConfirmDataRecieval
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ConfirmDataReceivedRequest $iDataDistributionService_ConfirmDataRecieval_RequestMsg
     * @return \patest\StructType\ConfirmDataReceivedResponse|bool
     */
    public function ConfirmDataRecieval(\patest\StructType\ConfirmDataReceivedRequest $iDataDistributionService_ConfirmDataRecieval_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ConfirmDataRecieval($iDataDistributionService_ConfirmDataRecieval_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConfirmBasketItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ConfirmBasketItems_Request $iSaleFacade_ConfirmBasketItems_RequestMsg
     * @return \patest\StructType\ConfirmBasketItems_Response|bool
     */
    public function ConfirmBasketItems(\patest\StructType\ConfirmBasketItems_Request $iSaleFacade_ConfirmBasketItems_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ConfirmBasketItems($iSaleFacade_ConfirmBasketItems_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\ConfirmBasketItems_Response|\patest\StructType\ConfirmDataReceivedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
