<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CancelDeduct
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CancelDeductRequest $iSaleFacade_CancelDeduct_RequestMsg
     * @return \patest\StructType\CancelDeductResponse|bool
     */
    public function CancelDeduct(\patest\StructType\CancelDeductRequest $iSaleFacade_CancelDeduct_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelDeduct($iSaleFacade_CancelDeduct_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelEventReservations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CancelEventReservations_Request $iTicketingFacade_CancelEventReservations_RequestMsg
     * @return \patest\StructType\CancelEventReservations_Response|bool
     */
    public function CancelEventReservations(\patest\StructType\CancelEventReservations_Request $iTicketingFacade_CancelEventReservations_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelEventReservations($iTicketingFacade_CancelEventReservations_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelResaleTransferTransactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CancelResaleTransferTransactionsRequest_Request $iTicketingFacade_CancelResaleTransferTransactions_RequestMsg
     * @return \patest\StructType\CancelResaleTransferTransactionsResponse_Response|bool
     */
    public function CancelResaleTransferTransactions(\patest\StructType\CancelResaleTransferTransactionsRequest_Request $iTicketingFacade_CancelResaleTransferTransactions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelResaleTransferTransactions($iTicketingFacade_CancelResaleTransferTransactions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelReservationsInTicketScheme
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CancelReservationsInTicketScheme_Request $iTicketingFacade_CancelReservationsInTicketScheme_RequestMsg
     * @return \patest\StructType\CancelReservationsInTicketScheme_Response|bool
     */
    public function CancelReservationsInTicketScheme(\patest\StructType\CancelReservationsInTicketScheme_Request $iTicketingFacade_CancelReservationsInTicketScheme_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelReservationsInTicketScheme($iTicketingFacade_CancelReservationsInTicketScheme_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelPartyByTicketIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CancelPartyByTicketIds_Request $iTicketingFacade_CancelPartyByTicketIds_RequestMsg
     * @return \patest\StructType\CancelPartyByTicketIds_Response|bool
     */
    public function CancelPartyByTicketIds(\patest\StructType\CancelPartyByTicketIds_Request $iTicketingFacade_CancelPartyByTicketIds_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelPartyByTicketIds($iTicketingFacade_CancelPartyByTicketIds_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\CancelDeductResponse|\patest\StructType\CancelEventReservations_Response|\patest\StructType\CancelPartyByTicketIds_Response|\patest\StructType\CancelResaleTransferTransactionsResponse_Response|\patest\StructType\CancelReservationsInTicketScheme_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
