<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * AddEntityManagementQueryTokenContext
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddEntityManagementQueryTokenContextRequest $iFoundationService_AddEntityManagementQueryTokenContext_RequestMsg
     * @return \patest\StructType\AddEntityManagementQueryTokenContextResponse|bool
     */
    public function AddEntityManagementQueryTokenContext(\patest\StructType\AddEntityManagementQueryTokenContextRequest $iFoundationService_AddEntityManagementQueryTokenContext_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddEntityManagementQueryTokenContext($iFoundationService_AddEntityManagementQueryTokenContext_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddGuidanceToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddGuidanceToBasketRequest $iBizResourceFacade_AddGuidanceToBasket_RequestMsg
     * @return \patest\StructType\AddGuidanceToBasketResponse|bool
     */
    public function AddGuidanceToBasket(\patest\StructType\AddGuidanceToBasketRequest $iBizResourceFacade_AddGuidanceToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddGuidanceToBasket($iBizResourceFacade_AddGuidanceToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTicketSchemeEnrollments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddTicketSchemeEnrollments_Request $iCrmFacade_AddTicketSchemeEnrollments_RequestMsg
     * @return \patest\StructType\AddTicketSchemeEnrollments_Response|bool
     */
    public function AddTicketSchemeEnrollments(\patest\StructType\AddTicketSchemeEnrollments_Request $iCrmFacade_AddTicketSchemeEnrollments_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddTicketSchemeEnrollments($iCrmFacade_AddTicketSchemeEnrollments_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDeliveryToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddDeliveryToBasket_Request $iDeliveryFacade_AddDeliveryToBasket_RequestMsg
     * @return \patest\StructType\AddDeliveryToBasket_Response|bool
     */
    public function AddDeliveryToBasket(\patest\StructType\AddDeliveryToBasket_Request $iDeliveryFacade_AddDeliveryToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDeliveryToBasket($iDeliveryFacade_AddDeliveryToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDonationToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddDonationToBasket_Request $iDonationFacade_AddDonationToBasket_RequestMsg
     * @return \patest\StructType\AddDonationToBasket_Response|bool
     */
    public function AddDonationToBasket(\patest\StructType\AddDonationToBasket_Request $iDonationFacade_AddDonationToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDonationToBasket($iDonationFacade_AddDonationToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddLinkedClient
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddLinkedClientRequest $iEsroFacade_AddLinkedClient_RequestMsg
     * @return \patest\StructType\AddLinkedClientResponse|bool
     */
    public function AddLinkedClient(\patest\StructType\AddLinkedClientRequest $iEsroFacade_AddLinkedClient_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddLinkedClient($iEsroFacade_AddLinkedClient_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddClientLink
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddClientLinkRequest $iEsroFacade_AddClientLink_RequestMsg
     * @return \patest\StructType\AddLinkedClientResponse|bool
     */
    public function AddClientLink(\patest\StructType\AddClientLinkRequest $iEsroFacade_AddClientLink_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddClientLink($iEsroFacade_AddClientLink_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCardLoadingToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddCardLoadingToBasketRequest $iGiftCardFacade_AddCardLoadingToBasket_RequestMsg
     * @return \patest\StructType\AddCardLoadingToBasketResponse|bool
     */
    public function AddCardLoadingToBasket(\patest\StructType\AddCardLoadingToBasketRequest $iGiftCardFacade_AddCardLoadingToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCardLoadingToBasket($iGiftCardFacade_AddCardLoadingToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddGiftVouchersToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddGiftVouchersToBasket_Request $iGiftVoucherFacade_AddGiftVouchersToBasket_RequestMsg
     * @return \patest\StructType\AddGiftVouchersToBasket_Response|bool
     */
    public function AddGiftVouchersToBasket(\patest\StructType\AddGiftVouchersToBasket_Request $iGiftVoucherFacade_AddGiftVouchersToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddGiftVouchersToBasket($iGiftVoucherFacade_AddGiftVouchersToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMembershipsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddMembershipsToBasket_Request $iMembershipFacade_AddMembershipsToBasket_RequestMsg
     * @return \patest\StructType\AddMembershipsToBasket_Response|bool
     */
    public function AddMembershipsToBasket(\patest\StructType\AddMembershipsToBasket_Request $iMembershipFacade_AddMembershipsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddMembershipsToBasket($iMembershipFacade_AddMembershipsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMerchandisesToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddMerchandiseToBasket_Request $iMerchandiseFacade_AddMerchandisesToBasket_RequestMsg
     * @return \patest\StructType\AddMerchandiseToBasket_Response|bool
     */
    public function AddMerchandisesToBasket(\patest\StructType\AddMerchandiseToBasket_Request $iMerchandiseFacade_AddMerchandisesToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddMerchandisesToBasket($iMerchandiseFacade_AddMerchandisesToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddPaymentToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddPaymentToBasket_Request $iPaymentFacade_AddPaymentToBasket_RequestMsg
     * @return \patest\StructType\AddPaymentToBasket_Response|bool
     */
    public function AddPaymentToBasket(\patest\StructType\AddPaymentToBasket_Request $iPaymentFacade_AddPaymentToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPaymentToBasket($iPaymentFacade_AddPaymentToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCancellationPaymentToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddCancellationPaymentToBasket_Request $iPaymentFacade_AddCancellationPaymentToBasket_RequestMsg
     * @return \patest\StructType\AddCancellationPaymentToBasket_Response|bool
     */
    public function AddCancellationPaymentToBasket(\patest\StructType\AddCancellationPaymentToBasket_Request $iPaymentFacade_AddCancellationPaymentToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCancellationPaymentToBasket($iPaymentFacade_AddCancellationPaymentToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddClientCreditToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddClientCredit_Request $iPaymentFacade_AddClientCreditToBasket_RequestMsg
     * @return \patest\StructType\AddClientCredit_Response|bool
     */
    public function AddClientCreditToBasket(\patest\StructType\AddClientCredit_Request $iPaymentFacade_AddClientCreditToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddClientCreditToBasket($iPaymentFacade_AddClientCreditToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdHocRefundToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddAdHocRefundToBasket_Request $iPaymentFacade_AddAdHocRefundToBasket_RequestMsg
     * @return \patest\StructType\AddAdHocRefundToBasket_Response|bool
     */
    public function AddAdHocRefundToBasket(\patest\StructType\AddAdHocRefundToBasket_Request $iPaymentFacade_AddAdHocRefundToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdHocRefundToBasket($iPaymentFacade_AddAdHocRefundToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddProductsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddProductsToBasketRequest $iSaleFacade_AddProductsToBasket_RequestMsg
     * @return \patest\StructType\AddProductsToBasketResponse|bool
     */
    public function AddProductsToBasket(\patest\StructType\AddProductsToBasketRequest $iSaleFacade_AddProductsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddProductsToBasket($iSaleFacade_AddProductsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddBundleToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddBundleToBasket_Request $iSaleFacade_AddBundleToBasket_RequestMsg
     * @return \patest\StructType\AddBundleToBasket_Response|bool
     */
    public function AddBundleToBasket(\patest\StructType\AddBundleToBasket_Request $iSaleFacade_AddBundleToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddBundleToBasket($iSaleFacade_AddBundleToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddPromptExtraProductsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddPromptExtraProductsToBasket_Request $iSaleFacade_AddPromptExtraProductsToBasket_RequestMsg
     * @return \patest\StructType\AddPromptExtraProductsToBasket_Response|bool
     */
    public function AddPromptExtraProductsToBasket(\patest\StructType\AddPromptExtraProductsToBasket_Request $iSaleFacade_AddPromptExtraProductsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPromptExtraProductsToBasket($iSaleFacade_AddPromptExtraProductsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDebtPaymentToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddDebtPaymentToBasketRequest $iSaleFacade_AddDebtPaymentToBasket_RequestMsg
     * @return \patest\StructType\AddDebtPaymentToBasketResponse|bool
     */
    public function AddDebtPaymentToBasket(\patest\StructType\AddDebtPaymentToBasketRequest $iSaleFacade_AddDebtPaymentToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDebtPaymentToBasket($iSaleFacade_AddDebtPaymentToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUnpayItemToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddUnpayItemToBasketRequest $iSaleFacade_AddUnpayItemToBasket_RequestMsg
     * @return \patest\StructType\AddUnpayItemToBasketResponse|bool
     */
    public function AddUnpayItemToBasket(\patest\StructType\AddUnpayItemToBasketRequest $iSaleFacade_AddUnpayItemToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUnpayItemToBasket($iSaleFacade_AddUnpayItemToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMultipleUnpayItemsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddMultipleUnpayItemsToBasketRequest $iSaleFacade_AddMultipleUnpayItemsToBasket_RequestMsg
     * @return \patest\StructType\AddMultipleUnpayItemsToBasketResponse|bool
     */
    public function AddMultipleUnpayItemsToBasket(\patest\StructType\AddMultipleUnpayItemsToBasketRequest $iSaleFacade_AddMultipleUnpayItemsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddMultipleUnpayItemsToBasket($iSaleFacade_AddMultipleUnpayItemsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDraftInvoiceContentToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddDraftInvoiceContentToBasketRequest $iSaleFacade_AddDraftInvoiceContentToBasket_RequestMsg
     * @return \patest\StructType\AddDraftInvoiceContentToBasketResponse|bool
     */
    public function AddDraftInvoiceContentToBasket(\patest\StructType\AddDraftInvoiceContentToBasketRequest $iSaleFacade_AddDraftInvoiceContentToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDraftInvoiceContentToBasket($iSaleFacade_AddDraftInvoiceContentToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddInvoiceContentToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddInvoiceContentToBasketRequest $iSaleFacade_AddInvoiceContentToBasket_RequestMsg
     * @return \patest\StructType\AddInvoiceContentToBasketResponse|bool
     */
    public function AddInvoiceContentToBasket(\patest\StructType\AddInvoiceContentToBasketRequest $iSaleFacade_AddInvoiceContentToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddInvoiceContentToBasket($iSaleFacade_AddInvoiceContentToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSubscriptionsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddSubscriptionsToBasketRequest $iSubscriptionFacade_AddSubscriptionsToBasket_RequestMsg
     * @return \patest\StructType\AddSubscriptionsToBasketResponse|bool
     */
    public function AddSubscriptionsToBasket(\patest\StructType\AddSubscriptionsToBasketRequest $iSubscriptionFacade_AddSubscriptionsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSubscriptionsToBasket($iSubscriptionFacade_AddSubscriptionsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddRelocationAddOnSubscriptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddRelocationAddOnSubscriptions_Request $iSubscriptionFacade_AddRelocationAddOnSubscriptions_RequestMsg
     * @return \patest\StructType\AddRelocationAddOnSubscriptions_Response|bool
     */
    public function AddRelocationAddOnSubscriptions(\patest\StructType\AddRelocationAddOnSubscriptions_Request $iSubscriptionFacade_AddRelocationAddOnSubscriptions_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddRelocationAddOnSubscriptions($iSubscriptionFacade_AddRelocationAddOnSubscriptions_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTicketsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddTicketsToBasket_Request $iTicketingFacade_AddTicketsToBasket_RequestMsg
     * @return \patest\StructType\AddTicketsToBasket_Response|bool
     */
    public function AddTicketsToBasket(\patest\StructType\AddTicketsToBasket_Request $iTicketingFacade_AddTicketsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddTicketsToBasket($iTicketingFacade_AddTicketsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMultiEventTicketsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddMultiEventTicketsToBasket_Request $iTicketingFacade_AddMultiEventTicketsToBasket_RequestMsg
     * @return \patest\StructType\AddMultiEventTicketsToBasket_Response|bool
     */
    public function AddMultiEventTicketsToBasket(\patest\StructType\AddMultiEventTicketsToBasket_Request $iTicketingFacade_AddMultiEventTicketsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddMultiEventTicketsToBasket($iTicketingFacade_AddMultiEventTicketsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddPriceListRuleToEvent
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddPriceListRuleToEvent_Request $iTicketingFacade_AddPriceListRuleToEvent_RequestMsg
     * @return \patest\StructType\AddPriceListRuleToEvent_Response|bool
     */
    public function AddPriceListRuleToEvent(\patest\StructType\AddPriceListRuleToEvent_Request $iTicketingFacade_AddPriceListRuleToEvent_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPriceListRuleToEvent($iTicketingFacade_AddPriceListRuleToEvent_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddResaleTicketsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddResaleTicketsToBasket_Request $iTicketingFacade_AddResaleTicketsToBasket_RequestMsg
     * @return \patest\StructType\AddResaleTicketsToBasket_Response|bool
     */
    public function AddResaleTicketsToBasket(\patest\StructType\AddResaleTicketsToBasket_Request $iTicketingFacade_AddResaleTicketsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddResaleTicketsToBasket($iTicketingFacade_AddResaleTicketsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddEventToTicketScheme
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddEventToTicketScheme_Request $iTicketingFacade_AddEventToTicketScheme_RequestMsg
     * @return \patest\StructType\AddEventToTicketScheme_Response|bool
     */
    public function AddEventToTicketScheme(\patest\StructType\AddEventToTicketScheme_Request $iTicketingFacade_AddEventToTicketScheme_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddEventToTicketScheme($iTicketingFacade_AddEventToTicketScheme_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddFullStackExchangeItemsToBasket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddFullStackExchangeItemsToBasket_Request $iTicketingFacade_AddFullStackExchangeItemsToBasket_RequestMsg
     * @return \patest\StructType\AddFullStackExchangeItemsToBasket_Response|bool
     */
    public function AddFullStackExchangeItemsToBasket(\patest\StructType\AddFullStackExchangeItemsToBasket_Request $iTicketingFacade_AddFullStackExchangeItemsToBasket_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddFullStackExchangeItemsToBasket($iTicketingFacade_AddFullStackExchangeItemsToBasket_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAccessCodesToPresale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddAccessCodesToPresale_Request $iTicketingFacade_AddAccessCodesToPresale_RequestMsg
     * @return \patest\StructType\AddAccessCodesToPresale_Response|bool
     */
    public function AddAccessCodesToPresale(\patest\StructType\AddAccessCodesToPresale_Request $iTicketingFacade_AddAccessCodesToPresale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAccessCodesToPresale($iTicketingFacade_AddAccessCodesToPresale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAccessCodesToPresaleAsync
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\AddAccessCodesToPresale_Request $iTicketingFacade_AddAccessCodesToPresaleAsync_RequestMsg
     * @return \patest\StructType\AddAccessCodesToPresaleAsync_Response|bool
     */
    public function AddAccessCodesToPresaleAsync(\patest\StructType\AddAccessCodesToPresale_Request $iTicketingFacade_AddAccessCodesToPresaleAsync_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAccessCodesToPresaleAsync($iTicketingFacade_AddAccessCodesToPresaleAsync_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\AddAccessCodesToPresaleAsync_Response|\patest\StructType\AddAccessCodesToPresale_Response|\patest\StructType\AddAdHocRefundToBasket_Response|\patest\StructType\AddBundleToBasket_Response|\patest\StructType\AddCancellationPaymentToBasket_Response|\patest\StructType\AddCardLoadingToBasketResponse|\patest\StructType\AddClientCredit_Response|\patest\StructType\AddDebtPaymentToBasketResponse|\patest\StructType\AddDeliveryToBasket_Response|\patest\StructType\AddDonationToBasket_Response|\patest\StructType\AddDraftInvoiceContentToBasketResponse|\patest\StructType\AddEntityManagementQueryTokenContextResponse|\patest\StructType\AddEventToTicketScheme_Response|\patest\StructType\AddFullStackExchangeItemsToBasket_Response|\patest\StructType\AddGiftVouchersToBasket_Response|\patest\StructType\AddGuidanceToBasketResponse|\patest\StructType\AddInvoiceContentToBasketResponse|\patest\StructType\AddLinkedClientResponse|\patest\StructType\AddMembershipsToBasket_Response|\patest\StructType\AddMerchandiseToBasket_Response|\patest\StructType\AddMultiEventTicketsToBasket_Response|\patest\StructType\AddMultipleUnpayItemsToBasketResponse|\patest\StructType\AddPaymentToBasket_Response|\patest\StructType\AddPriceListRuleToEvent_Response|\patest\StructType\AddProductsToBasketResponse|\patest\StructType\AddPromptExtraProductsToBasket_Response|\patest\StructType\AddRelocationAddOnSubscriptions_Response|\patest\StructType\AddResaleTicketsToBasket_Response|\patest\StructType\AddSubscriptionsToBasketResponse|\patest\StructType\AddTicketSchemeEnrollments_Response|\patest\StructType\AddTicketsToBasket_Response|\patest\StructType\AddUnpayItemToBasketResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
