<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for UserSeatAvailabilities EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UserSeatAvailabilities
 * @subpackage Enumerations
 */
class UserSeatAvailabilities extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Available'
     * @return string 'Available'
     */
    const VALUE_AVAILABLE = 'Available';
    /**
     * Constant for value 'AvailableTemporarilyHeld'
     * @return string 'AvailableTemporarilyHeld'
     */
    const VALUE_AVAILABLE_TEMPORARILY_HELD = 'AvailableTemporarilyHeld';
    /**
     * Constant for value 'UnavailableTemporarilyHeld'
     * @return string 'UnavailableTemporarilyHeld'
     */
    const VALUE_UNAVAILABLE_TEMPORARILY_HELD = 'UnavailableTemporarilyHeld';
    /**
     * Constant for value 'UnavailableCommittedSold'
     * @return string 'UnavailableCommittedSold'
     */
    const VALUE_UNAVAILABLE_COMMITTED_SOLD = 'UnavailableCommittedSold';
    /**
     * Constant for value 'UnavailableCommittedReserved'
     * @return string 'UnavailableCommittedReserved'
     */
    const VALUE_UNAVAILABLE_COMMITTED_RESERVED = 'UnavailableCommittedReserved';
    /**
     * Constant for value 'Unavailable'
     * @return string 'Unavailable'
     */
    const VALUE_UNAVAILABLE = 'Unavailable';
    /**
     * Constant for value 'OccupiedByPeer'
     * @return string 'OccupiedByPeer'
     */
    const VALUE_OCCUPIED_BY_PEER = 'OccupiedByPeer';
    /**
     * Constant for value 'LockedQualified'
     * @return string 'LockedQualified'
     */
    const VALUE_LOCKED_QUALIFIED = 'LockedQualified';
    /**
     * Constant for value 'LockedUnqualified'
     * @return string 'LockedUnqualified'
     */
    const VALUE_LOCKED_UNQUALIFIED = 'LockedUnqualified';
    /**
     * Constant for value 'LockedUnlockable'
     * @return string 'LockedUnlockable'
     */
    const VALUE_LOCKED_UNLOCKABLE = 'LockedUnlockable';
    /**
     * Constant for value 'LockHeldForSubscriber'
     * @return string 'LockHeldForSubscriber'
     */
    const VALUE_LOCK_HELD_FOR_SUBSCRIBER = 'LockHeldForSubscriber';
    /**
     * Constant for value 'AllocatedQualified'
     * @return string 'AllocatedQualified'
     */
    const VALUE_ALLOCATED_QUALIFIED = 'AllocatedQualified';
    /**
     * Constant for value 'AllocatedUnqualified'
     * @return string 'AllocatedUnqualified'
     */
    const VALUE_ALLOCATED_UNQUALIFIED = 'AllocatedUnqualified';
    /**
     * Constant for value 'NotAllocated'
     * @return string 'NotAllocated'
     */
    const VALUE_NOT_ALLOCATED = 'NotAllocated';
    /**
     * Constant for value 'AllocatedForSubscription'
     * @return string 'AllocatedForSubscription'
     */
    const VALUE_ALLOCATED_FOR_SUBSCRIPTION = 'AllocatedForSubscription';
    /**
     * Constant for value 'ReturnedInTransaction'
     * @return string 'ReturnedInTransaction'
     */
    const VALUE_RETURNED_IN_TRANSACTION = 'ReturnedInTransaction';
    /**
     * Constant for value 'IntendedForClient'
     * @return string 'IntendedForClient'
     */
    const VALUE_INTENDED_FOR_CLIENT = 'IntendedForClient';
    /**
     * Constant for value 'SubscriptionBonusTicket'
     * @return string 'SubscriptionBonusTicket'
     */
    const VALUE_SUBSCRIPTION_BONUS_TICKET = 'SubscriptionBonusTicket';
    /**
     * Constant for value 'ComplimentaryTicket'
     * @return string 'ComplimentaryTicket'
     */
    const VALUE_COMPLIMENTARY_TICKET = 'ComplimentaryTicket';
    /**
     * Constant for value 'AvailabilityStatusMask'
     * @return string 'AvailabilityStatusMask'
     */
    const VALUE_AVAILABILITY_STATUS_MASK = 'AvailabilityStatusMask';
    /**
     * Constant for value 'LockStatusMask'
     * @return string 'LockStatusMask'
     */
    const VALUE_LOCK_STATUS_MASK = 'LockStatusMask';
    /**
     * Constant for value 'AllocationStatusMask'
     * @return string 'AllocationStatusMask'
     */
    const VALUE_ALLOCATION_STATUS_MASK = 'AllocationStatusMask';
    /**
     * Return allowed values
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_AVAILABLE_TEMPORARILY_HELD
     * @uses self::VALUE_UNAVAILABLE_TEMPORARILY_HELD
     * @uses self::VALUE_UNAVAILABLE_COMMITTED_SOLD
     * @uses self::VALUE_UNAVAILABLE_COMMITTED_RESERVED
     * @uses self::VALUE_UNAVAILABLE
     * @uses self::VALUE_OCCUPIED_BY_PEER
     * @uses self::VALUE_LOCKED_QUALIFIED
     * @uses self::VALUE_LOCKED_UNQUALIFIED
     * @uses self::VALUE_LOCKED_UNLOCKABLE
     * @uses self::VALUE_LOCK_HELD_FOR_SUBSCRIBER
     * @uses self::VALUE_ALLOCATED_QUALIFIED
     * @uses self::VALUE_ALLOCATED_UNQUALIFIED
     * @uses self::VALUE_NOT_ALLOCATED
     * @uses self::VALUE_ALLOCATED_FOR_SUBSCRIPTION
     * @uses self::VALUE_RETURNED_IN_TRANSACTION
     * @uses self::VALUE_INTENDED_FOR_CLIENT
     * @uses self::VALUE_SUBSCRIPTION_BONUS_TICKET
     * @uses self::VALUE_COMPLIMENTARY_TICKET
     * @uses self::VALUE_AVAILABILITY_STATUS_MASK
     * @uses self::VALUE_LOCK_STATUS_MASK
     * @uses self::VALUE_ALLOCATION_STATUS_MASK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVAILABLE,
            self::VALUE_AVAILABLE_TEMPORARILY_HELD,
            self::VALUE_UNAVAILABLE_TEMPORARILY_HELD,
            self::VALUE_UNAVAILABLE_COMMITTED_SOLD,
            self::VALUE_UNAVAILABLE_COMMITTED_RESERVED,
            self::VALUE_UNAVAILABLE,
            self::VALUE_OCCUPIED_BY_PEER,
            self::VALUE_LOCKED_QUALIFIED,
            self::VALUE_LOCKED_UNQUALIFIED,
            self::VALUE_LOCKED_UNLOCKABLE,
            self::VALUE_LOCK_HELD_FOR_SUBSCRIBER,
            self::VALUE_ALLOCATED_QUALIFIED,
            self::VALUE_ALLOCATED_UNQUALIFIED,
            self::VALUE_NOT_ALLOCATED,
            self::VALUE_ALLOCATED_FOR_SUBSCRIPTION,
            self::VALUE_RETURNED_IN_TRANSACTION,
            self::VALUE_INTENDED_FOR_CLIENT,
            self::VALUE_SUBSCRIPTION_BONUS_TICKET,
            self::VALUE_COMPLIMENTARY_TICKET,
            self::VALUE_AVAILABILITY_STATUS_MASK,
            self::VALUE_LOCK_STATUS_MASK,
            self::VALUE_ALLOCATION_STATUS_MASK,
        );
    }
}
