<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransactionState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionState
 * @subpackage Enumerations
 */
class TransactionState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Created'
     * @return string 'Created'
     */
    const VALUE_CREATED = 'Created';
    /**
     * Constant for value 'CommittedConfirmed'
     * @return string 'CommittedConfirmed'
     */
    const VALUE_COMMITTED_CONFIRMED = 'CommittedConfirmed';
    /**
     * Constant for value 'CommittedUnconfirmed'
     * @return string 'CommittedUnconfirmed'
     */
    const VALUE_COMMITTED_UNCONFIRMED = 'CommittedUnconfirmed';
    /**
     * Constant for value 'Compensated'
     * @return string 'Compensated'
     */
    const VALUE_COMPENSATED = 'Compensated';
    /**
     * Constant for value 'FailedToRollback'
     * @return string 'FailedToRollback'
     */
    const VALUE_FAILED_TO_ROLLBACK = 'FailedToRollback';
    /**
     * Constant for value 'FailedToCompensate'
     * @return string 'FailedToCompensate'
     */
    const VALUE_FAILED_TO_COMPENSATE = 'FailedToCompensate';
    /**
     * Constant for value 'CommittedSuspected'
     * @return string 'CommittedSuspected'
     */
    const VALUE_COMMITTED_SUSPECTED = 'CommittedSuspected';
    /**
     * Constant for value 'CommittedDeclined'
     * @return string 'CommittedDeclined'
     */
    const VALUE_COMMITTED_DECLINED = 'CommittedDeclined';
    /**
     * Constant for value 'Discarded'
     * @return string 'Discarded'
     */
    const VALUE_DISCARDED = 'Discarded';
    /**
     * Return allowed values
     * @uses self::VALUE_CREATED
     * @uses self::VALUE_COMMITTED_CONFIRMED
     * @uses self::VALUE_COMMITTED_UNCONFIRMED
     * @uses self::VALUE_COMPENSATED
     * @uses self::VALUE_FAILED_TO_ROLLBACK
     * @uses self::VALUE_FAILED_TO_COMPENSATE
     * @uses self::VALUE_COMMITTED_SUSPECTED
     * @uses self::VALUE_COMMITTED_DECLINED
     * @uses self::VALUE_DISCARDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREATED,
            self::VALUE_COMMITTED_CONFIRMED,
            self::VALUE_COMMITTED_UNCONFIRMED,
            self::VALUE_COMPENSATED,
            self::VALUE_FAILED_TO_ROLLBACK,
            self::VALUE_FAILED_TO_COMPENSATE,
            self::VALUE_COMMITTED_SUSPECTED,
            self::VALUE_COMMITTED_DECLINED,
            self::VALUE_DISCARDED,
        );
    }
}
