<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransactionMessageInfoType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionMessageInfoType
 * @subpackage Enumerations
 */
class TransactionMessageInfoType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Client'
     * @return string 'Client'
     */
    const VALUE_CLIENT = 'Client';
    /**
     * Constant for value 'Reservation'
     * @return string 'Reservation'
     */
    const VALUE_RESERVATION = 'Reservation';
    /**
     * Constant for value 'Complimentary'
     * @return string 'Complimentary'
     */
    const VALUE_COMPLIMENTARY = 'Complimentary';
    /**
     * Constant for value 'Delivery'
     * @return string 'Delivery'
     */
    const VALUE_DELIVERY = 'Delivery';
    /**
     * Constant for value 'Note'
     * @return string 'Note'
     */
    const VALUE_NOTE = 'Note';
    /**
     * Constant for value 'PriceType'
     * @return string 'PriceType'
     */
    const VALUE_PRICE_TYPE = 'PriceType';
    /**
     * Constant for value 'ItemReturnReason'
     * @return string 'ItemReturnReason'
     */
    const VALUE_ITEM_RETURN_REASON = 'ItemReturnReason';
    /**
     * Constant for value 'ReprintReason'
     * @return string 'ReprintReason'
     */
    const VALUE_REPRINT_REASON = 'ReprintReason';
    /**
     * Constant for value 'Barcode'
     * @return string 'Barcode'
     */
    const VALUE_BARCODE = 'Barcode';
    /**
     * Constant for value 'General'
     * @return string 'General'
     */
    const VALUE_GENERAL = 'General';
    /**
     * Return allowed values
     * @uses self::VALUE_CLIENT
     * @uses self::VALUE_RESERVATION
     * @uses self::VALUE_COMPLIMENTARY
     * @uses self::VALUE_DELIVERY
     * @uses self::VALUE_NOTE
     * @uses self::VALUE_PRICE_TYPE
     * @uses self::VALUE_ITEM_RETURN_REASON
     * @uses self::VALUE_REPRINT_REASON
     * @uses self::VALUE_BARCODE
     * @uses self::VALUE_GENERAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLIENT,
            self::VALUE_RESERVATION,
            self::VALUE_COMPLIMENTARY,
            self::VALUE_DELIVERY,
            self::VALUE_NOTE,
            self::VALUE_PRICE_TYPE,
            self::VALUE_ITEM_RETURN_REASON,
            self::VALUE_REPRINT_REASON,
            self::VALUE_BARCODE,
            self::VALUE_GENERAL,
        );
    }
}
