<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TicketSchemePaymentOption EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketSchemePaymentOption
 * @subpackage Enumerations
 */
class TicketSchemePaymentOption extends AbstractStructEnumBase
{
    /**
     * Constant for value 'RequiresPayment'
     * @return string 'RequiresPayment'
     */
    const VALUE_REQUIRES_PAYMENT = 'RequiresPayment';
    /**
     * Constant for value 'DoesNotRequirePaymentWithUnpaidTickets'
     * @return string 'DoesNotRequirePaymentWithUnpaidTickets'
     */
    const VALUE_DOES_NOT_REQUIRE_PAYMENT_WITH_UNPAID_TICKETS = 'DoesNotRequirePaymentWithUnpaidTickets';
    /**
     * Constant for value 'DoesNotRequirePaymentWithFreeTickets'
     * @return string 'DoesNotRequirePaymentWithFreeTickets'
     */
    const VALUE_DOES_NOT_REQUIRE_PAYMENT_WITH_FREE_TICKETS = 'DoesNotRequirePaymentWithFreeTickets';
    /**
     * Constant for value 'RequiresPaymentExceptSpecifiedPriceTypes'
     * @return string 'RequiresPaymentExceptSpecifiedPriceTypes'
     */
    const VALUE_REQUIRES_PAYMENT_EXCEPT_SPECIFIED_PRICE_TYPES = 'RequiresPaymentExceptSpecifiedPriceTypes';
    /**
     * Return allowed values
     * @uses self::VALUE_REQUIRES_PAYMENT
     * @uses self::VALUE_DOES_NOT_REQUIRE_PAYMENT_WITH_UNPAID_TICKETS
     * @uses self::VALUE_DOES_NOT_REQUIRE_PAYMENT_WITH_FREE_TICKETS
     * @uses self::VALUE_REQUIRES_PAYMENT_EXCEPT_SPECIFIED_PRICE_TYPES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REQUIRES_PAYMENT,
            self::VALUE_DOES_NOT_REQUIRE_PAYMENT_WITH_UNPAID_TICKETS,
            self::VALUE_DOES_NOT_REQUIRE_PAYMENT_WITH_FREE_TICKETS,
            self::VALUE_REQUIRES_PAYMENT_EXCEPT_SPECIFIED_PRICE_TYPES,
        );
    }
}
