<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for StructuredCodeIntegrityTypes EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StructuredCodeIntegrityTypes
 * @subpackage Enumerations
 */
class StructuredCodeIntegrityTypes extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Undefined'
     * @return string 'Undefined'
     */
    const VALUE_UNDEFINED = 'Undefined';
    /**
     * Constant for value 'InvalidFormat'
     * @return string 'InvalidFormat'
     */
    const VALUE_INVALID_FORMAT = 'InvalidFormat';
    /**
     * Constant for value 'Duplicate'
     * @return string 'Duplicate'
     */
    const VALUE_DUPLICATE = 'Duplicate';
    /**
     * Constant for value 'Valid'
     * @return string 'Valid'
     */
    const VALUE_VALID = 'Valid';
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_INVALID_FORMAT
     * @uses self::VALUE_DUPLICATE
     * @uses self::VALUE_VALID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_INVALID_FORMAT,
            self::VALUE_DUPLICATE,
            self::VALUE_VALID,
        );
    }
}
