<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SpoolItemStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SpoolItemStatus
 * @subpackage Enumerations
 */
class SpoolItemStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Waiting'
     * @return string 'Waiting'
     */
    const VALUE_WAITING = 'Waiting';
    /**
     * Constant for value 'InProcess'
     * @return string 'InProcess'
     */
    const VALUE_IN_PROCESS = 'InProcess';
    /**
     * Constant for value 'Printing'
     * @return string 'Printing'
     */
    const VALUE_PRINTING = 'Printing';
    /**
     * Constant for value 'Printed'
     * @return string 'Printed'
     */
    const VALUE_PRINTED = 'Printed';
    /**
     * Constant for value 'Aborted'
     * @return string 'Aborted'
     */
    const VALUE_ABORTED = 'Aborted';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return allowed values
     * @uses self::VALUE_WAITING
     * @uses self::VALUE_IN_PROCESS
     * @uses self::VALUE_PRINTING
     * @uses self::VALUE_PRINTED
     * @uses self::VALUE_ABORTED
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WAITING,
            self::VALUE_IN_PROCESS,
            self::VALUE_PRINTING,
            self::VALUE_PRINTED,
            self::VALUE_ABORTED,
            self::VALUE_ERROR,
        );
    }
}
