<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ScanningRequestStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ScanningRequestStatus
 * @subpackage Enumerations
 */
class ScanningRequestStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Scanned'
     * @return string 'Scanned'
     */
    const VALUE_SCANNED = 'Scanned';
    /**
     * Constant for value 'NotScannedYet'
     * @return string 'NotScannedYet'
     */
    const VALUE_NOT_SCANNED_YET = 'NotScannedYet';
    /**
     * Constant for value 'BarcodeNotFound'
     * @return string 'BarcodeNotFound'
     */
    const VALUE_BARCODE_NOT_FOUND = 'BarcodeNotFound';
    /**
     * Constant for value 'TicketNotFound'
     * @return string 'TicketNotFound'
     */
    const VALUE_TICKET_NOT_FOUND = 'TicketNotFound';
    /**
     * Constant for value 'BarcodeIsNotActive'
     * @return string 'BarcodeIsNotActive'
     */
    const VALUE_BARCODE_IS_NOT_ACTIVE = 'BarcodeIsNotActive';
    /**
     * Constant for value 'TicketIsNotValid'
     * @return string 'TicketIsNotValid'
     */
    const VALUE_TICKET_IS_NOT_VALID = 'TicketIsNotValid';
    /**
     * Constant for value 'BarcodeIsNotRelatedToTicket'
     * @return string 'BarcodeIsNotRelatedToTicket'
     */
    const VALUE_BARCODE_IS_NOT_RELATED_TO_TICKET = 'BarcodeIsNotRelatedToTicket';
    /**
     * Return allowed values
     * @uses self::VALUE_SCANNED
     * @uses self::VALUE_NOT_SCANNED_YET
     * @uses self::VALUE_BARCODE_NOT_FOUND
     * @uses self::VALUE_TICKET_NOT_FOUND
     * @uses self::VALUE_BARCODE_IS_NOT_ACTIVE
     * @uses self::VALUE_TICKET_IS_NOT_VALID
     * @uses self::VALUE_BARCODE_IS_NOT_RELATED_TO_TICKET
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SCANNED,
            self::VALUE_NOT_SCANNED_YET,
            self::VALUE_BARCODE_NOT_FOUND,
            self::VALUE_TICKET_NOT_FOUND,
            self::VALUE_BARCODE_IS_NOT_ACTIVE,
            self::VALUE_TICKET_IS_NOT_VALID,
            self::VALUE_BARCODE_IS_NOT_RELATED_TO_TICKET,
        );
    }
}
