<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ResaleStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResaleStatus
 * @subpackage Enumerations
 */
class ResaleStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PendingResale'
     * @return string 'PendingResale'
     */
    const VALUE_PENDING_RESALE = 'PendingResale';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'Resold'
     * @return string 'Resold'
     */
    const VALUE_RESOLD = 'Resold';
    /**
     * Constant for value 'ResoldRefunded'
     * @return string 'ResoldRefunded'
     */
    const VALUE_RESOLD_REFUNDED = 'ResoldRefunded';
    /**
     * Constant for value 'RefundFailed'
     * @return string 'RefundFailed'
     */
    const VALUE_REFUND_FAILED = 'RefundFailed';
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING_RESALE
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_RESOLD
     * @uses self::VALUE_RESOLD_REFUNDED
     * @uses self::VALUE_REFUND_FAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING_RESALE,
            self::VALUE_CANCELED,
            self::VALUE_RESOLD,
            self::VALUE_RESOLD_REFUNDED,
            self::VALUE_REFUND_FAILED,
        );
    }
}
