<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ProcessInstanceState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProcessInstanceState
 * @subpackage Enumerations
 */
class ProcessInstanceState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Stopped'
     * @return string 'Stopped'
     */
    const VALUE_STOPPED = 'Stopped';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'Started'
     * @return string 'Started'
     */
    const VALUE_STARTED = 'Started';
    /**
     * Constant for value 'Working'
     * @return string 'Working'
     */
    const VALUE_WORKING = 'Working';
    /**
     * Constant for value 'Aborting'
     * @return string 'Aborting'
     */
    const VALUE_ABORTING = 'Aborting';
    /**
     * Constant for value 'Stopping'
     * @return string 'Stopping'
     */
    const VALUE_STOPPING = 'Stopping';
    /**
     * Return allowed values
     * @uses self::VALUE_STOPPED
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_STARTED
     * @uses self::VALUE_WORKING
     * @uses self::VALUE_ABORTING
     * @uses self::VALUE_STOPPING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STOPPED,
            self::VALUE_ERROR,
            self::VALUE_STARTED,
            self::VALUE_WORKING,
            self::VALUE_ABORTING,
            self::VALUE_STOPPING,
        );
    }
}
