<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PriceModifierType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceModifierType
 * @subpackage Enumerations
 */
class PriceModifierType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Commission'
     * @return string 'Commission'
     */
    const VALUE_COMMISSION = 'Commission';
    /**
     * Constant for value 'Discount'
     * @return string 'Discount'
     */
    const VALUE_DISCOUNT = 'Discount';
    /**
     * Constant for value 'Tax'
     * @return string 'Tax'
     */
    const VALUE_TAX = 'Tax';
    /**
     * Constant for value 'Subsidy'
     * @return string 'Subsidy'
     */
    const VALUE_SUBSIDY = 'Subsidy';
    /**
     * Constant for value 'Vat'
     * @return string 'Vat'
     */
    const VALUE_VAT = 'Vat';
    /**
     * Constant for value 'InsideCommission'
     * @return string 'InsideCommission'
     */
    const VALUE_INSIDE_COMMISSION = 'InsideCommission';
    /**
     * Constant for value 'CommissionOnPayment'
     * @return string 'CommissionOnPayment'
     */
    const VALUE_COMMISSION_ON_PAYMENT = 'CommissionOnPayment';
    /**
     * Constant for value 'CancellationInsurance'
     * @return string 'CancellationInsurance'
     */
    const VALUE_CANCELLATION_INSURANCE = 'CancellationInsurance';
    /**
     * Constant for value 'ExtraCharge'
     * @return string 'ExtraCharge'
     */
    const VALUE_EXTRA_CHARGE = 'ExtraCharge';
    /**
     * Constant for value 'ThirdPartyVat'
     * @return string 'ThirdPartyVat'
     */
    const VALUE_THIRD_PARTY_VAT = 'ThirdPartyVat';
    /**
     * Constant for value 'FeeBand'
     * @return string 'FeeBand'
     */
    const VALUE_FEE_BAND = 'FeeBand';
    /**
     * Constant for value 'ProcessingFee'
     * @return string 'ProcessingFee'
     */
    const VALUE_PROCESSING_FEE = 'ProcessingFee';
    /**
     * Return allowed values
     * @uses self::VALUE_COMMISSION
     * @uses self::VALUE_DISCOUNT
     * @uses self::VALUE_TAX
     * @uses self::VALUE_SUBSIDY
     * @uses self::VALUE_VAT
     * @uses self::VALUE_INSIDE_COMMISSION
     * @uses self::VALUE_COMMISSION_ON_PAYMENT
     * @uses self::VALUE_CANCELLATION_INSURANCE
     * @uses self::VALUE_EXTRA_CHARGE
     * @uses self::VALUE_THIRD_PARTY_VAT
     * @uses self::VALUE_FEE_BAND
     * @uses self::VALUE_PROCESSING_FEE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMISSION,
            self::VALUE_DISCOUNT,
            self::VALUE_TAX,
            self::VALUE_SUBSIDY,
            self::VALUE_VAT,
            self::VALUE_INSIDE_COMMISSION,
            self::VALUE_COMMISSION_ON_PAYMENT,
            self::VALUE_CANCELLATION_INSURANCE,
            self::VALUE_EXTRA_CHARGE,
            self::VALUE_THIRD_PARTY_VAT,
            self::VALUE_FEE_BAND,
            self::VALUE_PROCESSING_FEE,
        );
    }
}
