<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentPaidStatusType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentPaidStatusType
 * @subpackage Enumerations
 */
class PaymentPaidStatusType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotSpecified'
     * @return string 'NotSpecified'
     */
    const VALUE_NOT_SPECIFIED = 'NotSpecified';
    /**
     * Constant for value 'FullyPaid'
     * @return string 'FullyPaid'
     */
    const VALUE_FULLY_PAID = 'FullyPaid';
    /**
     * Constant for value 'Unpaid'
     * @return string 'Unpaid'
     */
    const VALUE_UNPAID = 'Unpaid';
    /**
     * Constant for value 'PartiallyUnpaid'
     * @return string 'PartiallyUnpaid'
     */
    const VALUE_PARTIALLY_UNPAID = 'PartiallyUnpaid';
    /**
     * Constant for value 'RelatedToAnotherUnpaid'
     * @return string 'RelatedToAnotherUnpaid'
     */
    const VALUE_RELATED_TO_ANOTHER_UNPAID = 'RelatedToAnotherUnpaid';
    /**
     * Constant for value 'PendingInstallments'
     * @return string 'PendingInstallments'
     */
    const VALUE_PENDING_INSTALLMENTS = 'PendingInstallments';
    /**
     * Constant for value 'Reserved'
     * @return string 'Reserved'
     */
    const VALUE_RESERVED = 'Reserved';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SPECIFIED
     * @uses self::VALUE_FULLY_PAID
     * @uses self::VALUE_UNPAID
     * @uses self::VALUE_PARTIALLY_UNPAID
     * @uses self::VALUE_RELATED_TO_ANOTHER_UNPAID
     * @uses self::VALUE_PENDING_INSTALLMENTS
     * @uses self::VALUE_RESERVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SPECIFIED,
            self::VALUE_FULLY_PAID,
            self::VALUE_UNPAID,
            self::VALUE_PARTIALLY_UNPAID,
            self::VALUE_RELATED_TO_ANOTHER_UNPAID,
            self::VALUE_PENDING_INSTALLMENTS,
            self::VALUE_RESERVED,
        );
    }
}
