<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaidState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaidState
 * @subpackage Enumerations
 */
class PaidState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Paid'
     * @return string 'Paid'
     */
    const VALUE_PAID = 'Paid';
    /**
     * Constant for value 'NotPaid'
     * @return string 'NotPaid'
     */
    const VALUE_NOT_PAID = 'NotPaid';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'Returned'
     * @return string 'Returned'
     */
    const VALUE_RETURNED = 'Returned';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return allowed values
     * @uses self::VALUE_PAID
     * @uses self::VALUE_NOT_PAID
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_RETURNED
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAID,
            self::VALUE_NOT_PAID,
            self::VALUE_FAILED,
            self::VALUE_RETURNED,
            self::VALUE_ALL,
        );
    }
}
