<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MembershipStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MembershipStatus
 * @subpackage Enumerations
 */
class MembershipStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Committed'
     * @return string 'Committed'
     */
    const VALUE_COMMITTED = 'Committed';
    /**
     * Constant for value 'Reserved'
     * @return string 'Reserved'
     */
    const VALUE_RESERVED = 'Reserved';
    /**
     * Constant for value 'Confirmed'
     * @return string 'Confirmed'
     */
    const VALUE_CONFIRMED = 'Confirmed';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'Frozen'
     * @return string 'Frozen'
     */
    const VALUE_FROZEN = 'Frozen';
    /**
     * Constant for value 'Expired'
     * @return string 'Expired'
     */
    const VALUE_EXPIRED = 'Expired';
    /**
     * Return allowed values
     * @uses self::VALUE_COMMITTED
     * @uses self::VALUE_RESERVED
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_FROZEN
     * @uses self::VALUE_EXPIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMITTED,
            self::VALUE_RESERVED,
            self::VALUE_CONFIRMED,
            self::VALUE_CANCELED,
            self::VALUE_FROZEN,
            self::VALUE_EXPIRED,
        );
    }
}
