<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for HttpApiRequestState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HttpApiRequestState
 * @subpackage Enumerations
 */
class HttpApiRequestState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Invalid'
     * @return string 'Invalid'
     */
    const VALUE_INVALID = 'Invalid';
    /**
     * Constant for value 'New'
     * @return string 'New'
     */
    const VALUE_NEW = 'New';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Processed'
     * @return string 'Processed'
     */
    const VALUE_PROCESSED = 'Processed';
    /**
     * Constant for value 'ProcessedWithErrors'
     * @return string 'ProcessedWithErrors'
     */
    const VALUE_PROCESSED_WITH_ERRORS = 'ProcessedWithErrors';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Return allowed values
     * @uses self::VALUE_INVALID
     * @uses self::VALUE_NEW
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_PROCESSED
     * @uses self::VALUE_PROCESSED_WITH_ERRORS
     * @uses self::VALUE_FAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INVALID,
            self::VALUE_NEW,
            self::VALUE_PENDING,
            self::VALUE_PROCESSED,
            self::VALUE_PROCESSED_WITH_ERRORS,
            self::VALUE_FAILED,
        );
    }
}
