<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for GiftType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftType
 * @subpackage Enumerations
 */
class GiftType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Cash'
     * @return string 'Cash'
     */
    const VALUE_CASH = 'Cash';
    /**
     * Constant for value 'InKind'
     * @return string 'InKind'
     */
    const VALUE_IN_KIND = 'InKind';
    /**
     * Constant for value 'SoftCredit'
     * @return string 'SoftCredit'
     */
    const VALUE_SOFT_CREDIT = 'SoftCredit';
    /**
     * Constant for value 'Pledge'
     * @return string 'Pledge'
     */
    const VALUE_PLEDGE = 'Pledge';
    /**
     * Constant for value 'MatchingGift'
     * @return string 'MatchingGift'
     */
    const VALUE_MATCHING_GIFT = 'MatchingGift';
    /**
     * Constant for value 'TicketTurnback'
     * @return string 'TicketTurnback'
     */
    const VALUE_TICKET_TURNBACK = 'TicketTurnback';
    /**
     * Return allowed values
     * @uses self::VALUE_CASH
     * @uses self::VALUE_IN_KIND
     * @uses self::VALUE_SOFT_CREDIT
     * @uses self::VALUE_PLEDGE
     * @uses self::VALUE_MATCHING_GIFT
     * @uses self::VALUE_TICKET_TURNBACK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CASH,
            self::VALUE_IN_KIND,
            self::VALUE_SOFT_CREDIT,
            self::VALUE_PLEDGE,
            self::VALUE_MATCHING_GIFT,
            self::VALUE_TICKET_TURNBACK,
        );
    }
}
